//===============================================================================
//  USMC Sniper Rifle.    Brian R. Dempsey
//  
//  This is the UT2004 Sniper Rifle model ported to the original Unreal Tournament.
//  I thought that maybe my beloved UT Sniper Rifle could use a model update,
//  so I figured why not port the UT2004 Sniper Rifle model over to UT, since
//  it was hardly useful in UT2004 anyway due to some suckhead thinking that
//  it should be configured like an 18th Century Muzzleloader primarily to
//  appeal to the sissies who couldn't hack playing the original UT.
//
//  Well this mod/mutator is for the real players who know that the original UT
//  is still the best game of the series. It functions exactly like the default
//  UT Sniper Rifle, just simply gives you an updated model.
//  
//  And NO, I will not ever consider porting that suckass, piece of shit
//  Lightning Gun from UT2004 over to UT---SO DON'T EVEN ASK !!
//===============================================================================

class USMCSniperRifle extends TournamentWeapon;

#exec ANIM  IMPORT ANIM=USMCRifle2mAnims ANIMFILE=models\USMCRifle2m.PSA COMPRESS=1 MAXKEYS=999999

#exec MESH  MODELIMPORT MESH=USMCRifle2mMesh MODELFILE=models\USMCRifle2m.PSK LODSTYLE=10
#exec MESH  ORIGIN MESH=USMCRifle2mMesh X=0 Y=0 Z=0 YAW=-64 PITCH=-10 ROLL=64

#exec MESHMAP   SCALE MESHMAP=USMCRifle2mMesh X=.80 Y=.80 Z=.80
#exec MESH  DEFAULTANIM MESH=USMCRifle2mMesh ANIM=USMCRifle2mAnims

#EXEC ANIM  SEQUENCE ANIM=USMCRifle2mAnims SEQ=Still STARTFRAME=0 NUMFRAMES=1 RATE=60.0000 COMPRESS=1.00 GROUP=None
#EXEC ANIM  SEQUENCE ANIM=USMCRifle2mAnims SEQ=Select STARTFRAME=2 NUMFRAMES=15 RATE=60.0000 COMPRESS=1.00 GROUP=Select
#EXEC ANIM  SEQUENCE ANIM=USMCRifle2mAnims SEQ=Fire STARTFRAME=17 NUMFRAMES=7 RATE=60.0000 COMPRESS=1.00 GROUP=None
#EXEC ANIM  SEQUENCE ANIM=USMCRifle2mAnims SEQ=Fire2 STARTFRAME=24 NUMFRAMES=7 RATE=60.0000 COMPRESS=1.00 GROUP=None
#EXEC ANIM  SEQUENCE ANIM=USMCRifle2mAnims SEQ=Fire3 STARTFRAME=31 NUMFRAMES=7 RATE=60.0000 COMPRESS=1.00 GROUP=None
#EXEC ANIM  SEQUENCE ANIM=USMCRifle2mAnims SEQ=Fire4 STARTFRAME=38 NUMFRAMES=7 RATE=60.0000 COMPRESS=1.00 GROUP=None
#EXEC ANIM  SEQUENCE ANIM=USMCRifle2mAnims SEQ=Fire5 STARTFRAME=45 NUMFRAMES=7 RATE=60.0000 COMPRESS=1.00 GROUP=None
#EXEC ANIM  SEQUENCE ANIM=USMCRifle2mAnims SEQ=Down STARTFRAME=52 NUMFRAMES=9 RATE=60.0000 COMPRESS=1.00 GROUP=None

#exec ANIM DIGEST ANIM=USMCRifle2mAnims  VERBOSE

#EXEC TEXTURE IMPORT NAME=USMCRifleTex0  FILE=TEXTURES\Sniper1.pcx  GROUP=Skins LODSET=2
#EXEC MESHMAP SETTEXTURE MESHMAP=USMCRifle2mMesh NUM=0 TEXTURE=USMCRifleTex0

#exec MESH  MODELIMPORT MESH=USMCRifle3rdMesh MODELFILE=models\USMCRifle3rd.PSK LODSTYLE=10
#exec MESH  ORIGIN MESH=USMCRifle3rdMesh X=0 Y=-12 Z=-20 YAW=-64 PITCH=0 ROLL=64

#exec MESHMAP   SCALE MESHMAP=USMCRifle3rdMesh X=.80 Y=.80 Z=.80
#exec MESH  DEFAULTANIM MESH=USMCRifle3rdMesh ANIM=None


#EXEC MESHMAP SETTEXTURE MESHMAP=USMCRifle3rdMesh NUM=0 TEXTURE=USMCRifleTex0

#exec MESH  MODELIMPORT MESH=USMCSniperRiflePickupMesh MODELFILE=models\USMCSniperRiflePickup.PSK LODSTYLE=10
#exec MESH  ORIGIN MESH=USMCSniperRiflePickupMesh X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=64

#exec MESHMAP   SCALE MESHMAP=USMCSniperRiflePickupMesh X=.80 Y=.80 Z=.80
#exec MESH  DEFAULTANIM MESH=USMCSniperRiflePickupMesh ANIM=None

#EXEC MESHMAP SETTEXTURE MESHMAP=USMCSniperRiflePickupMesh NUM=0 TEXTURE=USMCRifleTex0




var int NumFire;
var name FireAnims[5];
var vector OwnerLocation;
var float StillTime, StillStart;

simulated function PostRender( canvas Canvas )
{
	local PlayerPawn P;
	local float Scale;

	Super.PostRender(Canvas);
	P = PlayerPawn(Owner);
	if ( (P != None) && (P.DesiredFOV != P.DefaultFOV) ) 
	{
		bOwnsCrossHair = true;
		Scale = Canvas.ClipX/640;
		Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
		if ( Level.bHighDetailMode )
			Canvas.Style = ERenderStyle.STY_Translucent;
		else
			Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawIcon(Texture'Botpack.Icons.RReticle', Scale);
		Canvas.SetPos(0.5 * Canvas.ClipX + 64 * Scale, 0.5 * Canvas.ClipY + 96 * Scale);
		Canvas.DrawColor.R = 0;
		Canvas.DrawColor.G = 255;
		Canvas.DrawColor.B = 0;
		Scale = P.DefaultFOV/P.DesiredFOV;
		Canvas.DrawText("X"$int(Scale)$"."$int(10 * Scale - 10 * int(Scale)));
	}
	else
		bOwnsCrossHair = false;
}

function float RateSelf( out int bUseAltMode )
{
	local float dist;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;

	bUseAltMode = 0;
	if ( (Bot(Owner) != None) && Bot(Owner).bSniping )
		return AIRating + 1.15;
	if (  Pawn(Owner).Enemy != None )
	{
		dist = VSize(Pawn(Owner).Enemy.Location - Owner.Location);
		if ( dist > 1200 )
		{
			if ( dist > 2000 )
				return (AIRating + 0.75);
			return (AIRating + FMin(0.0001 * dist, 0.45)); 
		}
	}
	return AIRating;
}

// set which hand is holding weapon
function setHand(float Hand)
{
	Super.SetHand(Hand);
	if ( Hand == 1 )
		Mesh = mesh(DynamicLoadObject("USMCSniperRifle.USMCRifle2mMesh", class'Mesh'));
	else
		Mesh = mesh'USMCRifle2mMesh';
}

simulated function PlayFiring()
{
	local int r;

	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim(FireAnims[Rand(5)],0.125 + 0.125 * FireAdjust, 0.2);

	if ( (PlayerPawn(Owner) != None) 
		&& (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV) )
		bMuzzleFlash++;
}


simulated function bool ClientAltFire( float Value )
{
	GotoState('Zooming');
	return true;
}

function AltFire( float Value )
{
	ClientAltFire(Value);
}

///////////////////////////////////////////////////////
state NormalFire
{
	function EndState()
	{
		Super.EndState();
		OldFlashCount = FlashCount;
	}
		
Begin:
	FlashCount++;
}

function Timer()
{
	local actor targ;
	local float bestAim, bestDist;
	local vector FireDir;
	local Pawn P;

	bestAim = 0.95;
	P = Pawn(Owner);
	if ( P == None )
	{
		GotoState('');
		return;
	}
	if ( VSize(P.Location - OwnerLocation) < 6 )
		StillTime += FMin(2.0, Level.TimeSeconds - StillStart);

	else
		StillTime = 0;
	StillStart = Level.TimeSeconds;
	OwnerLocation = P.Location;
	FireDir = vector(P.ViewRotation);
	targ = P.PickTarget(bestAim, bestDist, FireDir, Owner.Location);
	if ( Pawn(targ) != None )
	{
		SetTimer(1 + 4 * FRand(), false);
		bPointing = true;
		Pawn(targ).WarnTarget(P, 200, FireDir);
	}
	else 
	{
		SetTimer(0.4 + 1.6 * FRand(), false);
		if ( (P.bFire == 0) && (P.bAltFire == 0) )
			bPointing = false;
	}
}	

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local UT_Shellcase s;

	s = Spawn(class'UT_ShellCase',, '', Owner.Location + CalcDrawOffset() + 30 * X + (2.8 * FireOffset.Y+5.0) * Y - Z * 1);
	if ( s != None ) 
	{
		s.DrawScale = 2.0;
		s.Eject(((FRand()*0.3+0.4)*X + (FRand()*0.2+0.2)*Y + (FRand()*0.3+1.0) * Z)*160);              
	}
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(100, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(45,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function Finish()
{
	if ( (Pawn(Owner).bFire!=0) && (FRand() < 0.6) )
		Timer();
	Super.Finish();
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z;
	local actor Other;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(PawnOwner.SoundDampening);
	GetAxes(PawnOwner.ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + PawnOwner.Eyeheight * Z; 
	AdjustedAim = PawnOwner.AdjustAim(1000000, StartTrace, 2*AimError, False, False);	
	X = vector(AdjustedAim);
	EndTrace = StartTrace + 10000 * X; 
	Other = PawnOwner.TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
}


state Idle
{
	function Fire( float Value )
	{
		if ( AmmoType == None )
		{
			// ammocheck
			GiveAmmo(Pawn(Owner));
		}
		if (AmmoType.UseAmmo(1))
		{
			GotoState('NormalFire');
			bCanClientFire = true;
			bPointing=True;
			if ( Owner.IsA('Bot') )
			{
				// simulate bot using zoom
				if ( Bot(Owner).bSniping && (FRand() < 0.65) )
					AimError = AimError/FClamp(StillTime, 1.0, 8.0);
				else if ( VSize(Owner.Location - OwnerLocation) < 6 )
					AimError = AimError/FClamp(0.5 * StillTime, 1.0, 3.0);
				else
					StillTime = 0;
			}
			Pawn(Owner).PlayRecoil(FiringSpeed);
			TraceFire(0.0);
			AimError = Default.AimError;
			ClientFire(Value);
		}
	}


	function BeginState()
	{
		bPointing = false;
		SetTimer(0.4 + 1.6 * FRand(), false);
		Super.BeginState();
	}

	function EndState()
	{	
		SetTimer(0.0, false);
		Super.EndState();
	}
	
Begin:
	bPointing=False;
	if ( AmmoType.AmmoAmount<=0 ) 
		Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
	if ( Pawn(Owner).bFire!=0 ) Fire(0.0);
	Disable('AnimEnd');
	PlayIdleAnim();
}

///////////////////////////////////////////////////////
state Zooming
{
	simulated function Tick(float DeltaTime)
	{
		if ( Pawn(Owner).bAltFire == 0 )
		{
			if ( (PlayerPawn(Owner) != None) && PlayerPawn(Owner).Player.IsA('ViewPort') )
				PlayerPawn(Owner).StopZoom();
			SetTimer(0.0,False);
			GoToState('Idle');
		}
	}

	simulated function BeginState()
	{
		if ( Owner.IsA('PlayerPawn') )
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
				PlayerPawn(Owner).ToggleZoom();
			SetTimer(0.2,True);
		}
		else
		{
			Pawn(Owner).bFire = 1;
			Pawn(Owner).bAltFire = 0;
			Global.Fire(0);
		}
	}
}

///////////////////////////////////////////////////////////
simulated function PlayIdleAnim()
{
	if ( Mesh != PickupViewMesh )
		PlayAnim('Still',1.0, 0.05);
}


defaultproperties
{
    FireAnims(0)=Fire
    FireAnims(1)=Fire2
    FireAnims(2)=Fire3
    FireAnims(3)=Fire4
    FireAnims(4)=Fire5
    WeaponDescription="Classification: USMC Sniper Rifle\n\nRegular Fire: Fires a high powered bullet. Can kill instantly when applied to the cranium of opposing forces. \n\nSecondary Fire: Zooms the rifle in, up to eight times normal vision. Allows you to put a bullet through a fleas' arse at long range.\n\nTechniques: Great for long distance headshots!"
    AmmoName=Class'USMCBulletBox'
    PickupAmmoCount=15
    bInstantHit=True
    bAltInstantHit=True
    FiringSpeed=1.80
    FireOffset=(X=0.00,Y=-5.00,Z=-2.00),
    MyDamageType=shot
    AltDamageType=Decapitated
    shakemag=400.00
    shaketime=0.15
    shakevert=8.00
    AIRating=0.54
    RefireRate=1.00
    AltRefireRate=0.30
    FireSound=Sound'Botpack.SniperRifle.SniperFire'
    SelectSound=Sound'UnrealI.Rifle.RiflePickup'
    DeathMessage="%k blew out %o's brains with a USMC Rifle."
    NameColor=(R=0,G=0,B=255,A=0),
    bDrawMuzzleFlash=True
    MuzzleScale=1.00
    FlashY=0.11
    FlashO=0.01
    FlashC=0.03
    FlashLength=0.02
    FlashS=256
    MFTexture=Texture'Botpack.Rifle.MuzzleFlash2'
    AutoSwitchPriority=5
    InventoryGroup=10
    PickupMessage="You got a USMC Sniper Rifle."
    ItemName="USMC Sniper Rifle"
    PlayerViewOffset=(X=1.00,Y=-1.30,Z=-1.20),
    PlayerViewMesh=SkeletalMesh'USMCRifle2mMesh'
    PlayerViewScale=0.075
    BobDamping=0.98
    PickupViewMesh=SkeletalMesh'USMCSniperRiflePickupMesh'
    PickupViewScale=0.65
    ThirdPersonMesh=SkeletalMesh'USMCRifle3rdMesh'
    ThirdPersonScale=0.50
    StatusIcon=Texture'Botpack.Icons.UseRifle'
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=3
    MuzzleFlashMesh=LodMesh'Botpack.muzzsr3'
    MuzzleFlashScale=0.20
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy3'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    Icon=Texture'Botpack.Icons.UseRifle'
    Rotation=(Pitch=0,Yaw=0,Roll=-1536),
    Mesh='USMCSniperRiflePickupMesh'
    bNoSmooth=False
    CollisionRadius=32.00
    CollisionHeight=8.00
    bFixedRotationDir=False
}

