//--------------------------------------------------------------------------------------------
// UM16A2 weapon mutator, converted by TheDane, thedane_ut@hotmail.com / www.thedanesjoint.com
//--------------------------------------------------------------------------------------------

class UM16A2 extends TournamentWeapon;

#exec TEXTURE IMPORT NAME=UM16A1a FILE=TEXTURES\UM16A1a.bmp GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=UM16A1m FILE=TEXTURES\UM16A1m.bmp GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=UM16A1Vis FILE=TEXTURES\UM16A1Vis.bmp GROUP="Icons" MIPS=OFF FLAGS=2 LODSET=2
#exec TEXTURE IMPORT NAME=UM16A1Scope FILE=TEXTURES\UM16A1Scope.bmp GROUP="Icons" MIPS=OFF FLAGS=2 LODSET=2

#exec AUDIO IMPORT FILE="SOUNDS\m4speed.wav" NAME="M4speed"


#exec MESH IMPORT MESH=TUC_M16A1Main ANIVFILE=MODELS\TUC_M16A1Main_a.3D DATAFILE=MODELS\TUC_M16A1Main_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=TUC_M16A1Main X=50 Y=100 Z=-50 YAW=128 PITCH=0 ROLL=0 //7



#exec MESH SEQUENCE MESH=TUC_M16A1Main SEQ=All                      STARTFRAME=0  NUMFRAMES=72
#exec MESH SEQUENCE MESH=TUC_M16A1Main SEQ=Still                    STARTFRAME=56 NUMFRAMES=1 
#exec MESH SEQUENCE MESH=TUC_M16A1Main SEQ=Down                     STARTFRAME=65 NUMFRAMES=8  RATE=12
#exec MESH SEQUENCE MESH=TUC_M16A1Main SEQ=Fire                     STARTFRAME=7  NUMFRAMES=8  RATE=100
#exec MESH SEQUENCE MESH=TUC_M16A1Main SEQ=Select                   STARTFRAME=0  NUMFRAMES=8  RATE=12 GROUP=Select
#exec MESH SEQUENCE MESH=TUC_M16A1Main SEQ=Reloaded		     STARTFRAME=14 NUMFRAMES=43 RATE=18

#exec MESHMAP NEW   MESHMAP=TUC_M16A1Main MESH=TUC_M16A1Main
#exec MESHMAP SCALE MESHMAP=TUC_M16A1Main X=0.1 Y=0.1 Z=0.2

#exec MESHMAP SCALE MESHMAP=TUC_M16A1Main X=0.030 Y=0.030 Z=0.06
#exec MESHMAP SETTEXTURE MESHMAP=TUC_M16A1Main NUM=0 TEXTURE=UM16A1a
#exec MESHMAP SETTEXTURE MESHMAP=TUC_M16A1Main NUM=1 TEXTURE=UM16A1m
#exec MESHMAP SETTEXTURE MESHMAP=TUC_M16A1Main NUM=2 TEXTURE=UM16A1a
#exec MESHMAP SETTEXTURE MESHMAP=TUC_M16A1Main NUM=3 TEXTURE=UM16A1a
#exec MESHMAP SETTEXTURE MESHMAP=TUC_M16A1Main NUM=4 TEXTURE=UM16A1a

//3rd person

#exec MESH IMPORT MESH=TUC_M16A1Main3rd ANIVFILE=MODELS\TUC_M16A1Main3rd_a.3D DATAFILE=MODELS\TUC_M16A1Main3rd_d.3D
#exec MESH LODPARAMS MESH=TUC_M16A1Main3rd STRENGTH=0.5
#exec MESH ORIGIN MESH=TUC_M16A1Main3rd X=330 Y=0 Z=-60 YAW=128 PITCH=0 ROLL=0
#exec MESH SEQUENCE MESH=TUC_M16A1Main3rd SEQ=All                      STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=TUC_M16A1Main3rd SEQ=still                    STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW   MESHMAP=TUC_M16A1Main3rd MESH=TUC_M16A1Main3rd
#exec MESHMAP SCALE MESHMAP=TUC_M16A1Main3rd X=0.0065 Y=0.0065 Z=0.013 PITCH=64
#exec MESHMAP SETTEXTURE MESHMAP=TUC_M16A1Main3rd NUM=0 TEXTURE=UM16A1a

//pickup

#exec MESH IMPORT MESH=TUC_M16A1Mainpickup ANIVFILE=MODELS\TUC_M16A1Mainpickup_a.3D DATAFILE=MODELS\TUC_M16A1Mainpickup_d.3D
#exec MESH LODPARAMS MESH=TUC_M16A1Mainpickup STRENGTH=0.5
#exec MESH ORIGIN MESH=TUC_M16A1Mainpickup X=330 Y=0 Z=-60 YAW=128 PITCH=0 ROLL=0

#exec MESH SEQUENCE MESH=TUC_M16A1Mainpickup SEQ=All                      STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=TUC_M16A1Mainpickup SEQ=Still                    STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=TUC_M16A1Mainpickup MESH=TUC_M16A1Mainpickup
#exec MESHMAP SCALE MESHMAP=TUC_M16A1Mainpickup X=0.0065 Y=0.0065 Z=0.013


#exec MESHMAP SETTEXTURE MESHMAP=TUC_M16A1Mainpickup NUM=0 TEXTURE=UM16A1a


var int NumFire;
var name FireAnims[5];
var vector OwnerLocation;
var float StillTime, StillStart;
var int		HeadDamage,
		TorsoDamage;
var bool	bTraceFire;

simulated function PostRender( canvas Canvas )
{
     local PlayerPawn P;
     local float Scale;

//     Super.PostRender(Canvas);
     P = PlayerPawn(Owner);
     if ( (P != None) && (P.DesiredFOV != P.DefaultFOV) )
     {
          bOwnsCrossHair = true;
          Scale = Canvas.ClipX/256;
          Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
          Canvas.Style = ERenderStyle.STY_Modulated;
          Canvas.DrawIcon(Texture'UM16A1Vis', Scale);
                      Scale = Canvas.ClipX/640;
          Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
          Canvas.DrawIcon(Texture'UM16A1Scope', Scale);
          Canvas.SetPos(0.5 * Canvas.ClipX + 64 * Scale, 0.5 * Canvas.ClipY + 96 * Scale);
          Canvas.Style = ERenderStyle.STY_Translucent;
          Canvas.DrawColor.R = 255;
          Canvas.DrawColor.G = 0;
          Canvas.DrawColor.B = 0;
          Scale = P.DefaultFOV/P.DesiredFOV;
          Canvas.DrawText("UM16A2...X"$int(Scale)$"."$int(10 * Scale - 10 * int(Scale)));
     }
     else
          bOwnsCrossHair = false;
}

function float RateSelf( out int bUseAltMode )
{
     local float dist;

     if ( AmmoType.AmmoAmount <=0 )
          return -2;

     bUseAltMode = 0;
     if ( (Bot(Owner) != None) && Bot(Owner).bSniping )
          return AIRating + 1.15;
     if (  Pawn(Owner).Enemy != None )
     {
          dist = VSize(Pawn(Owner).Enemy.Location - Owner.Location);
          if ( dist > 1200 )
          {
               if ( dist > 2000 )
                    return (AIRating + 0.75);
               return (AIRating + FMin(0.0001 * dist, 0.45));
          }
     }
     return AIRating;
}

simulated function PlayFiring()
{
     local int r;

     PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
     PlayAnim(FireAnims[Rand(5)],0.6 + 0.6 * FireAdjust, 0.05);

}


simulated function bool ClientAltFire( float Value )
{
     GotoState('Zooming');
     return true;
}

function AltFire( float Value )
{
     ClientAltFire(Value);
}

///////////////////////////////////////////////////////
state NormalFire
{
     function EndState()
     {
          Super.EndState();
          OldFlashCount = FlashCount;
     }

Begin:
     FlashCount++;
     //ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);
     PlayFiring();
     FinishAnim();
        Finish();

}

function Timer()
{
     local actor targ;
     local float bestAim, bestDist;
     local vector FireDir;
     local Pawn P;

     bestAim = 0.95;
     P = Pawn(Owner);
     if ( P == None )
     {
          GotoState('');
          return;
     }
     if ( VSize(P.Location - OwnerLocation) < 6 )
          StillTime += FMin(2.0, Level.TimeSeconds - StillStart);

     else
          StillTime = 0;
     StillStart = Level.TimeSeconds;
     OwnerLocation = P.Location;
     FireDir = vector(P.ViewRotation);
     targ = P.PickTarget(bestAim, bestDist, FireDir, Owner.Location);
     if ( Pawn(targ) != None )
     {
          SetTimer(1 + 4 * FRand(), false);
          bPointing = true;
          Pawn(targ).WarnTarget(P, 200, FireDir);
     }
     else
     {
          SetTimer(0.4 + 1.6 * FRand(), false);
          if ( (P.bFire == 0) && (P.bAltFire == 0) )
               bPointing = false;
     }
}


function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000
		+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	if ( bTraceFire )
		Spawn(class'MTracer',,, StartTrace + 96 * AimDir,rotator(EndTrace - StartTrace));

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
     if (Other == Level)
          Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
     
     else if ( (Other != self) && (Other != Owner) && (Other != None) )
     {
          if ( Other.bIsPawn )
               Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
          if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight)
               && (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
               Other.TakeDamage(HeadDamage, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
          else
             Other.TakeDamage(TorsoDamage, Pawn(Owner), HitLocation, 30000 * X, myDamageType);

          if ( !Other.bIsPawn && !Other.IsA('Carcass') )
		{
              	spawn(class'UT_BigBloodPuff',,,HitLocation+HitNormal*9);
		spawn(class'BloodDrop',,,HitLocation+HitNormal*9);
		}
	if ( Other.IsA('Bot') || Other.IsA('PlayerPawn') )
		{
              	spawn(class'UT_BigBloodPuff',,,HitLocation+HitNormal*9);
		spawn(class'BloodDrop',,,HitLocation+HitNormal*9);
		}
     }
}

/*
function Projectile ProjectileFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
     local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
     local actor Other;

     Owner.MakeNoise(Pawn(Owner).SoundDampening);
     GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
     StartTrace = Owner.Location + pawn(owner).Eyeheight * Z;
     AdjustedAim = pawn(owner).AdjustAim(ProjSpeed, StartTrace, 2*AimError, False, False);
     X = vector(AdjustedAim);
     EndTrace = StartTrace + 10000 * X;
     AimDir = vector(AdjustedAim);
     Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
     return Spawn(ProjClass,,, StartTrace,AdjustedAim);
}
*/

function Finish()
{
     if ( (Pawn(Owner).bFire!=0) && (FRand() < 0.6) )
          Timer();
     Super.Finish();
}

state Idle
{
     function Fire( float Value )
     {
          if ( AmmoType == None )
          {
               GiveAmmo(Pawn(Owner));
          }
          if (AmmoType.UseAmmo(1))
          {
               GotoState('NormalFire');
               bCanClientFire = true;
               bPointing=True;
               if ( Owner.IsA('Bot') )
               {
                    if ( Bot(Owner).bSniping && (FRand() < 0.65) )
                         AimError = AimError/FClamp(StillTime, 1.0, 8.0);
                    else if ( VSize(Owner.Location - OwnerLocation) < 6 )
                         AimError = AimError/FClamp(0.5 * StillTime, 1.0, 3.0);
                    else
                         StillTime = 0;
               }
               Pawn(Owner).PlayRecoil(FiringSpeed);
               AimError = Default.AimError;
               ClientFire(Value);
          }
     }

     function BeginState()
     {
          bPointing = false;
          SetTimer(0.4 + 1.6 * FRand(), false);
          Super.BeginState();
     }

     function EndState()
     {
          SetTimer(0.0, false);
          Super.EndState();
     }

Begin:
     bPointing=False;
     if ( AmmoType.AmmoAmount<=0 )
          Pawn(Owner).SwitchToBestWeapon();
     if ( Pawn(Owner).bFire!=0 ) Fire(0.0);
     Disable('AnimEnd');
     PlayIdleAnim();
}

state Zooming
{
     simulated function Tick(float DeltaTime)
     {
          if ( Pawn(Owner).bAltFire == 0 )
          {
               if ( (PlayerPawn(Owner) != None) && PlayerPawn(Owner).Player.IsA('ViewPort') )
                    PlayerPawn(Owner).StopZoom();
               SetTimer(0.0,False);
               GoToState('Idle');
          }
     }

     simulated function BeginState()
     {
          if ( Owner.IsA('PlayerPawn') )
          {
               if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
                    PlayerPawn(Owner).ToggleZoom();
               SetTimer(0.2,True);
          }
          else
          {
               Pawn(Owner).bFire = 1;
               Pawn(Owner).bAltFire = 0;
               Global.Fire(0);
          }
     }
}

simulated function PlayIdleAnim()
{
     if ( Mesh != PickupViewMesh )
          PlayAnim('Still',1.0, 0.05);
}

defaultproperties
{
     FireAnims(0)=Fire
     FireAnims(1)=Fire
     FireAnims(2)=Fire
     FireAnims(3)=Fire
     FireAnims(4)=Fire
     WeaponDescription="Classification: UM16A2"
     AmmoName=Class'Botpack.BulletBox'
     PickupAmmoCount=400
     bInstantHit=True
     bAltInstantHit=True
     FiringSpeed=1.800000
     FireOffset=(Y=-5.000000,Z=-2.000000)
     MyDamageType=shot
     AltDamageType=Decapitated
     shakemag=400.000000
     shaketime=0.150000
     shakevert=8.000000
     AIRating=0.540000
     RefireRate=1.000000
     AltRefireRate=1.000000
     FireSound=Sound'UM16A2.M4speed'
     SelectSound=Sound'UnrealI.Rifle.RiflePickup'
     DeathMessage="%k totally kicked %o ASS."
     NameColor=(R=0,G=0)
     bDrawMuzzleFlash=True
     MuzzleScale=1.000000
     FlashY=0.110000
     FlashO=0.010000
     FlashC=0.030000
     FlashLength=0.010000
     FlashS=256
     MFTexture=Texture'Botpack.Rifle.MuzzleFlash2'
     AutoSwitchPriority=5
     InventoryGroup=9
     PickupMessage="You picked up the UM16A2 Rifle."
     ItemName="UM16A2 Rifle.."
     PlayerViewOffset=(X=6.200000,Y=-1.750000,Z=-4.400000)
     PlayerViewMesh=LodMesh'UM16A2.TUC_M16A1Main'
     PlayerViewScale=0.200000
     BobDamping=0.980000
     PickupViewMesh=LodMesh'UM16A2.TUC_M16A1Mainpickup'
     PickupViewScale=5.000000
     ThirdPersonMesh=LodMesh'UM16A2.TUC_M16A1Mainpickup'
     ThirdPersonScale=5.000000
     bMuzzleFlashParticles=True
     MuzzleFlashStyle=STY_Translucent
     MuzzleFlashMesh=LodMesh'Botpack.muzzsr3'
     MuzzleFlashScale=0.050000
     MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy3'
     PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
     Icon=None
     Rotation=(Roll=-1536)
     Mesh=LodMesh'UM16A2.TUC_M16A1Main3rd'
     bNoSmooth=False
     CollisionRadius=32.000000
     CollisionHeight=8.000000
}
