//=============================================================================
// SuperRocketMk2.
//=============================================================================
class SuperRocketMk2 expands RocketMk2;

simulated function PostBeginPlay()
{
	Trail = Spawn(class'RocketTrail',self);
	if ( Level.bHighDetailMode )
	{
		SmokeRate = (200 + (0.5 + 2 * FRand()) * NumExtraRockets * 24)/Speed; 
		if ( Level.bDropDetail )
		{
			SoundRadius = 6;
			LightRadius = 9; // fb 3
		}
	}
	else 
	{
		SmokeRate = 0.15 + FRand()*(0.02+NumExtraRockets);
		LightRadius = 9; // fb 3
	}
	SetTimer(SmokeRate, true);
}

auto state Flying
{
	function BlowUp(vector HitLocation)
	{               // fb 220
		HurtRadius(Damage,250.0, MyDamageType, MomentumTransfer, HitLocation );
		MakeNoise(1.0);
	}
}

defaultproperties
{
     speed=2250.000000
     MaxSpeed=4000.000000
     Damage=80.000000
}
