#!/bin/bash

# UT99 Linux Setup script by Quasi^ aka ~V~
# Fixes the loki installation process for other ARCHes
# Installs menu and icon files.
# Includes a cache convertor script (ut99cache) which
# should also be edited before running.

# Whether UT will run or not is NOT guaranteed!

# Copyright 2010  Quasi^ aka ~V~ <dave@unrealize.co.uk>
# All rights reserved.
#
# Redistribution and use of this script, with or without modification, is
# permitted provided that the following conditions are met:
#
# 1. Redistributions of this script must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ''AS IS'' AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
# OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
# OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


# Edit the 3 paths below

# Where the install CD/ISO/FOLDER is located:
CD_PATH=/mnt/cd/dvd

# Where to place the link to start UT. Should be in your PATH:
LINK_PATH=$HOME/bin

# Where to install the game files:
UT_PATH=$HOME/ut99

# No need to edit anything below this line.

VERSION=0.2
CWD=$(pwd)
blue='\e[01;34m'
green='\e[01;32m'
normal='\e[m\017'

set -e 

function findlocalbin()
{
	IFS=":"
	MyPath=$PATH
	set -- $MyPath
	for i in $(echo "$MyPath")

	do
		[[ ! -z $(echo $i | grep $(whoami)) ]] && echo $i && break
	done
}

function copyfiles()
{
	echo -e $normal
	[[ ! -d $UT_PATH ]] && mkdir $UT_PATH
	(
		cd $UT_PATH
		mkdir System Maps Textures Music Sounds Web Help Logs 2>/dev/null || true
		chmod -R +rw *
	)
	echo -e "${blue}Copying Files...$normal"

	cp -vr $CD_PATH/SYSTEM/* $UT_PATH/System/.
	cp -v $CD_PATH/MAPS/* $UT_PATH/Maps/.
	cp -v $CD_PATH/MUSIC/* $UT_PATH/Music/.
	cp -v $CD_PATH/TEXTURES/* $UT_PATH/Textures/.
	cp -v $CD_PATH/SOUNDS/* $UT_PATH/Sounds/.
	cp -vr $CD_PATH/WEB/* $UT_PATH/Web/.
	cp -v $CD_PATH/HELP/* $UT_PATH/Help/.
	cp -v README* $UT_PATH/Help/.

	(
		cd $UT_PATH
		tar xvf $CWD/data.tar.gz
		tar xvf $CWD/Credits.tar.gz
		tar xvf $CWD/OpenGL.ini.tar.gz
		cp -v $CWD/bin/x86/* $UT_PATH/.
		cp -v $CWD/ut99cache.sh $UT_PATH/.
		sed -i "8iUT_DATA_PATH=$UT_PATH\/System" ut
		sed -i "9i$UT_PATH\/ut99cache.sh" ut
		cat System/UnrealTournament.ini.PATCH > System/UnrealTournament.ini
		sed -i 's%GameRenderDevice=SDLGLDrv.SDLGLRenderDevice%GameRenderDevice=OpenGLDrv.OpenGLRenderDevice%' System/UnrealTournament.ini
		rm -f System/UnrealTournament.ini.PATCH
		chmod -R +rw *
	)
}

function decompmaps()
{
	echo -e "${blue}Decompressing Maps...$normal"

	ls $UT_PATH/Maps/*.uz 2>/dev/null 1>&2 || { true; return; }

	for map in $UT_PATH/Maps/*.uz
	do
		uncomp=$(basename $map .uz)
		$UT_PATH/ucc decompress ../Maps/$(basename $map) -nohomedir | sed '/WARNING/d'
		[[ -f $UT_PATH/System/$uncomp ]] && mv -f $UT_PATH/System/$uncomp $UT_PATH/Maps/.
		rm -f $map
	done
}

function makelinks()
{
	rm -f $LINK_PATH/ut $LINK_PATH/ucc
	ln -s $UT_PATH/ut $LINK_PATH/ut
	ln -s $UT_PATH/ucc $LINK_PATH/ucc
	echo -e "${blue}Created Links in $LINK_PATH$normal"
}

function adddesktop()
{
	if [ ! -d $HOME/.local/share/icons/hicolor/48x48 ]; then
		mkdir -p $HOME/.local/share/icons/hicolor/48x48 
	fi

	cp icon.xpm $HOME/.local/share/icons/hicolor/48x48/ut.xpm

	if [ ! -d $HOME/.local/share/applications ]; then
		mkdir -p $HOME/.local/share/applications
	fi

	cp ut.desktop $HOME/.local/share/applications/.

	if [ -x /usr/bin/update-desktop-database ]; then
	  /usr/bin/update-desktop-database -q $HOME/.local/share/applications >/dev/null 2>&1
	fi

	if [ -e $HOME/.local/share/icons/hicolor/icon-theme.cache ]; then
	  if [ -x /usr/bin/gtk-update-icon-cache ]; then
		/usr/bin/gtk-update-icon-cache $HOME/.local/share/icons/hicolor >/dev/null 2>&1
	  fi
	fi
	echo -e "${blue}Added desktop and icon files$normal"
}

[[ ! -d $LINK_PATH ]] && LINK_PATH=$(findlocalbin)
[[ ! -d $LINK_PATH ]] && echo "You must have a local directory for the startup links." && exit 1
[[ ! -d $CD_PATH ]] && echo "CD path doesn't exist." && exit 1

echo -e "${green}UT99 Linux Installer Script version $VERSION by Quasi^ aka ~V~$normal"
echo -e "Using CD/ISO in ${blue}$CD_PATH$normal"
echo -e "Using ${blue}$LINK_PATH$normal for UT startup script"
echo -e "Installing to ${blue}$UT_PATH$normal"
echo "Before running this script you should edit the paths"
echo "at the top of this script and also the utdir path in ut99cache.sh"
echo "Don't forget to mount the CD."

echo -en "${green}Press Enter To Start Install$normal"
read

copyfiles
decompmaps
makelinks
adddesktop

echo -e "${green}CD 1 Installed.$normal"
echo "Now type 'ut'"

