#!/bin/bash  

# Linux UT Cache Convertor
# by Quasi^ aka ~V~

# Copyright 2010 Quasi^ aka ~V~ <dave@unrealize.co.uk>
# All rights reserved.
#
# Redistribution and use of this script, with or without modification, is
# permitted provided that the following conditions are met:
#
# 1. Redistributions of this script must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ''AS IS'' AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
# OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
# OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


# Need to change the following line:
utdir=$HOME/ut99 # change it to your UT install dir

cachedir=$HOME/.loki/ut/Cache
cache=$cachedir/cache.ini

function close() {
	rm $cache $cachedir/*.uxx 2>/dev/null
	rm -f $utdir/System/De.u # optional
	rm -f $utdir/System/de.u # optional
#	rm -f $utdir/Textures/Citytex.utx # optional
	echo "Cache empty"
	exit 0
}

function moveit() {
	echo $(mv "$cachedir/$cachefile".uxx "$utdir/$1/$realfile" ) 
	if [ ! -f "$utdir/$1/$realfile" ]; then echo "**** "$realfile" move failed! ****"; echo "";fi
}

function processcache()
{
	if [ ! -f $cache ]; then close; fi
	while read line
	do	
		cachefile=${line:0:32}
		realfile=${line#$cachefile=}
		ext=${realfile##*.}
		if [ ! -z $ext ]; then
			echo -n "Moving $cachefile.uxx -> $realfile"
			if [[ "$ext" =~ unr ]]; then moveit Maps
			elif [[ "$ext" =~ utx ]]; then moveit Textures
			elif [[ "$ext" =~ uax ]]; then moveit Sounds
			elif [[ "$ext" =~ umx ]]; then moveit Music
			elif [[ "$ext" =~ u ]]; then moveit System
			fi
			
		fi
	done  < <(cat $cache | sed '/\[Cache\]/d' | head -n -1 | tr -d "\r")
	close
}

processcache

