// ServerTcpLink.cpp: implementation of the CServerTcpLink class.
//
//////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "Client.h"
#include "ServerTcpLink.h"
#include "InitStrings.h"
#include "StandardData.h"
#include "GlobalStuff.h"
#include "ClientHandler.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CServerTcpLink::CServerTcpLink(int portNum,const char* password,bool in,bool out)
{
	initialized=false;
	this->password=password;
	connected=false;
	connectionState=0;
	g.servertcplink=this;

	//set up winsock
#ifdef _WIN32
	WORD wVersionRequested;
	WSADATA wsaData;int err; 
	wVersionRequested = MAKEWORD( 2, 2 ); 
	err = WSAStartup( wVersionRequested, &wsaData );if ( err != 0 ) {
		cout << "Couldnt initialize winsock.\n";
		return;
	} 
	/* Confirm that the WinSock DLL supports 2.2.*/
	/* Note that if the DLL supports versions greater    */
	/* than 2.2 in addition to 2.2, it will still return */
	/* 2.2 in wVersion since that is the version we      */
	/* requested.                                        */ 
	if ( LOBYTE( wsaData.wVersion ) != 2 || HIBYTE( wsaData.wVersion ) != 2 ) {
		cout << "Wrong WSA version.\n";
		cout.flush();
		return; 
	}
#endif

	//listen socket for server
	if ((listenSocket = socket(AF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET ){
		cout << "Error initializing server listening socket.\n";
		cout.flush();
		return;
	}

	SOCKADDR_IN saMe;

	saMe.sin_family = AF_INET;
	//saMe.sin_addr.s_addr = INADDR_ANY; // Let WinSock assign address
	saMe.sin_addr.s_addr = g.localip;
	saMe.sin_port = htons(portNum);

	if (bind(listenSocket,(struct sockaddr *)&saMe,sizeof(struct sockaddr_in)) == SOCKET_ERROR) {
		closesocket(listenSocket);
		cout << "Error binding server listening socket.\n";
		cout.flush();
		return;
	}

	listen(listenSocket,5);

	//make it nonblocking
//	u_long u=1;
//	ioctlsocket(listenSocket,FIONBIO,&u);
	set_non_blocking(listenSocket);

	initialized=true;
	cout << "Waiting for feeder connection.\n";
	cout.flush();
}

CServerTcpLink::~CServerTcpLink()
{
	if(connected){
		char temp[]="6 Proxy closing down\xd\xa";
		SendData(serverSocket,temp,strlen(temp));
		closesocket(serverSocket);
	}
	closesocket(listenSocket);

	WSACleanup( );	
}


int CServerTcpLink::Update()
{
	WaitForCon();
	if(connected){
		GetData();
		switch(connectionState){
		case 0:
			ListenForPassword();
			break;
		case 1:
			ParseData();
			break;
		default:
			cout << "Impossible connectionState.\n";
			cout.flush();
		}
	}
	return 10;
}

int CServerTcpLink::WaitForCon()
{
	SOCKET tempSocket=accept(listenSocket, NULL, NULL);
	if (tempSocket == SOCKET_ERROR)
	{
		if(WSAGetLastError()==WSAEWOULDBLOCK)
			return -1;
		cout << "Error listening for servers." << WSAGetLastError() << "\n";
		cout.flush();
		return -1;
	}

	if(connected){
		cout << "Feeder already connected - disconnecting the new one" << endl;
		char temp[]="9 Feeder already connected\xd\xa";
		SendData(tempSocket,temp,strlen(temp));
		closesocket(tempSocket);
		return -1;
	}

	serverSocket=tempSocket;

	SOCKADDR server;
	getpeertype length=sizeof(SOCKADDR);
	if(SOCKET_ERROR==getpeername(serverSocket,&server,&length)){
		cout << "Error looking up server name." << WSAGetLastError() << "\n";
		cout.flush();
		char temp[]="9 Sorry couldnt look up your name\xd\xa";
		SendData(tempSocket,temp,strlen(temp));
		closesocket(tempSocket);
		return -1;
	}
	g.serverAdress=*((unsigned int*)&server.sa_data[2]);

//	u_long u=1;
//	ioctlsocket(serverSocket,FIONBIO,&u);
	set_non_blocking(serverSocket);
	
	cout << "Feeder connection attempt from "  << (unsigned int)(unsigned char)server.sa_data[2] << "." << (unsigned int)(unsigned char)server.sa_data[3] << "." << (unsigned int)(unsigned char)server.sa_data[4] << "." << (unsigned int)(unsigned char)server.sa_data[5] << "\n";
	cout.flush();

	connected=true;
	return 1;
}

int
CServerTcpLink::ListenForPassword()
{
	if(quedStrings.empty())
		return 0;

	std::string tempstring=quedStrings.front();
	quedStrings.pop_front();

	int type=atoi(tempstring.c_str());
	if(type!=1){
		cout << "Malformed packet on feeder login\n";
		cout.flush();
		char temp[]="9 Malformed login\xd\xa";
		SendData(serverSocket,temp,strlen(temp));
		closesocket(serverSocket);
		connected=false;
		return -1;
	}

	std::string inpass;
	int a; 
	for(a=2;tempstring[a]!=' ' && tempstring[a]!=13;a++)
		inpass+=tempstring[a];

	a++;
	for(;tempstring[a]!=' ' && tempstring[a]!=13;a++);
	int delay=atoi(&(tempstring.c_str()[a]));
	cout << "Delay set to " << delay << " s.\n";
	standarddata.delay=delay*1000;

	if(!password.empty() && password.compare(inpass)!=0){
		cout << "Wrong password given in feeder login\n";
		cout.flush();
		char temp[]="9 Wrong password\xd\xa";
		SendData(serverSocket,temp,strlen(temp));
		closesocket(serverSocket);
		connected=false;
		return -1;
	}
	
	//Reset maxpacketime if in danger of wrapping - should not happen often
	if (g.maxPacketTime > 2000000000)
		g.maxPacketTime = 0;

	char temp[50];
	sprintf(temp,"8 %d %d\xd\xa",NUM_VERSION,g.maxPacketTime);

	SendData(serverSocket,temp,strlen(temp));

	cout << "Feeder password accepted.\n";
	cout.flush();
	
	standarddata.Reset();
	//initstrings.Reset();	//feeder should send a 3 packet anyway!
	g.numFeeders=1;
	g.clienthandler->ConnectionNumChange();

	connectionState=1;
	return 1;
}


int
CServerTcpLink::GetData()
{
	int nRet=recv(serverSocket, buf,10000,0);
	while(SOCKET_ERROR!=nRet && 0!=nRet){
		buf[nRet]=0;
		
		unsortedData+=buf;
		int pos;
		while(std::string::npos!=(pos=unsortedData.find("\n"))){
			pos+=1;
			std::string tempdata;
			for(int a=0;a<pos;a++){
				tempdata+=unsortedData[a];
			}
			quedStrings.push_back(tempdata);
			unsortedData.erase(0,pos);
			//	uncomm
			//cout << "Got string " << tempdata.c_str() << " from server" << "\n";
		}
		nRet=recv(serverSocket, buf,10000,0);
	}
	if(WSAGetLastError()==WSAEWOULDBLOCK || nRet==0)
		return 0;
	cout << "Feeder connection closed due to wsa error " << WSAGetLastError() << "\n";
	closesocket(serverSocket);
	connected=false;
	connectionState=0;
	g.numFeeders=0;
	g.clienthandler->ConnectionNumChange();
	unsortedData.erase();
	quedStrings.clear();
	return -1;
}


void 
CServerTcpLink::SendData(SOCKET s, const char *data, int length)
{	
	int nRet = send(s,data,length,0);
}

void 
CServerTcpLink::SendString (const char *data)
{
	SendData (serverSocket, data, strlen (data));
}

int
CServerTcpLink::ParseData()
{
	std::string rv;

	while(!quedStrings.empty()){		
		std::string tempstring=quedStrings.front();
		quedStrings.pop_front();
		
		int type=atoi(tempstring.c_str());

		switch(type){
		case 2:		
			if(0==standarddata.AddString(tempstring.c_str())){
				initstrings.AddString(tempstring.c_str());
			} 
			break;
		case 3:
//			standarddata.conversion=0;
			standarddata.AddString(tempstring.c_str());
			break;
		case 4:
			standarddata.AddString(tempstring.c_str());
			break;
		case 6:
			cout << "Server exited. Reason " << tempstring.c_str();
			cout.flush();
			closesocket(serverSocket);
			connected=false;
			connectionState=0;
			g.numFeeders=0;
			g.clienthandler->ConnectionNumChange();
			unsortedData.erase();
			break;
		case 0:
			rv = g.ParseAdmin (tempstring, 0);
			SendString (rv.c_str ());
			break;
		default:
			cout << "Unknown package type received from server " << type << "\n";
			cout.flush();
		}
	}
	return 1;
}

void 
CServerTcpLink::ConnectionNumChange()
{
	if(connected){
		char temp[300];
		sprintf(temp,"5 %d %d\xd\xa",g.numFeeders,g.clienthandler->clients.size());
		//cout << "More feeders: " << temp;
		SendData(serverSocket,temp,strlen(temp));
	}
}
