// ClientListener.cpp: implementation of the CClientListener class.
//
//////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "Client.h"
#include "ClientListener.h"
#include "ClientHandler.h"
#include "GlobalStuff.h"

void set_non_blocking( int fd);

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CClientListener::CClientListener(CClientHandler* h)
{
	ch=h;
	initialized=false;

	//set up winsock
#ifdef _WIN32
	WORD wVersionRequested;
	WSADATA wsaData;int err; 
	wVersionRequested = MAKEWORD( 2, 2 ); 
	err = WSAStartup( wVersionRequested, &wsaData );if ( err != 0 ) {
		cout << "Couldnt initialize winsock.\n";
		return;
	} 
	/* Confirm that the WinSock DLL supports 2.2.*/
	/* Note that if the DLL supports versions greater    */
	/* than 2.2 in addition to 2.2, it will still return */
	/* 2.2 in wVersion since that is the version we      */
	/* requested.                                        */ 
	if ( LOBYTE( wsaData.wVersion ) != 2 || HIBYTE( wsaData.wVersion ) != 2 ) {
		cout << "Wrong WSA version.\n";
		cout.flush();
		return; 
	}
#endif

	//listen socket for server
	if ((listenSocket = socket(AF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET ){
		cout << "Error initializing client listening socket.\n";
		cout.flush();
		return;
	}

	SOCKADDR_IN saMe;

	saMe.sin_family = AF_INET;
	saMe.sin_addr.s_addr = INADDR_ANY; // Let WinSock assign address
	saMe.sin_addr.s_addr = g.localip;
	saMe.sin_port = htons(g.clientPort);

	if (bind(listenSocket,(struct sockaddr *)&saMe,sizeof(struct sockaddr_in)) == SOCKET_ERROR) {
		closesocket(listenSocket);
		cout << "Error binding client listening socket.\n";
		cout.flush();
		return;
	}

	listen(listenSocket,5);

	//make it nonblocking
//	u_long u=1;
//	ioctlsocket(listenSocket,FIONBIO,&u);
	set_non_blocking(listenSocket);

	//set up udp socket
	if ((udpSocket= socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP)) == INVALID_SOCKET ){ /* create socket */
		cout << "Error initializing client udp socket.\n";
		return;
	}
	saMe.sin_family = AF_INET;
	saMe.sin_addr.s_addr = INADDR_ANY; // Let WinSock assign address
	saMe.sin_addr.s_addr = g.localip;
	saMe.sin_port = htons(g.clientPort+1);

	if (bind(udpSocket,(struct sockaddr *)&saMe,sizeof(struct sockaddr_in)) == SOCKET_ERROR) {
		closesocket(udpSocket);
		cout << "Error binding client udp socket.\n";
	}

//	u=1;
//	ioctlsocket(udpSocket,FIONBIO,&u);
	set_non_blocking(udpSocket);

	ch->udpSocket=udpSocket;

	initialized=true;
	cout << "Waiting for client connections.\n";
	cout.flush();
}



void set_non_blocking( int fd)
{

#ifdef _WIN32
    int one= 1;
    ioctlsocket( fd, FIONBIO, (unsigned long*)&one);
#else
#ifdef O_NONBLOCK
    fcntl( fd, F_SETFL, O_NONBLOCK);
#else
    fcntl( fd, F_SETFL, O_NDELAY);
#endif
#endif
}


CClientListener::~CClientListener()
{
	closesocket(listenSocket);
	closesocket(udpSocket);
	WSACleanup( );	
}

void 
CClientListener::Update()
{
	TestConTCP();
	GetUDPData();
}

int
CClientListener::TestConTCP()
{
	SOCKET tempSocket=accept(listenSocket, NULL, NULL);
	if (tempSocket == SOCKET_ERROR)
	{
		if(WSAGetLastError()==WSAEWOULDBLOCK)
			return -1;
		cout << "Error listening for clients." << WSAGetLastError() << "\n";
		cout.flush();
		return -1;
	}

//	u_long u=1;
//	ioctlsocket(tempSocket,FIONBIO,&u);
	set_non_blocking(tempSocket);
	
	CClient* c=new CClient(tempSocket,ch);
	ch->AddClient(c);

	return 1;
}

void 
CClientListener::GetUDPData()
{
	int ret;
	getpeertype length=sizeof(SOCKADDR);
	SOCKADDR_IN sender;
	while(SOCKET_ERROR!=(ret=recvfrom(udpSocket,buf,5000,0,(SOCKADDR*)&sender, &length))){
		unsigned int senderAddr=*((unsigned int*)&sender.sin_addr);
		int port=ntohs(*((unsigned short*)&sender.sin_port));
		unsigned int id=*((unsigned int*)&buf[4]);
		//cout << "Got udp client connection attempt with id "<< id << "\n";
		std::list<CClient*>::iterator ci;
		for(ci=ch->clients.begin();ci!=ch->clients.end();ci++){
			if((*ci)->id==id && (*ci)->udpPort==0){
				(*ci)->ConnectUDP(port);
				break;
			}
		}

	}
}
