// Client.h: interface for the CClient class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CLIENT_H__2C4BA723_F6C6_11D4_AD55_0080ADA84DE3__INCLUDED_)
#define AFX_CLIENT_H__2C4BA723_F6C6_11D4_AD55_0080ADA84DE3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#pragma warning(disable:4786)

#ifdef _WIN32
#include <winsock2.h>
#define getpeertype int
#define CFGNAME "utvserver.ini"
#endif

#ifndef _WIN32
#include <unistd.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <errno.h>
#include <fcntl.h>
#include <signal.h>
typedef unsigned int        SOCKET;
typedef struct sockaddr SOCKADDR;
typedef struct sockaddr_in SOCKADDR_IN;
typedef unsigned short WORD;
#define INVALID_SOCKET -1
#define SOCKET_ERROR            (-1)
#define closesocket(a) close(a)
#define WSAGetLastError() errno
#define Sleep(a) usleep((a)*1000)
#define WSAEWOULDBLOCK EWOULDBLOCK
#define WSACleanup() NULL	
#define GetTickCount() gettickcount()
#define getpeertype unsigned int
unsigned int gettickcount();
#define CFGNAME "/etc/utvserver.conf"

#ifndef VMS
#include <sys/param.h>
#endif
#include <sys/time.h>
#include <sys/timeb.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netdb.h>
#include <arpa/inet.h>
#endif

#include <iostream>
#include <string>
#include <list>
#include <stdio.h>

using namespace std;

class CClientHandler;

class CClient  
{
public:
	int SendInitStrings();
	int SendDataUDP(const char* data,int length);
	void ConnectUDP(int port);
	int SendString(const char* data,int length);
	void Update();
	CClient(SOCKET s,CClientHandler* ch);
	virtual ~CClient();

	int ParseData();
	int ListenForPassword();
	int GetData();
	void Suicide ();

	SOCKET mySocket;
	bool connectedTCP;
	int udpPort;
	SOCKADDR udpAddr;

	unsigned int id;
	unsigned int peerAddress;
	int connectionState;
	int initStringNum;

	unsigned int lastSend;
	bool muted; 

	char buf[400];
	std::string unsortedData;
	std::list<std::string> quedStrings;
	CClientHandler* ch;
};

void set_non_blocking( int fd);

#endif // !defined(AFX_CLIENT_H__2C4BA723_F6C6_11D4_AD55_0080ADA84DE3__INCLUDED_)
