// StandardData.cpp: implementation of the CStandardData class.
//
//////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "Client.h"
#include "StandardData.h"
//#include "windows.h"
#include "GlobalStuff.h"
#include <iostream>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CStandardData standarddata;

CStandardData::CStandardData()
{
	conversion=0;
	delay=3000;
}

CStandardData::~CStandardData()
{
	while(!packets.empty()){
		delete[] packets.back()->data;
		delete packets.back();
		packets.pop_back();
	}
}

int
CStandardData::AddString(const char *string)
{
	if(packets.empty()) {
		//std::cout << "Buffering for later: "  << string;
		strbuf.push_back (string);
		return 1;
	}
	packets.back()->strings.push_back(string);
	return 1;
}

void 
CStandardData::AddData(char *data, int length)
{
	int sendtime=*((unsigned int*)data);
	
	if (sendtime > g.maxPacketTime)
		g.maxPacketTime = sendtime;

	if(conversion==0)
		conversion=GetTickCount()-sendtime;

	datapacket* dp=new datapacket;
	dp->time=sendtime+conversion+delay;
	dp->length=length;
	dp->data=new char[length];
	for(int a=0;a<length;a++)
		dp->data[a]=data[a];

	//Add buffered strings
	while (!strbuf.empty ()) {
		dp->strings.push_back (strbuf.front());
		strbuf.pop_front();
	}

	packets.push_back(dp);
}

datapacket* CStandardData::GetReadyPacket()
{
	if(packets.empty())
		return 0;
	if(packets.front()->time<GetTickCount())
		return packets.front();
	return 0;
}

void 
CStandardData::PopPacket()
{
	delete[] packets.front()->data;
	delete packets.front();
	packets.pop_front();
}

void 
CStandardData::Reset()
{
	while(!packets.empty()){
		delete[] packets.back()->data;
		delete packets.back();
		packets.pop_back();
	} 
	conversion=0;
}
