// ClientHandler.cpp: implementation of the CClientHandler class.
//
//////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "Client.h"
#include "ClientHandler.h"
#include "ClientListener.h"
#include "StandardData.h"
#include "GlobalStuff.h"
#include "ServerTcpLink.h"
#include "InitStrings.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CClientHandler::CClientHandler(const char* password)
{
	this->password=password;
	listener=new CClientListener(this);
	g.clienthandler=this;
}

CClientHandler::~CClientHandler()
{
	while(!clients.empty()){
		delete clients.back();
		clients.pop_back();
	}
	delete listener;
}

void 
CClientHandler::Update()
{
	bool diddelete=false;

	//delete unused clients
	while(!toBeDeleted.empty()){
		clients.remove(toBeDeleted.back());
		diddelete = true;
		
		delete toBeDeleted.back();
		toBeDeleted.pop_back();		
	}

	if (diddelete)
		ConnectionNumChange ();

	//check for new clients
	listener->Update();

	//update clients
	std::list<CClient*>::iterator ci;
	for(ci=clients.begin();ci!=clients.end();ci++){
		(*ci)->Update();
	}
	
	//send packets that has waited long enough
	datapacket* dp;
	while(0!=(dp=standarddata.GetReadyPacket())){
		//cout << "Sending binary packet length " << dp->length << " and " << dp->strings.size() << " strings to client\n";
		SendUDPData(dp->data,dp->length);
		std::list<std::string>::iterator si;
		for(si=dp->strings.begin();si!=dp->strings.end();si++){
			if(atoi(si->c_str())==2)
				initstrings.AddString(si->c_str());
			if(atoi(si->c_str())==3) {
				ResetClientStatus ();
				initstrings.Reset();
				cout << "Clearing init strings" << endl;
			}
			SendString(si->c_str());
			//cout << "Sending text packet " << si->c_str();
		}
		standarddata.PopPacket();
	}
}

void 
CClientHandler::ResetClientStatus ()
{
	//update clients
	std::list<CClient*>::iterator ci;
	for(ci=clients.begin();ci!=clients.end();ci++){
		(*ci)->initStringNum = 0;
	}
}

void 
CClientHandler::AddClient(CClient *c)
{
	clients.push_back(c);
}

CClient *
CClientHandler::FindClient (unsigned int id)
{
	std::list<CClient*>::iterator ci;
	for(ci=clients.begin();ci!=clients.end();ci++){
		if ((*ci)->id == id)
			return *ci;
	}
	return NULL;
}

void 
CClientHandler::SendString(const char *data)
{
	int length=strlen(data);
	std::list<CClient*>::iterator ci;
	for(ci=clients.begin();ci!=clients.end();ci++){
		if((*ci)->connectedTCP && (*ci)->connectionState>0)
			(*ci)->SendString(data,length);
	}
}

void 
CClientHandler::DeleteClient(CClient *c)
{
	std::list<CClient*>::iterator ci;

	//Make sure the client is not already scheduled for delete
	for(ci=toBeDeleted.begin();ci!=toBeDeleted.end();ci++){
		if ((*ci)->id == c->id)
			return;
	}
	
	toBeDeleted.push_back(c);	
}

void 
CClientHandler::SendUDPData(const char *data, int length)
{
	std::list<CClient*>::iterator ci;
	for(ci=clients.begin();ci!=clients.end();ci++){
		if((*ci)->udpPort!=0 && (*ci)->connectionState>1)
			(*ci)->SendDataUDP(data,length);
	}
}

void 
CClientHandler::ConnectionNumChange()
{
	char temp[300];
	g.numClients=clients.size () - toBeDeleted.size ();
	sprintf(temp,"5 %d %d\xd\xa",g.numFeeders,g.numClients);
	//cout << "Sending nums: " << temp;
	SendString(temp);
	g.servertcplink->ConnectionNumChange();
}
