// Client.cpp: implementation of the CClient class.
//
//////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "Client.h"
#include "ClientHandler.h"
#include "InitStrings.h"
#include "GlobalStuff.h"
#include "ServerTcpLink.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


CClient::CClient(SOCKET s,CClientHandler* ch)
{
	mySocket=s;
	this->ch=ch;
	//id=rand();
	id = g.CurId++;

	connectedTCP=true;

	connectionState = 3;	//betyder inte initad typ..

	if(g.numClients>=g.maxClients && g.maxClients!=0 ){
		cout << "Too many client connections attempted.\n";
		cout.flush();
		char temp[]="9 Sorry too many clients\xd\xa";
		SendString(temp,strlen(temp));
		//closesocket(mySocket);  //krashade
		ch->DeleteClient(this);
		ch->ConnectionNumChange();
		return;
	}

	getpeertype length=sizeof(SOCKADDR);
	if(SOCKET_ERROR==getpeername(mySocket,&udpAddr, &length)){
//		cout << "Error looking up client name." << WSAGetLastError() << "\n";
		cout.flush();
		char temp[]="9 Sorry couldnt look up your name\xd\xa";
		SendString(temp,strlen(temp));
		//closesocket(mySocket);
		ch->DeleteClient(this);
		ch->ConnectionNumChange();
		return;
	}

	cout << "Client "<<id<<" connection attempted from "  << (unsigned int)(unsigned char)udpAddr.sa_data[2] << "." << (unsigned int)(unsigned char)udpAddr.sa_data[3] << "." << (unsigned int)(unsigned char)udpAddr.sa_data[4] << "." << (unsigned int)(unsigned char)udpAddr.sa_data[5] << "\n";

	peerAddress=*((unsigned int*)&udpAddr.sa_data[2]);
	connectionState=0;
	initStringNum=0;
	udpPort=0;
	connectedTCP=true;
	muted=false;
	lastSend=0;
}

CClient::~CClient()
{
	if(connectedTCP)
		closesocket(mySocket);
}

void 
CClient::Update()
{
	if(connectedTCP){
		GetData();
		switch(connectionState){
		case 0:
			ListenForPassword();
			break;
		case 1:
			SendInitStrings();
			ParseData();
			break;
		case 2:
			ParseData();
			break;
		case 3:
			break;
		default:
			cout << "Impossible connectionState.\n";
			cout.flush();
		}
	}

}

int
CClient::SendString(const char *data, int length)
{
	if(!connectedTCP)
		return 0;
	//cout << "Sending string " << data;
	int nRet = send(mySocket,data,length,0);
	if(nRet==SOCKET_ERROR){
		cout << "Error sending string to client " <<id<<" "<< WSAGetLastError() << "\n";		
		Suicide ();
		return -1;
	}
	return 1;
}

int
CClient::ParseData()
{
	std::string rv;
	
	while(!quedStrings.empty()){		
		std::string tempstring=quedStrings.front();
		quedStrings.pop_front();
		
		int type=atoi(tempstring.c_str());
		
		switch(type){
		case 6:
			cout << "Client "<<id<<" exited. Reason " << tempstring.c_str();
			cout.flush();
			Suicide ();
			return -1;
		case 7:

			if (muted) {
				cout << "Muted client " << id << " tried to send " << tempstring.c_str ();
				break;
			}

			if (lastSend + g.maxMsgRate*1000 < GetTickCount()) {
				cout << "Client " << id << " sends string " << tempstring.c_str();
				ch->SendString(tempstring.c_str());
				g.servertcplink->SendString (tempstring.c_str ());
				lastSend = GetTickCount ();
			} 
			else {
				cout << "Prevented client " << id << " from sending " << tempstring.c_str();
			}

			break;
		case 0:
			rv = g.ParseAdmin (tempstring, id);			
			if (rv != "")
				SendString (rv.c_str (), strlen (rv.c_str ()));
			break;
		default:
			cout << "Unknown package type received from client " <<id<<" "<< type << "\n";
			cout.flush();
			Suicide ();
			return -1;
		}
	}
	return 1;
}

int
CClient::ListenForPassword()
{
	if(quedStrings.empty())
		return 0;

	std::string tempstring=quedStrings.front();
	quedStrings.pop_front();

	int type=atoi(tempstring.c_str());
	if(type!=1){
		cout << "Malformed packet on client login\n";
		cout.flush();
		char temp[]="9 Malformed login\xd\xa";
		SendString(temp,strlen(temp));
		closesocket(mySocket);
		connectedTCP=false;
		ch->DeleteClient(this);
		ch->ConnectionNumChange();
		return -1;
	}

	std::string inpass;
	for(int a=2;tempstring[a]!=' ' && tempstring[a]!=13;a++)
		inpass+=tempstring[a];

	if(!ch->password.empty() && ch->password.compare(inpass)!=0){
		cout << "Wrong password given in client login\n";
		cout.flush();
		char temp[]="9 Wrong password\xd\xa";
		SendString(temp,strlen(temp));
		closesocket(mySocket);
		connectedTCP=false;
		ch->DeleteClient(this);
		ch->ConnectionNumChange();
		return -1;
	}

	char temp[50];
	sprintf(temp,"8 %d %d\xd\xa",id,NUM_VERSION);
	SendString(temp,strlen(temp));

	cout << "Client "<<id<<" password correct.\n";

	//Set connectionstate here or connectionnumchange wont send anything.. :)
	connectionState=1;
	ch->ConnectionNumChange();

	return 1;
}

int
CClient::GetData()
{
	int nRet=recv(mySocket, buf,400,0);
	while(SOCKET_ERROR!=nRet && 0!=nRet){							// Flags

		buf[nRet]=0;
		
		unsortedData+=buf;
		int pos;
		while(std::string::npos!=(pos=unsortedData.find("\n"))){
			pos+=1;
			std::string tempdata;
			for(int a=0;a<pos;a++){
				tempdata+=unsortedData[a];
			}
			quedStrings.push_back(tempdata);
			unsortedData.erase(0,pos);
			//cout << "Got string " << tempdata.c_str() << " from client " << id<<"\n";
		}
		nRet=recv(mySocket, buf,400,0);
	}
	if(WSAGetLastError()==WSAEWOULDBLOCK || nRet==0)
		return 0;
	cout << "Client "<<id<<" connection closed due to wsa error " << WSAGetLastError() << "\n";

	Suicide ();
	return -1;
}

void 
CClient::Suicide()
{
	closesocket(mySocket);
	connectedTCP=false;
	connectionState=0;
	ch->DeleteClient(this);
	ch->ConnectionNumChange();
}

void 
CClient::ConnectUDP(int port)
{
	udpPort=port;
	(*(struct sockaddr_in*)&udpAddr).sin_port = htons(port);

	int i=0;
	cout << "Client "<<id<<" using udp port "<<port<<"\n";
	SendDataUDP((char*)&i,4);
}

//Fix fr cp-ut
int
CClient::SendDataUDP(const char *data, int length)
{
	if(udpPort==0 || connectionState<2)
		return 0;

	char newdata [500];
	int newlength = 0;
	unsigned char c;

	for (int i = 0; i < length; i++) {
		c = data[i];
		switch (c) {
		case 0:
			newdata [newlength++] = '!';
			newdata [newlength++] = 1;
			break;
		case '!':
			newdata [newlength++] = '!';
			newdata [newlength++] = 2;
			break;
		default:
			newdata [newlength++] = c;
			break;
		}
	}

	//cout << "Binary send" << endl;

/*	cout << "binary send: ";
	int x;
	for (int i = 0; i < length; i++) {
		x = data[i];
		cout << x << ",";
	}
	cout << endl; */

	int nRet = sendto(ch->udpSocket,newdata,newlength,0,&udpAddr,sizeof(SOCKADDR));

	if (nRet == SOCKET_ERROR) {
		int errCode = WSAGetLastError ();

		if (errCode == WSAEWOULDBLOCK) {
			int tries = 0;
			while (tries < 10) {
				Sleep(20);
				
				int nRet = sendto(ch->udpSocket,newdata,newlength,0,&udpAddr,sizeof(SOCKADDR));
				if (nRet == SOCKET_ERROR) {
					errCode = WSAGetLastError ();
					if (errCode != WSAEWOULDBLOCK) {
						cout << "Error sending data to client during retry " <<id <<" "<< errCode << "\n";		
						Suicide ();
						return -1;
					}
				} 
				else {
					break;
				}

				tries++;
			}
			if (tries == 10) {
				cout << "Error retrying sending data to client " <<id <<" "<< errCode << "\n";		
				Suicide ();
				return -1;
			}

		} 
		else {
			cout << "Error sending data to client " <<id <<" "<< errCode << "\n";		
			Suicide ();
			return -1;
		}
	}

	return 1;
}

int 
CClient::SendInitStrings()
{
/*	if(0==(initStringNum%10)){
		int stringnum=initStringNum/10;
		while(initstrings.strings[stringnum].empty() && stringnum<100){
			stringnum+=1;
		}
		if(stringnum==100){
			connectionState=2;
			return 1;
		}
		SendString(initstrings.strings[stringnum].c_str(),initstrings.strings[stringnum].size());
		initStringNum=stringnum*10;
	}
	initStringNum++;
	if(initStringNum>1000)
		connectionState=2;
	return 1; */

	int stringnum=initStringNum;
	while(initstrings.strings[stringnum].empty() && stringnum<MAX_INIT_STRINGS){
		stringnum+=1;
	}
	if(stringnum==MAX_INIT_STRINGS){
		connectionState=2;
		return 1;
	}
	SendString(initstrings.strings[stringnum].c_str(),initstrings.strings[stringnum].size());
	initStringNum=stringnum;
	
	initStringNum++;
	if(initStringNum>MAX_INIT_STRINGS)
		connectionState=2;
	return 1; 
}

#ifndef _WIN32

unsigned int gettickcount()
{
	static struct timeb start;
  struct timeb timeb;
  ftime( &timeb);
	if(!start.time)
		start = timeb;
	return (timeb.time - start.time)* 1000 + timeb.millitm - start.millitm;
}

#endif
