//=============================================================================
// lolBowlingPin.
//=============================================================================
class lolBowlingPin extends Decoration;

#exec MESH IMPORT MESH=lolBowlingPin ANIVFILE=MODELS\lolBowlingPin_a.3d DATAFILE=MODELS\lolBowlingPin_d.3d X=0 Y=0 Z=0 MLOD=0
#exec MESH ORIGIN MESH=lolBowlingPin X=0 Y=0 Z=0 YAW=64

#exec MESH SEQUENCE MESH=lolBowlingPin SEQ=All    STARTFRAME=0   NUMFRAMES=1
#exec MESH SEQUENCE MESH=lolBowlingPin SEQ=Still  STARTFRAME=0   NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JWhite FILE=TEXTURES\White.PCX GROUP=Skins
#exec TEXTURE IMPORT NAME=JRed FILE=TEXTURES\Red.PCX GROUP=Skins
#exec TEXTURE IMPORT NAME=Jlolpin FILE=TEXTURES\lolpin.PCX GROUP=Skins

#exec MESHMAP SCALE MESHMAP=lolBowlingPin X=0.25000 Y=0.25000 Z=0.50000

#exec MESHMAP SETTEXTURE MESHMAP=lolBowlingPin NUM=0 TEXTURE=JWhite
#exec MESHMAP SETTEXTURE MESHMAP=lolBowlingPin NUM=1 TEXTURE=JRed
#exec MESHMAP SETTEXTURE MESHMAP=lolBowlingPin NUM=2 TEXTURE=Jlolpin

var bool bFirstHit;

function Attach( Actor Other )
{
	Velocity.X = 0;
	Velocity.Y = 0;
	Velocity.Z = FMin(0, Velocity.Z);
}

function Timer()
{
	SetCollision(true,true,true);
}

function Bump( actor Other )
{
	if( Other.Mass >= 40 )
	{
		bBobbing = false;
		Velocity += 1.5 * VSize(Other.Velocity) * Normal(Location - Other.Location);
		if ( Physics == PHYS_None ) 
			Velocity.Z = FMax(Velocity.Z,250);
		SetPhysics(PHYS_Falling);
		SetTimer(0.3,False);
		Instigator = Pawn(Other);
		SetCollision(true,false,false);
		StartRotating();
	}
}

function StartRotating()
{
	RotationRate.Yaw = 250000*FRand() - 125000;
	RotationRate.Pitch = 250000*FRand() - 125000;
	RotationRate.Roll = 250000*FRand() - 125000;	
	DesiredRotation = RotRand();
	bRotateToDesired=False;
	bFixedRotationDir=True;
	bFirstHit=True;
}

function Landed(vector HitNormal)
{
	local Rotator NewRot;
	Super.Landed(HitNormal);
	NewRot = Rotation;
	NewRot.Pitch = 0;
	SetRotation(NewRot);
}

Auto State Animate
{
	function HitWall (vector HitNormal, actor Wall)
	{
		local float speed;

		Velocity = 0.5*(( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
		speed = VSize(Velocity);
		if (bFirstHit && speed<400) 
		{
			bFirstHit=False;
			bRotatetoDesired=True;
			bFixedRotationDir=False;
			DesiredRotation.Yaw=Rand(65535);
			DesiredRotation.Pitch=Rand(65535);
			DesiredRotation.Roll=0;
		}
		RotationRate.Yaw = RotationRate.Yaw*0.75;
		RotationRate.Roll = RotationRate.Roll*0.75;
		RotationRate.Pitch = RotationRate.Pitch*0.75;	
		If (speed < 50) 
		{
			bBounce = False;
			DesiredRotation.Yaw = Rotation.Yaw;
			DesiredRotation.Roll = Rotation.Roll;
			DesiredRotation.Pitch = Rotation.Pitch;
			SetRotation(DesiredRotation);
		}
	}	

	function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
	{
		if ( StandingCount > 0 )
			return;
		SetPhysics(PHYS_Falling);
		bBounce = True;
		Velocity += Momentum/Mass;
		Velocity.Z = FMax(Momentum.Z, 200);
		StartRotating();
	}
}

defaultproperties
{
     bPushable=True
     bStatic=False
//   bNetTemporary=True
     bNetTemporary=False
//   RemoteRole=ROLE_None
//   bNet=False
     bNet=True
     DrawType=DT_Mesh
     Mesh=Mesh'lolBowlingPin'
     CollisionRadius=8.000000
     CollisionHeight=10.000000
     MultiSkins(0)=Texture'lolBowlingPin.White'
     MultiSkins(1)=Texture'lolBowlingPin.Red'
     MultiSkins(2)=Texture'lolBowlingPin.lolpin'
     bCollideActors=True
     bCollideWorld=True
     bBlockActors=True
     bBlockPlayers=True
     bProjTarget=True
     Mass=35.000000
     Buoyancy=40.000000
}
