///////////////////////////////////////////////////////////////////////
// uTestMain - Actor to test script timings
// 
// 				Feralidragon - 27/05/2011
//				Version 1.0
///////////////////////////////////////////////////////////////////////
class uTestMain expands Actor
abstract;

enum ETickBaseType
{
	TICK_Average,
	TICK_Median,
	TICK_Minimum,
	TICK_Maximum
};

enum ETimingType
{
	TIME_NanoSeconds,
	TIME_MiliSeconds,
	TIME_Seconds
};

var() ETickBaseType TickBaseType;
var() ETimingType TimingType;
var() int TickBaseCalcPrecision;
var() int CyclesPerTest;
var() bool bTestEndBeep;
var() float TestDelay;
var() bool bShowFinalResultsInTable;

struct TestStruct
{
	var() bool enableTest;
	var() string TestTitle;
	var() name TestName;
	var string TestRes;
};

var() TestStruct Tests[20];

//Internals
var int n, nCount, tPrecision;
var float BaseTickDelta, timeFactor;
var string timeFactorName;
var float Deltas[100];
var int TickToTestDelay;
var float TotalTime;
const uTestLog = 'uTest';


function PreBeginPlay()
{
	if (TimingType == TIME_NanoSeconds)
	{
		timeFactor = 1000000.f;
		timeFactorName = "ns";
	}
	else if (TimingType == TIME_MiliSeconds)
	{
		timeFactor = 1000.f;
		timeFactorName = "ms";
	}
	else
	{
		timeFactor = 1.f;
		timeFactorName = "s";
	}
	
	tPrecision = TickBaseCalcPrecision+1;
	if (TickBaseType == TICK_Median)
		tPrecision = Min(tPrecision, ArrayCount(Deltas));
	
	TickToTestDelay = tPrecision + 10;
}


function Tick(float Delta)
{
local int i;
local byte j;
local int TitleSize, ResSize;
local string tableLine, tableLineFirst, deltaStr;

	TotalTime += Delta;

	//Wait TestDelay seconds for tick time stabilize and the testings to start
	if (TestDelay > 0 && LifeSpan >= (Default.LifeSpan - TestDelay))
	{
		if (n == 0)
		{
			log("*******************************************************************************", uTestLog);
			log("******************************* UTEST STARTED *********************************", uTestLog);
			log("*******************************************************************************", uTestLog);
			log("Starting uTest...", uTestLog);
			n = 1;
		}
		return;
	}
	
	//Calculate base tick time
	if (n >= 1 && n <= tPrecision)
	{
		if (n == 1)
			log("Processing base Tick Delta time...", uTestLog);
		else if (TickBaseType == TICK_Average)
		{
			BaseTickDelta += Delta;
			nCount++;
			
			if (n == tPrecision)
				BaseTickDelta /= nCount;
		}
		else if (TickBaseType == TICK_Median)
		{
			Deltas[nCount] = Delta;
			nCount++;
			
			if (n == tPrecision)
			{
				SortDeltas();
				if ((nCount & 1) == 1)
					BaseTickDelta = Deltas[(nCount+1)/2];
				else
					BaseTickDelta = (Deltas[nCount/2] + Deltas[nCount/2 + 1]) / 2;
			}
		}
		else if (TickBaseType == TICK_Minimum)
		{
			if (Delta < BaseTickDelta || BaseTickDelta == 0)
				BaseTickDelta = Delta;
		}
		else if (TickBaseType == TICK_Maximum && Delta > BaseTickDelta)
			BaseTickDelta = Delta;
		
		if (n == tPrecision)
			log("Base Tick Delta Time = "$(BaseTickDelta*timeFactor)$timeFactorName, uTestLog);
			
		
		n++;
		return;
	}
	
	n++;
	
	//Testings
	if (n >= TickToTestDelay && n < (TickToTestDelay + ArrayCount(Tests)*2))
	{
		j = Byte((n - TickToTestDelay) / 2);
		if (Tests[j].enableTest)
		{
			if (((n-TickToTestDelay) & 1) == 0)
			{
				log("*******************************************************************************", Tests[j].TestName);
				log("* Executing test: "$Tests[j].TestTitle, Tests[j].TestName);
				
				if (j == 0)			for(i=0;i<CyclesPerTest;i++)Test0();
				else if (j == 1) 	for(i=0;i<CyclesPerTest;i++)Test1();
				else if (j == 2) 	for(i=0;i<CyclesPerTest;i++)Test2();
				else if (j == 3) 	for(i=0;i<CyclesPerTest;i++)Test3();
				else if (j == 4) 	for(i=0;i<CyclesPerTest;i++)Test4();
				else if (j == 5) 	for(i=0;i<CyclesPerTest;i++)Test5();
				else if (j == 6) 	for(i=0;i<CyclesPerTest;i++)Test6();
				else if (j == 7) 	for(i=0;i<CyclesPerTest;i++)Test7();
				else if (j == 8) 	for(i=0;i<CyclesPerTest;i++)Test8();
				else if (j == 9) 	for(i=0;i<CyclesPerTest;i++)Test9();
				else if (j == 10) 	for(i=0;i<CyclesPerTest;i++)Test10();
				else if (j == 11) 	for(i=0;i<CyclesPerTest;i++)Test11();
				else if (j == 12) 	for(i=0;i<CyclesPerTest;i++)Test12();
				else if (j == 13) 	for(i=0;i<CyclesPerTest;i++)Test13();
				else if (j == 14) 	for(i=0;i<CyclesPerTest;i++)Test14();
				else if (j == 15) 	for(i=0;i<CyclesPerTest;i++)Test15();
				else if (j == 16) 	for(i=0;i<CyclesPerTest;i++)Test16();
				else if (j == 17) 	for(i=0;i<CyclesPerTest;i++)Test17();
				else if (j == 18) 	for(i=0;i<CyclesPerTest;i++)Test18();
				else if (j == 19) 	for(i=0;i<CyclesPerTest;i++)Test19();
			}
			else
			{
				log("* Time taken: "$((Delta - BaseTickDelta)*timeFactor)$timeFactorName, Tests[j].TestName);
				Tests[j].TestRes = ((Delta - BaseTickDelta)*timeFactor)$timeFactorName;
			}
		}
		
		return;
	}
	
	//Finishing test
	if (n == (TickToTestDelay + ArrayCount(Tests)*2))
	{
		//Show table
		if (bShowFinalResultsInTable)
		{
			for (j = 0; j < ArrayCount(Tests); j++)
			{
				if (Tests[j].enableTest)
				{
					if (TitleSize < Len(String(Tests[j].TestName)))
						TitleSize = Len(String(Tests[j].TestName));
					if (ResSize < Len(Tests[j].TestRes))
						ResSize = Len(Tests[j].TestRes);
				}
			}
			
			TitleSize = Max(TitleSize, Len("TickBaseTime"));
			tableLine = "+" $ GetStringArray("-", TitleSize + 2) $ "+" $ GetStringArray("-", ResSize + 2) $ "+";
			tableLineFirst = "+" $ GetStringArray("-", TitleSize + 2) $ "-" $ GetStringArray("-", ResSize + 2) $ "+";
			
			log(" ", uTestLog);
			log(tableLineFirst, uTestLog);
			log("|   Test Results Table " $ GetStringArray(" ", Len(tableLine)-Len("|   Test Results Table ")-1) $ "|", uTestLog);
			log(tableLine, uTestLog);
			deltaStr = (BaseTickDelta*timeFactor)$timeFactorName;
			log("| TickBaseTime" $ GetStringArray(" ", TitleSize-Len("TickBaseTime")) $ " | " $ deltaStr $ 
				GetStringArray(" ", ResSize-Len(deltaStr)) $ " |", uTestLog);
			log(tableLine, uTestLog);
			for (j = 0; j < ArrayCount(Tests); j++)
			{
				if (Tests[j].enableTest)
				{
					log("| " $ Tests[j].TestName $ GetStringArray(" ", TitleSize-Len(Tests[j].TestName)) $ " | " $ 
						Tests[j].TestRes $ GetStringArray(" ", ResSize-Len(Tests[j].TestRes)) $ " |", uTestLog);
					log(tableLine, uTestLog);
				}
			}
			log(" ", uTestLog);
		}
	
		
		//Show final logs
		log(" Total testing time: " $ TotalTime $ " seconds", uTestLog); 
		log("*******************************************************************************", uTestLog);
		log("******************************* UTEST FINISHED ********************************", uTestLog);
		log("*******************************************************************************", uTestLog);
		BroadcastMessage("TESTING FINISHED", bTestEndBeep, 'CriticalEvent');
		Destroy();
	}
}

//Sort deltas using the Gnome Sorting algorithm (because of its simplicity)
function SortDeltas()
{
local byte i;
local float tempF;
	
	if (nCount <= 1)
		return;

	i = 1;
	while (i < nCount)
	{
		if (Deltas[i] >= Deltas[i-1])
			i++;
		else
		{
			tempF = Deltas[i];
			Deltas[i] = Deltas[i-1];
			Deltas[i-1] = tempF;
			
			if (i > 1)
				i--;
			else
				i++;
		}
	}
}

function string GetStringArray(string str, int size)
{
local int i;
local string s;

	s = "";
	for (i = 0; i < size; i++)
		s = s $ str;
	return s;
}


//Implement in subclasses (like uTest)
function Test0();
function Test1();
function Test2();
function Test3();
function Test4();
function Test5();
function Test6();
function Test7();
function Test8();
function Test9();
function Test10();
function Test11();
function Test12();
function Test13();
function Test14();
function Test15();
function Test16();
function Test17();
function Test18();
function Test19();


defaultproperties
{
	LifeSpan=1000.000000
	
	TickBaseType=TICK_Average
	TimingType=TIME_MiliSeconds
	TickBaseCalcPrecision=30
	CyclesPerTest=70
	bTestEndBeep=True
	TestDelay=2.000000
	bShowFinalResultsInTable=True
}