//=============================================================================
// UT99 Extension Pack V1.0
// - Basic Edition -
// class by Shadow
// XTProjectile, main class for all emitter supporting projectiles
//=============================================================================
class XTProjectile expands Projectile;


var() class<particleemitter> ExploEmitter,MiscEmitter,SpawnEmitter,AttachedEmitter,HitEmitter;
var() bool bUseExploEmitter,bUseMiscEmitter,bUseSpawnEmitter,bUseAttachedEmitter;
var() float ExploEmitLifespan,MiscEmitLifespan,SpawnEmitLifespan,AttachedEmitLifespan;
var() bool bRandomizeImpactSound,bRandomizeSpawnSound;
var() float BounceHeight,AccelerationAmount,FlashRadius,ShakeRadius,FlashScale,ShakeTime,ShakeVert,ShakeMag;
var() vector FlashFog;
var() int MaxWallHits;
var() bool bAddHitOverlayer,bAddHitVertexAura,bAddHitEnvMap;
var() texture HitOverlayer,HitAuraShade,HitEnvMap,CoronaSkin;
var() float HitOverlayerStaytime,HitAuraShadeStaytime,HitEnvMapStaytime,HitAuraShadeSize,VelocityReducer;
var() sound RandZChangeSounds[3],ZoneChangeSound,RandImpactSounds[4],RandSpawnSounds[3],RandBounceSounds[3],BounceSound;
var() bool bBounceSound,bRandBounceSounds,bExplodeIfContact,bIsGrenade,bRandZoneChangeSounds,bDecalShadow,bHasAcceleration,bExplodeIfHitWall;

var() enum EBSPMode
{
	BMode_Destroy,
	BMode_Bounce,
	BMode_Slide,
	BMode_Stuck,
	BMode_Glue,
	BMode_Reflect,
	BMode_AdvReflect
}BSPMode;

var() enum EFlashMode
{
	FMode_None,
	FMode_Radius,
	FMode_IfHitBsp,
	FMode_IfExplode,
	FMode_IfHitPawn,
	FMode_Any
}FlashMode;

var() enum EShakeMode
{
	SMode_None,
	SMode_Radius,
	SMode_IfHitBsp,
	SMode_IfExplode,
	SMode_IfHitPawn,
	SMode_Any
}ShakeMode;

//internal
var decal d;
var particleemitter a,s,e,m;
var dynamiccorona dc;

simulated function PostBeginplay()
{
	local vector dir;
	velocity=vector(rotation)*speed;
	if (bhasacceleration)acceleration=velocity*accelerationamount;
	if(bcorona)
	{
		dc=spawn(class'dynamiccorona',self);
		dc.setphysics(phys_trailer);
		dc.skin=coronaskin;
		dc.scaleglow=scaleglow;
		dc.spriteprojforward=spriteprojforward;
		dc.distancefactor=512;
	}
	if(busespawnemitter){getsemitter(spawnemitter,location,rotation,spawnemitlifespan);}
	if(buseattachedemitter)
	{
		if(attachedemitter!=none)getattachedemitter(AttachedEmitter,location,rotation,attachedemitlifespan);
	}
	if (brandomizespawnsound)
	{
		if (frand()<0.25)playsound(randspawnsounds[0],slot_none,4.0);
		else if (frand()<0.3)playsound(randspawnsounds[1],slot_none,4.0);
		else playsound(randspawnsounds[2],slot_none,4.0);
	}
	else playsound(spawnsound);
}
function GetSEmitter(class<particleemitter> pclass,vector v,rotator dir,float l)
{
	if(class'xtmutator'.default.particledetail!=0)
	{
		s=spawn(pclass,,,v,dir);s.lifespan=l;
	}
}
function GetEEmitter(class<particleemitter> pclass,vector v,rotator dir,float l)
{
	if(class'xtmutator'.default.particledetail!=0)
	{
		e=spawn(pclass,,,v,dir);e.lifespan=l;
	}
}
function GetMEmitter(class<particleemitter> pclass,vector v,rotator dir,float l)
{
	if(class'xtmutator'.default.particledetail!=0)
	{
		m=spawn(pclass,,,v,dir);
		m.lifespan=l;
	}
}
function GetAttachedEmitter(class<particleemitter> pclass,vector v,rotator dir,float l)
{
	if(class'xtmutator'.default.particledetail!=0)
	{
		a=spawn(pclass,,,v,dir);
		a.followactor=self;
		a.lifespan=l;
	}
}
simulated function ZoneChange(zoneinfo newzone)
{
	if (level.netmode!=nm_dedicatedserver)
	{
		if(busemiscemitter)
		{
			getmemitter(miscemitter,location,rot(16384,0,0),miscemitlifespan);
        }
	}
	velocity=velocityreducer*velocity;
	if (brandzonechangesounds)
	{
		if (frand()<0.2)Playsound(randzchangesounds[0],slot_none,4.0);
		else if (frand()<0.3)playsound(randzchangesounds[1],slot_none,4.0);
		else playsound(randzchangesounds[2],slot_none,4.0);
	}
	else playsound(zonechangesound);
}
simulated function Hitwall(vector hitnormal,actor wall)
{
	local vector slidevect,Vel2D, Norm2D;
	local int numwallhits;
	local pawn dude;
	local playerpawn pp;
	if (shakemode==smode_ifhitbsp||shakemode==smode_any)
	{
		dude=level.pawnlist;
		foreach radiusactors(class'pawn',dude,shakeradius){
			while (dude!=None){if (playerpawn(dude)!=none)playerpawn(dude).shakeview(shaketime,shakemag,shakevert);
				dude=dude.nextpawn;
			}
		}
	}if (bbouncesound){
		if (level.netmode!=nm_dedicatedserver){
			if (brandbouncesounds){
				if (frand()<0.2)playsound(randbouncesounds[0],slot_misc,1.5);
				else if (frand()<0.3)playsound(randbouncesounds[1],slot_misc,1.5);
				else playsound(randbouncesounds[2],slot_misc,1.5);
			}else playsound(bouncesound,slot_misc,1.5);
		}
	}if (brandomizeimpactsound)
	{
		if (frand()<0.125)playsound(randimpactsounds[0],slot_none,4.0);
		else if (frand()<0.2)playsound(randimpactsounds[1],slot_none,4.0);
		else if (frand()<0.3)playsound(randimpactsounds[2],slot_none,4.0);
		else playsound(randimpactsounds[3],slot_none,4.0);
	}else{ playsound(impactsound,slot_none,4.0);}
	if (flashmode==fmode_ifhitbsp||flashmode==fmode_any)
	{
		foreach radiusactors(class'playerpawn',pp,flashradius)pp.clientflash(flashscale,flashfog);
    }
	if (bspmode==bmode_destroy)
    {
        bbounce=false;
        super.hitwall(hitnormal,wall);
		if (bexplodeifhitwall)
        {
			Explode(Location + ExploWallOut * HitNormal, HitNormal);
			if ( (ExplosionDecal != None) && (Level.NetMode != NM_DedicatedServer) )
				Spawn(ExplosionDecal,self,,Location, rotator(HitNormal));
		}
	}else if (bspmode==bmode_slide){
		bbounce=false;slidevect=velocity+mirrorvectorbynormal(velocity,hitnormal);
		setlocation(location+2.0*hitnormal);acceleration*=0.5;velocity=vector(rotation)*speed;
		velocity=vsize(velocity)*(normal(velocity)+0.05*normal(vrand()));
		if (bexplodeifhitwall){
			Explode(Location + ExploWallOut * HitNormal, HitNormal);
			if ( (ExplosionDecal != None) && (Level.NetMode != NM_DedicatedServer) )
				Spawn(ExplosionDecal,self,,Location, rotator(HitNormal));
		}
	}else if (bspmode==bmode_glue){
		bbounce=false;velocity=0.75*((velocity dot hitnormal)*hitnormal*(-0.25)+velocity);randspin(100000);
		speed=vsize(velocity);
		if ( Velocity.z > 400)Velocity.Z = 0.5 * (400 + Velocity.Z);
		else if ( speed < 20 )SetPhysics(PHYS_None);
		if (bexplodeifhitwall){
			Explode(Location + ExploWallOut * HitNormal, HitNormal);
			if ( (ExplosionDecal != None) && (Level.NetMode != NM_DedicatedServer) )
				Spawn(ExplosionDecal,self,,Location, rotator(HitNormal));
		}
	}else if (bspmode==bmode_advreflect){
		if ( (Mover(Wall) != None) && Mover(Wall).bDamageTriggered ){
			if ( Role == ROLE_Authority )
				Wall.TakeDamage( Damage, instigator, Location, MomentumTransfer * Normal(Velocity), MyDamageType);
			if (bexplodeifhitwall){
				Explode(Location + ExploWallOut * HitNormal, HitNormal);
				if ( (ExplosionDecal != None) && (Level.NetMode != NM_DedicatedServer) )
					Spawn(ExplosionDecal,self,,Location, rotator(HitNormal));
			}
			else Destroy();
			return;
		}
		numwallhits++;makenoise(0.4);
		if (numwallhits>maxwallhits)destroy();
		if ( NumWallHits == 1 ){
			Vel2D = Velocity;Vel2D.Z = 0;Norm2D = HitNormal;Norm2D.Z = 0;Norm2D = Normal(Norm2D);Vel2D = Normal(Vel2D);
			if ( (Vel2D Dot Norm2D) < -0.999 ){
				HitNormal = Normal(HitNormal + 0.6 * Vel2D);Norm2D = HitNormal;Norm2D.Z = 0;Norm2D = Normal(Norm2D);
				if ( (Vel2D Dot Norm2D) < -0.999 ){
					if ( Rand(1) == 0 )	HitNormal = HitNormal + vect(0.05,0,0);
					else HitNormal = HitNormal - vect(0.05,0,0);
					if ( Rand(1) == 0 )HitNormal = HitNormal + vect(0,0.05,0);
					else HitNormal = HitNormal - vect(0,0.05,0);
					HitNormal = Normal(HitNormal);
				}
			}
		}
		Velocity -= 2 * (Velocity dot HitNormal) * HitNormal;SetRoll(Velocity);
	}else if (bspmode==bmode_reflect){
		if ( (Mover(Wall) != None) && Mover(Wall).bDamageTriggered )
		{
			if ( role==role_authority )
				Wall.TakeDamage( Damage, instigator, Location, MomentumTransfer * Normal(Velocity), '');
			if (bexplodeifhitwall){
				Explode(Location + ExploWallOut * HitNormal, HitNormal);
				if ( (ExplosionDecal != None) && (Level.NetMode != NM_DedicatedServer) )
					Spawn(ExplosionDecal,self,,Location, rotator(HitNormal));
			}
			else Destroy();
			return;
		}
		NumWallHits++;makenoise(0.3);
		if (numwallhits>maxwallhits){if (bexplodeifhitwall)explode(hitnormal,hitnormal);else destroy();}
		Velocity -= 2 * ( Velocity dot HitNormal) * HitNormal;
		SetRoll(Velocity);
	}
	else if (bspmode==bmode_bounce)
	{
		Velocity = 0.8*(( Velocity dot HitNormal ) * HitNormal * (-BounceHeight) + Velocity); RandSpin(100000);
		speed = VSize(Velocity);
		if ( Velocity.z > 400)Velocity.Z = 0.5 * (400 + Velocity.Z);
		else if ( speed < 20 ){bBounce = False;SetPhysics(PHYS_None);}
		if (bexplodeifhitwall){
			Explode(Location + ExploWallOut * HitNormal, HitNormal);
			if ( (ExplosionDecal != None) && (Level.NetMode != NM_DedicatedServer) )
				Spawn(ExplosionDecal,self,,Location, rotator(HitNormal));
		}
	}
	else if (bspmode==bmode_stuck){
		if (bexplodeifhitwall){
			Explode(Location + ExploWallOut * HitNormal, HitNormal);if ( (ExplosionDecal != None) && (Level.NetMode != NM_DedicatedServer) )Spawn(ExplosionDecal,self,,Location, rotator(HitNormal));
		}speed=0;maxspeed=0;setphysics(phys_none);
	}
}
simulated function Explode(vector hitlocation,vector hitnormal)
{
	local pawn dude;
	local playerpawn pp;
	if(buseexploemitter)
	{
		if(exploemitter!=none)geteemitter(exploemitter,hitlocation,rotator(hitnormal),exploemitlifespan);
	}
	if (brandomizeimpactsound)
	{
		if (frand()<0.125)playsound(randimpactsounds[0],slot_none,4.0);
		else if (frand()<0.2)playsound(randimpactsounds[1],slot_none,4.0);
		else if (frand()<0.3)playsound(randimpactsounds[2],slot_none,4.0);
		else playsound(randimpactsounds[3],slot_none,4.0);
	}
	else playsound(impactsound,slot_none,4.0);
	if (shakemode==smode_ifexplode||shakemode==smode_any)
	{
		dude=level.pawnlist;
		foreach radiusactors(class'pawn',dude,shakeradius)
		{
			while(dude!=none){if (playerpawn(dude)!=none)playerpawn(dude).shakeview(shaketime,shakemag,shakevert);
				dude=dude.nextpawn;}}}if (flashmode==fmode_ifexplode||flashmode==fmode_any){foreach radiusactors(class'playerpawn',pp,flashradius)pp.clientflash(flashscale,flashfog);}destroy();
}
simulated function ProcessTouch(actor other,vector hitlocation)
{
	local pawn dude;
	local playerpawn pp;
	if (other.isa('pawn'))
	{
		if (other!=instigator)
		{
			if ( Role == ROLE_Authority )Other.TakeDamage( Damage, instigator, HitLocation, MomentumTransfer*Vector(Rotation), MyDamageType);
			if (bexplodeifcontact){Explode(HitLocation, vect(0,0,1));}}
			if (shakemode==smode_ifhitpawn||shakemode==smode_any)
			{
				dude=level.pawnlist;
				foreach radiusactors(class'pawn',dude,shakeradius){
					while(dude!=none){if (playerpawn(dude)!=none)playerpawn(dude).shakeview(shaketime,shakemag,shakevert);
						dude=dude.nextpawn;
				}
			}
		}
		if (flashmode==fmode_ifexplode||flashmode==fmode_any)
		{
			foreach radiusactors(class'playerpawn',pp,flashradius)pp.clientflash(flashscale,flashfog);
		}
	}
	if (other.isa('xtpawn'))
	{
		if (baddhitoverlayer)xtpawn(other).addhitoverlayer(hitoverlayer,1.0,hitoverlayerstaytime);
		if (baddhitenvmap)xtpawn(other).addhitenviromap(hitenvmap,1.0,hitenvmapstaytime);
		if (baddhitvertexaura)
			xtpawn(other).addhitvertexaura(hitaurashade,1.0,0.4,hitaurashadesize,hitaurashadestaytime,128);
	}
}

simulated function Tick(float deltatime)
{
	local pawn dude;
	local playerpawn pp;
	if (shakemode==smode_radius)
	{
		dude=level.pawnlist;
		foreach radiusactors(class'pawn',dude,shakeradius)
		{
			while(dude!=none)
			{
				if (playerpawn(dude)!=none)playerpawn(dude).shakeview(shaketime,shakemag,shakevert);
				dude=dude.nextpawn;
			}
		}
	}
	if (flashmode==fmode_radius)
	{
		foreach radiusactors(class'playerpawn',pp,flashradius)pp.clientflash(flashscale,flashfog);
	}
}
simulated function SetRoll(vector newvelocity){class'xtPhysicutil'.static.setroll(newvelocity,self);}
simulated function Destroyed()
{
	if (dc!=none){dc.destroy();}
	if (s!=none)
	{
		if(spawnemitlifespan==0)s.destroy();
	}
	if (e!=none){if(exploemitlifespan==0)e.destroy();}
	if (m!=none){if(miscemitlifespan==0)m.destroy();}
	if (a!=none){if(attachedemitlifespan==0)a.destroy();}
	super.destroyed();
}

defaultproperties
{
}
