//=============================================================================
// UT99 Extension Pack V1.0
// - Basic Edition -
// by Shadow
// XTPawn, base class for all creatures with extended effects, enhanced AI etc.
//=============================================================================
class XTPawn expands ScriptedPawn;

//environment/cubemap variables:
var(Display) float EnviroMapBrightness,EnviroMapDrawHeight,EnviroMapDrawRadius;
var(Display) texture EnvironmentMaps[4];
var(Display) bool bUnlitEnviroMap;
var(Display) enum EEnviroMapStyle
{
	ESty_Normal,
	ESty_Masked,
	ESty_Modulated,
	ESty_Translucent
}EnviroMapStyle;

//additional:
var(FX) class<particleemitter> Hitemitter,FxEmitter;
var(FX) texture BloodMaterial;

//Aura-Shading :
var(AuraShade) float AuraDrawHeight,AuraDrawRadius,AuraTranslucenties[2];
var(AuraShade) texture AuraMaterials[2];
var(AuraShade) float AuraSizes[2],AuraLOD[2];
var(AuraShade) enum EAuraStyle{ASty_Add,ASty_Masked,ASty_Translucent,ASty_Modulated}AuraStyle;

//overlayer/skinmodifier
var(Modifier) float ModifierTranslucenties[8],ModifierDrawHeight[8],ModifierDrawRadius[8];
var(Modifier) texture Modifier[8],MultiModifier1[8],MultiModifier2[8];
var(Modifier) bool bUnlitModifier,bFixedOverlay;
var(Modifier) enum EOverlayerStyle
{
	SSty_Normal,
	SSty_Masked,
	SSty_Translucent,
	SSty_Modulated
}OverlayerStyle;

//detail texture :
var(Display) texture DetailMap;

//eye feature (if enabled, subclassed pawns can open/close their eyes, overlaybased) :
var() bool bEnableEyeOverlays,bUnlitEyes;
var() float EyeOpeningTime,EyeClosingTime,EyeBrightness,MinEyeOpentime,MaxEyeOpentime,MinEyeClosedtime,MaxEyeclosedtime;
var() texture EyeOverlays[2];

//control stuff
var(Remote) bool bUseEnvironmentMap,bUseOverlayer,bUseDetailTexture,bUseAuraShading;

//internal/misc
var skinmodifier mod[8],mod2[2],detail;
var auracontroller vparticle[2],vertexaura;
var int styleint,styleint2,styleint3,shadstyle,styleint4,ei,oi,oi2,oi3,oi4,ai;
var skinmodifier hitoverlayer,eyeoverlayer;
var environmentmapactor hitenviro,env[4];
var int lmparam;
var float processcount;
var bool baugenauf,baugenzu;
var texture tempeyes;

function vector vect2D(float x,float y){return class'XTMainUtil'.static.vect2D(x,y);}

simulated function PostBeginPlay()
{
	if (benableeyeoverlays)
	{
		baugenauf=true;
		toggleeyeoverlays();
		processcount=0;
	}
	seteffects(buseenvironmentmap,buseoverlayer,busedetailtexture,bUseAuraShading);
}
function ToggleEyeOverlays()
{
	enable('tick');
	eyeoverlayer=spawn(class'skinmodifier',self,,location,rotation);
	eyeoverlayer.seteyes(mesh,fatness,eyebrightness,bUnlitEyes,lodbias,drawscale);
}
simulated function Tick(float deltatime)
{
	local int i;
	if (benableeyeoverlays)
	{
		if (baugenauf)processcount+=0.2+frand()*(deltatime/eyeopeningtime);
		if (processcount>=1)
		{
			processcount=1;baugenauf=false;
		}
		if (processcount==1)
		{
			baugenauf=false;
			baugenzu=true;
			eyeoverlayer.skin=eyeoverlays[0];
		}
		if (baugenzu)processcount-=0+frand()*(deltatime/eyeclosingtime);
		if (processcount<=0)
		{
			processcount=0;baugenzu=false;
		}
		if (processcount==0)
		{
			baugenauf=true;
			baugenzu=false;
			eyeoverlayer.skin=eyeoverlays[1];
		}
		Super.Tick(deltatime);
	}
}
simulated function SetEffects(bool enviro,bool over,bool det,bool baura)
{
	local actor lightfrom;
	local vector hitnormal,temppivot1,temppivot2;
	local float tempscale[8];
	local int i;
	if (enviro)
	{
		for(ei=0;ei<3;ei++)
		{
			setstyleperint();
			env[ei]=spawn(class'environmentmapactor',self,,location,rotation);
			env[ei].setenviromap(environmentmaps[ei],drawscale,enviromapbrightness,mesh,bunlitenviromap,enviromapdrawheight,enviromapdrawradius,fatness,lodbias,styleint,true,false);
			if (environmentmaps[ei]==none)env[ei].destroy();
		}
	}
	if (det)
	{
		detail=spawn(class'skinmodifier',self,,location,rotation);
		detail.getxtraprops(mesh,fatness,DetailMap,0,0,lodbias,drawscale);
	}
	if (baura)
	{
		for(ai=0;ai<2;ai++)
		{
			setstyleperint();
			if (auramaterials[ai]!=none)
			{
				vparticle[ai]=spawn(class'auracontroller',self,,location,rotation);
				vparticle[ai].vertexparticle(mesh,aurasizes[ai],auratranslucenties[ai],AuraMaterials[ai],AuraDrawradius,AuraDrawheight,AuraLod[ai],fatness,styleint4);
			}
		}
	}
	if (over)
	{
		if (!bismultiskinned)
		{
			if (bfixedoverlay)
			{
				tempscale[0]=drawscale+0.005;
				tempscale[1]=drawscale+0.0075;
				tempscale[2]=drawscale+0.0125;
				tempscale[3]=drawscale+0.025;
				tempscale[4]=drawscale+0.05;
				tempscale[5]=drawscale+0.075;
				tempscale[6]=drawscale+0.1;
				tempscale[7]=drawscale+0.15;
			}
			else
			{
				tempscale[0]=drawscale;
				tempscale[1]=drawscale;
				tempscale[2]=drawscale;
				tempscale[3]=drawscale;
				tempscale[4]=drawscale;
				tempscale[5]=drawscale;
				tempscale[6]=drawscale;
				tempscale[7]=drawscale;
			}
			setstyleperint();
			for(oi=0;oi<8;oi++)
			{
				mod[oi]=spawn(class'skinmodifier',self,,location,rotation);
				mod[oi].setskinmodifier(mesh,fatness,modifiertranslucenties[oi],bUnlitModifier,ModifierDrawRadius[oi],ModifierDrawHeight[oi],Modifier[oi],lodbias,tempscale[oi],styleint3,false);
				if (modifier[oi]==none)mod[oi].destroy();
			}
		}
		else
		{
			for(oi2=0;oi2<2;oi2++)
			{
				setstyleperint();
				mod2[oi2]=spawn(class'skinmodifier',self,,location,rotation);
				mod2[oi2].setskinmodifier(mesh,fatness,modifiertranslucenties[0],bUnlitModifier,ModifierDrawRadius[oi2],ModifierDrawHeight[oi2],none,lodbias,tempscale[oi2],styleint3,true);
				mod2[oi2].multioverlayer(multimodifier1[0],multimodifier1[1],multimodifier1[2],multimodifier1[3],multimodifier1[4],multimodifier1[5],multimodifier1[6],multimodifier1[7]);
				for(oi3=0;oi3<8;oi3++)
				{
					if (multimodifier1[oi3]==none)mod2[oi2].destroy();
				}
				for(oi4=0;oi4<8;oi4++)
				{
					if (multimodifier2[oi4]==none)mod2[oi2].destroy();
				}
				if (bfixedoverlay)
				{
					tempscale[0]=drawscale+0.005;
					tempscale[1]=drawscale+0.0075;
				}
				else
				{
					tempscale[0]=drawscale;
					tempscale[1]=drawscale;
				}
			}
		}
	}
}
function SetStylePerInt()
{
	if (enviromapstyle==esty_normal)styleint=0;
	else if (enviromapstyle==esty_masked)styleint=1;
	else if (enviromapstyle==esty_modulated)styleint=2;
	else if (enviromapstyle==esty_translucent)styleint=3;

	if (overlayerstyle==ssty_normal)styleint3=0;
	else if (overlayerstyle==ssty_masked)styleint3=1;
	else if (overlayerstyle==ssty_translucent)styleint3=2;
	else styleint3=3;

	if (aurastyle==asty_add)styleint4=0;
	else if (aurastyle==asty_masked)styleint4=1;
	else if (aurastyle==asty_translucent)styleint4=2;
	else styleint4=3;
}
simulated function destroyed()
{
	for(ei=0;ei<4;ei++)
	{
		if (env[ei]!=none)env[ei].destroy();
	}
	for(oi=0;oi<8;oi++)
	{
		if (mod[oi]!=none)mod[oi].destroy();
	}
	for(oi2=0;oi2<2;oi2++)
	{
		if (mod2[oi2]!=none)mod2[oi2].destroy();
	}
	for(ai=0;ai<2;ai++)
	{
		if (vparticle[ai]!=none)vparticle[ai].destroy();
	}
	if(eyeoverlayer!=none)eyeoverlayer.destroy();
}
function SetBloodProjector()
{
	local dynamicprojector d; //put into custom death state or function
	if(class'xtmutator'.default.bprojectors){
	d=spawn(class'dynamicprojector',,,location,rot(16384,0,0)); //should always lie on the ground (16384,0,0)
	d.projectormaterial=bloodmaterial;
	d.maxtracedistance=64;
	d.lifespan=2.0*drawscale;
	d.projmaterialsize=0.8;
	d.sizemodifier=scale_grow;
	d.projgrowtime=2.0*drawscale;
	d.projmaxsize=1.5*drawscale;}
}
function AddHitOverlayer(texture t,float alpha,float life)
{
	if (class'xtmutator'.default.boverlayer)
	{
		hitoverlayer=spawn(class'skinmodifier',self,,location,rotation);
		hitoverlayer.lifespan=life;
		hitoverlayer.setskinmodifier(mesh,fatness,alpha,true,0,0,t,lodbias,drawscale,2,bismultiskinned);
		if (bismultiskinned)hitoverlayer.multioverlayer(t,t,t,t,t,t,t,t);
	}
}
function AddHitVertexAura(texture t,float alpha,float lod,float size,float life,byte fat)
{
	if (class'xtmutator'.default.baura)
	{
		vertexaura=spawn(class'auracontroller',self,,location,rotation);
		vertexaura.lifespan=life;	
		vertexaura.vertexparticle(mesh,size,alpha,t,0,0,lod,fat,2);
	}
}
function AddHitEnviroMap(texture t,float alpha,float life)
{
	if (class'xtmutator'.default.benv)
	{
		hitenviro=spawn(class'environmentmapactor',self,,location,rotation);
		hitenviro.bownedbydeco=true;
		hitenviro.lifespan=life;
		hitenviro.setenviromap(t,drawscale,alpha,mesh,true,0,0,fatness,lodbias,3,true,false);
	}
}

defaultproperties
{
     EnviroMapBrightness=1.000000
     EnviroMapDrawHeight=512.000000
     EnviroMapDrawRadius=512.000000
     EnviroMapStyle=ESty_Translucent
     AuraDrawHeight=256.000000
     AuraDrawRadius=256.000000
     AuraTranslucenties(0)=1.000000
     AuraTranslucenties(1)=1.000000
     AuraSizes(0)=1.000000
     AuraSizes(1)=1.000000
     AuraLOD(0)=0.500000
     AuraLOD(1)=0.500000
     AuraStyle=ASty_Translucent
     ModifierTranslucenties(0)=1.000000
     ModifierTranslucenties(1)=1.000000
     ModifierTranslucenties(2)=1.000000
     ModifierTranslucenties(3)=1.000000
     ModifierTranslucenties(4)=1.000000
     ModifierTranslucenties(5)=1.000000
     ModifierTranslucenties(6)=1.000000
     ModifierTranslucenties(7)=1.000000
     bEnableEyeOverlays=True
     EyeOpeningTime=1.000000
     EyeClosingTime=2.500000
     EyeBrightness=1.000000
     MinEyeOpentime=3.000000
     MaxEyeOpentime=6.000000
     MinEyeClosedtime=0.300000
     MaxEyeclosedtime=0.650000
     DrawType=DT_Mesh
}
