//=============================================================================
// UT99 Extension Pack V1.0
// - Basic Edition -
// class by Shadow
// XTConfigWindow.
//=============================================================================
class XTConfigWindow expands UWindowFramedWindow;

function BeginPlay()
{
	Super.BeginPlay();
	WindowTitle = "Configure UT99 Extension Pack";
	ClientClass = class'XTClientWindow';
	bSizable = false;
}

function Created()
{
	Super.Created();
	MinWinWidth = 250;
	MinWinHeight = 350;
	SetSizePos();
}

function SetSizePos()
{
	local float W,H;
	GetDesiredDimensions(W,H);
	if(W<MinWinWidth) W=MinWinWidth;
	if(H<MinWinHeight) H=MinWinHeight;
	WinLeft = Root.WinWidth/2 - WinWidth/2;
	WinTop = Root.WinHeight/2 - WinHeight/2 - 20;
	WinWidth=W;
	WinHeight=H;
    SetSize(W,H);
}

function ResolutionChanged(float W, float H)
{
	SetSizePos();
	Super.ResolutionChanged(W, H);
}

defaultproperties
{
}
