//=============================================================================
// UT99 Extension Pack V1.0
// - Basic Edition -
// class by Shadow
// Chaining a couple of Sprites with a lensflare Texture will give us a kind of
// light beam effect, as seen in Unreal II or Half-Life 2
//--------
// Updates
//--------
// - 11.5. 07 - 
// + fixed bugs (vector and drawing problems)
// + new feature: allows to control beam by mouse-movement of the player (Dynamic/ScriptedSpriteBeam)
//=============================================================================
class StaticSpriteBeam expands XTEffectActors;

var() texture BeamTextures[16],BeamTexForAll;
var() float BeamBrightness[16],BeamBrightnessCoefficent,BeamSizeCoefficent,BeamForwardCoefficent,BeamSizes[16],SpriteBSPVisbilty,BeamDrawForward[16];
var() int UsedSprites;
var() bool bLevelStatic,bModulated,bIndividualTex,bIndividualSize,bIndividualBrightness,bIndividualForward;
var dummysprite fx[16];
var bool benabled;
var int i;

final function playerpawn getplayer()
{
	return class'XTMainUtil'.static.getlocalplayerfor(self);
}

final function vector BeamVect(int index)
{
	if(!bindividualforward)return class'XTPhysicUtil'.static.beamvect(location,rotation,beamdrawforward[0],true,beamforwardcoefficent,index);
	else return class'XTPhysicUtil'.static.beamvect(location,rotation,beamdrawforward[index],false);
}
simulated function PreBeginPlay()
{
	if(class'XTMutator'.default.bspritebeams)DrawStream();
	if(blevelstatic)destroy();
}
function DrawStream()
{
	if (usedsprites>=1)
	{
		for(i=0;i<UsedSprites;i++)
		{
			if(beamsizes[i]!=0.0)
			{
				fx[i]=spawn(class'dummysprite',,,beamvect(i),rotation);
				fx[i].boff=true;
				fx[i].bdefault=true;
				fx[i].drawtype=dt_sprite;
				if(!bindividualtex)fx[i].texture=beamtexforall;
				else fx[i].texture=beamtextures[i];
				if(!bindividualsize)fx[i].drawscale=beamsizes[0]+beamsizecoefficent*i;
				else fx[i].drawscale=beamsizes[i];
				if(!bindividualbrightness)fx[i].scaleglow=beambrightness[0]-beambrightnesscoefficent*i;
				else fx[i].scaleglow=beambrightness[i];
				fx[i].spriteprojforward=SpriteBSPVisbilty;
				if(!bmodulated)fx[i].style=sty_translucent;
				else fx[i].style=sty_modulated;
			}
		}
	}
	else log("Warning: No Spritecount set for SpriteBeam",name);
}
simulated function tick(float t)
{
	if(class'XTMutator'.default.bspritebeams)
	{
		if (usedsprites>=1)
		{
			for(i=0;i<UsedSprites;i++)if(beamsizes[i]!=0.0)fx[i].drawtype=dt_sprite;
		}
	}
	else
	{
		if (usedsprites>=1)
		{
			for(i=0;i<UsedSprites;i++)if(beamsizes[i]!=0.0)fx[i].drawtype=dt_none;
		}
	}
}

					
				

defaultproperties
{
     BeamTexForAll=Texture'UT99ExtensionPack.Lensflares.Softglow1'
     BeamBrightness(0)=1.000000
     BeamBrightness(1)=1.000000
     BeamBrightness(2)=1.000000
     BeamBrightness(3)=1.000000
     BeamBrightness(4)=1.000000
     BeamBrightness(5)=1.000000
     BeamBrightness(6)=1.000000
     BeamBrightness(7)=1.000000
     BeamBrightness(8)=1.000000
     BeamBrightness(9)=1.000000
     BeamBrightness(10)=1.000000
     BeamBrightness(11)=1.000000
     BeamBrightness(12)=1.000000
     BeamBrightness(13)=1.000000
     BeamBrightness(14)=1.000000
     BeamBrightness(15)=1.000000
     BeamBrightnessCoefficent=0.150000
     BeamSizeCoefficent=0.150000
     BeamForwardCoefficent=16.000000
     BeamSizes(0)=0.500000
     BeamSizes(1)=1.000000
     BeamSizes(2)=1.000000
     BeamSizes(3)=1.000000
     BeamSizes(4)=1.000000
     BeamSizes(5)=1.000000
     BeamSizes(6)=1.000000
     BeamSizes(7)=1.000000
     BeamSizes(8)=1.000000
     BeamSizes(9)=1.000000
     BeamSizes(10)=1.000000
     BeamSizes(11)=1.000000
     BeamSizes(12)=1.000000
     BeamSizes(13)=1.000000
     BeamSizes(14)=1.000000
     BeamSizes(15)=1.000000
     SpriteBSPVisbilty=8.000000
     BeamDrawForward(0)=8.000000
     UsedSprites=7
     bLevelStatic=True
     bStatic=True
     bHidden=True
     bNoDelete=True
     bDirectional=True
     Texture=Texture'UT99ExtensionPack.EdStuff.S_Beam'
     DrawScale=0.250000
     bMovable=False
     bFixedRotationDir=True
}
