//=============================================================================
// UT99 Extension Pack V1.0
// - Basic Edition -
// class by Shadow
// Projector, better then standard decals, this actor is able to trace towards
// an direction and places the decal at the traced surface(s)
//------------
// Features:
// - traced and exact projection
// - free choice of texture
// - free size of decal
// - rotating the projected texture (dynamic projector !, see bAdaptRot)
// - size modifications (shrink,grow,constant,sine,distance), (dynamicprojector, scriptedprojector)
// - decal can blink, flicker, turn on/off etc. (dynamicprojector, scriptedprojector)
// - U/V scaling (dynamic projector !) -> was planned, but never realized
// - trigger support (scriptedprojector !)
// - attach support (dynamicprojector, scriptedprojector)
// - brightness/multiply level of projected texture (more kinda multiply of the texture)
// - maximum distance to trace to 
// - how much surfaces can be projected each tick
// - better decal align on sloped/angled surfaces with an angle under 46 degrees
// - bLevelStatic Control: for once only effects (bullet holes etc.)
// - bAdaptRot(Subclass): Determine weither the projector can control next to direction, the
// rotation around axes simultaneously for the decal (as the projector rotates around
// itself, the decal will rotate around itself)
//-----------
// Updates:
// - 11.5. 2007
// * fixed attach support
//
// - 15.5. 2007
// * fixed some direction bugs
// * added simultaneously controllable projection (for flashlights n' stuff)
// * added a TraceInterruptControl to determine weither a projection can be
// stopped by tracing through an actor or not
//
// - 17.10 2007
// * fixed direction control
//--------------------
// Known Bugs/Issues:
// - even these extended decals fail on multipolygonal surfaces
// - does only project on BSP, due to limitations of decals
// - no preview in editor
// - only one draw mode available (standard modulated RGB(127,127,127) textures)
// - roll component of rotation/rotationrate is ignored!
//=============================================================================
class Projector expands Actor;

var() texture ProjectorMaterial;
var() float ProjMaterialSize,MaxTraceDistance;
var() int BrightnessLevel,MaxProjectableSurfaces;
var() bool bLevelStatic,bActorsInterruptTrace;

//internal:
var projectordecal d[6];

//--------------------------
// Util-Shit :D
//--------------------------
final function playerpawn getplayer()
{
	return class'XTMainUtil'.static.getlocalplayerfor(self);
}
final function TraceProject(out vector at,out rotator r)
{
	class'XTMainUtil'.static.traceproject(self,at,r);
}
final function SetProjectMaterial(int i,bool bcontrol)
{
	class'XTMainUtil'.static.setprojectmaterial(self,i,bcontrol);
}
final function Project()
{
	local vector v;
	local int i;
	local rotator r;
	traceproject(v,r);
	for(i=0;i<brightnesslevel;i++)
	{
		d[i]=spawn(class'projectordecal',self,,v,r);
	}
}
//-------
//init:
//-------
simulated function PreBeginPlay()
{	
	project();
	if (bLevelStatic)destroy();
}
//--------
//Control:
//--------
simulated function Tick(float t)
{	
	local int i;
	for(i=0;i<brightnesslevel;i++)
	{
		if (d[i]!=none)
			SetProjectMaterial(i,class'XTMutator'.default.bprojectors);
	}
	if (class'XTMutator'.default.bprojectors)
	{
		if (bLevelStatic)destroy();
	}
}

defaultproperties
{
     ProjMaterialSize=1.000000
     MaxTraceDistance=1024.000000
     BrightnessLevel=1
     MaxProjectableSurfaces=8
     bHidden=True
     bDirectional=True
     Texture=Texture'UT99ExtensionPack.EdStuff.S_Projector'
     DrawScale=0.250000
     bGameRelevant=True
     bMovable=False
}
