//===============================================================================
// UT99 Extension Pack V1.0
// - Basic Edition -
// class by Shadow
// Last Update/Fix: 14.10. 2007
//-------------------------------------------------------------------------------
// ParticlEmitter, the base class of all particle emitting actors
// - around 20 different draw types
// - many physic settings (bsp behaviour, velocity, movement and so on)
// - highly optimized performance settings: LineOfSight Checking, Visibility Checking, FOV Checking and Support for
// Detail Setting (also via additional functions in the menu/mutator)
// - a lot of standard settings as known from other particles systems: particlesize, brightness, speed, radius, texture,
// random textures, size/brightness variability
// - huge palette of size modifiers
// - huge palette of brightness modifiers (for fade effects)
// - attach support
// - sprite and mesh support
// - embedded in the LostSecretsUtil and BehemothPE System
// - has been completely clean rewritten by this version (debugged and restructered in writing style)
// - special features like: glowing, special settings for each drawtype, sprite clipping, modifier behaviour (if event, or
// timed, or instantly etc.)
// - emitter hierarchy has been improved: instead of a huge list of predefined styles in one main class the particle
// emitter is now just the main class and all other subclasses are specialised only with variables they really need, sub-emitter
// are also categorized... emitters for maps (flames, waterfalls) go into the "environmentemitter" group for example
//------------------------------------------------
// Updates
// - 10.5. 2007 - added a new DrawType
// - 11.5. 2007 - fixed a bug in FadeOut Section
// - 14.10. 2007 - fixed math sizers (sin, cos etc.), added vector velocity again
//==========================================================================================================================
class ParticleEmitter expands Actor;

struct rad{var() int nradius,x,y,z;};

var(General) texture ParticleSprite;
var(General) float ParticleScaleglow,RepeatDelay,ParticleLifespan,ParticleSizeVariance,ParticleScaleglowVariance,LifespanVariance,ParticleSize;
var(General) texture MeshPclSkin;
var(General) mesh MeshPclUsedMesh;
var(General) byte MeshPclFatness;
var(General) int MaxParticles,NumSetRandTexes;
var(General) bool bUnlitMeshPcl,bPclRandomTextures,bRandomizeLifespan;
var(General) texture PclRandomTextures[32];
var(General) rad Radius;
var(General) name MeshPclAnim;

var(Performance) float TurnOffRadius,ParticleVisibilityHeight, ParticleVisibilityRadius,DetailTemplate[7];
var(Performance) bool bSetDetailByMenu,bLOSCheck,bFOVCheck,bDistanceCulling,bVisibilityCulling;
var(Performance) int AllowedFOV;

var(Physics) float ParticleMomentumTransfer,BounceHeight,MaximumSpeed,ParticleSpeed,ParticleSpinRate;
var(Physics) int ModifierAngle,DirectionIntensity,MaximumWallReflects,ParticleSpinFactor;
var(Physics) float Particlewaterbuoyancy;
var(Physics) bool bVelocityIsVector;
var(Physics) vector ParticleVelocity;
var(Physics) bool bRandomMovementAcceleration;

var(Debug) float SpriteBrushCuttingIntensity;

var(Modifier) float ParticleSizingGrowTime,ParticleSizingShrinkTime,ParticleFadeInTime, ParticleFadeOutTime,ParticleMinSize,ParticleMaxSize,ParticleMinFade,ParticleMaxFade,ParticleSizingAmplitude,ParticleSizingFrequency,ParticleSizingSmoothness,ParticleFadeAmplitude,ParticleFadeFrequency,ParticleFadeSmoothness,SizeSmerpCombiner,SizeSmerpCombiner2,SizeLerpCombiner,SizeLerpCombiner2,FadeSmerpCombiner,FadeSmerpCombiner2,FadeLerpCombiner,FadeLerpCombiner2,FadeFClampCombiner,FadeFClampCombiner2,FClampCombiner,FClampCombiner2,XtraSizeTimer,XtraFadeTimer;
var(Modifier) name XtraSizeModeClassname,XtraFadeModeClassname;

var(DrawTypeSpecials) vector CubicVolumeDimensions;
var(DrawTypeSpecials) int SphereAngleDegrees,planeangledegrees;
var(DrawTypeSpecials) float LinearDrawForward,SteamBurstIntensity,SplinterThrowRange;
var(DrawTypeSpecials) int ConvergeErrorTolerance;

var(Render) enum EParticleDrawType
{
	PDT_Linear,
	PDT_Volumetric,
	PDT_AllDirections,
	PDT_AllDirections2,
	PDT_Spray,
	PDT_SprayRadius,
	PDT_ConvergingSphere,
	PDT_ConvergingCone,
	PDT_Fireworks,
	PDT_Steam,
	PDT_Splinter,
	PDT_Fontain,
	PDT_Random
} ParticleDrawType;

var(Render) enum EParticleDrawStyle
{
	DS_Sprite,
	DS_Mesh
}ParticleDrawStyle;

var(Physics) enum EParticlePhysics
{
	PP_Projectile,
	PP_Flying,
	PP_Falling,
	PP_Swimming
}ParticlePhysics;

var(Modifier) enum ESizeType
{
	ST_Default,
	ST_Grow,
	ST_Shrink,
	ST_Random,
	ST_Pulsing_ByGrow,
	ST_Pulsing_ByShrink,
	ST_CosineWavy,
	ST_SinusWavy,
	ST_TangensWavy,
	ST_AtangensWavy,
	ST_LogeWavy,
	ST_ExpolateWavy,
	ST_SquareWavy,
	ST_AbsWavy,
	ST_SmerpWavy,
	ST_LerpWavy,
	ST_FClampWavy
}SizeType;

var(Modifier) enum EFadeEffect
{
	FE_Default,
	FE_FadeIn,
	FE_FadeOut,
	FE_Random,
	FE_Pulsing_ByFadeIn,
	FE_Pulsing_ByFadeOut,
	FE_SinusWavy,
	FE_CosineWavy,
	FE_TangensWavy,
	FE_ATangensWavy,
	FE_LogeWavy,
	FE_ExpolateWavy,
	FE_SquareWavy,
	FE_SqrtWavy,
	FE_AbsWavy,
	FE_SmerpWavy,
	FE_LerpWavy,
	FE_FClampWavy
} FadeEffect;

var(Modifier) enum EXtraSizeMode
{
	XSize_OnlyPerStandardModifier,
	XSize_PerModifierWhenHittingBSP,
	XSize_PerModifierWhenChangingZone,
	XSize_PerModifierWhenHittingActor,
	XSize_PerModifierWhenHittingPawn,
	XSize_PerModifierWhenHittinSpecifiedClass,
	XSize_PerModifierTimed
}XtraSizeMode;

var(Modifier) enum EXtraFadeMode
{
	XFSize_OnlyPerStandardModifier,
	XFSize_PerModifierWhenHittingBSP,
	XFSize_PerModifierWhenChangingZone,
	XFSize_PerModifierWhenHittingActor,
	XFSize_PerModifierWhenHittingPawn,
	XFSize_PerModifierWhenHittinSpecifiedClass,
	XFSize_PerModifierTimed
}XtraFadeMode;

var(Physics) enum EBspHitMode
{
	BspMode_Destroy,
	BspMode_Bounce,
	BspMode_Reflect,
	BspMode_AdvReflect,
	BspMode_Slide,
	BspMode_Glue
}BspHitMode;

var(Render) enum ETextureStyle
{
	TS_Default,
	TS_Translucent,
	TS_Masked,
	TS_Modulated
} TextureStyle;

//internal variables :
var int i;
var particles p;
var vector seekingdir,followoffset;
var float magnitudevel;
var float rand1,rand2,forwardskalar;
var vector genloc;
var actor followactor;
var playerpawn derandy;

simulated function PreBeginPlay()
{
	settimer(repeatdelay,true);
}
//------------------------
// Util stuff:
//------------------------
function int RandLoc(int max)
{
	return class'XTMainUtil'.static.getrandint(max);
}
function vector Vect2(float x,float y,float z)
{
	return class'XTMainUtil'.static.vect2(x,y,z);
}
function AttachTo()
{
	class'XTPhysicUtil'.static.Attach(self,followactor.location,followactor.rotation,followoffset,forwardskalar);
}
function playerpawn GetPlayer()
{
	return class'XTMainUtil'.static.getlocalplayerfor(self);
}
function bool IsEmitterInRadius()
{
	return class'XTPhysicUtil'.static.IsActorInRadius(derandy.location,location,false,turnoffradius);
}
function bool PlayerCanSeeEmitter()
{
	return class'XTMainUtil'.static.ACanSeeB(derandy,self,allowedfov-35);
}
function bool PlayerCanSeeParticles()
{
	return class'XTMainUtil'.static.ACanSeeB(derandy,p,allowedfov-30);
}
function StaticSetupForOwning(int max,float l,bool bdesired,particleemitter slave)
{
	slave.particledrawtype=particledrawtype;
	slave.particledrawstyle=particledrawstyle;
	maxparticles=max;
	lifespan=l;
	settimer(repeatdelay,bdesired);
}
function SetupDetail(int max,float delay,bool bdesired)
{
	maxparticles=max;
	settimer(delay,bdesired);
}
simulated function Tick(float deltatime)
{
	local int tehfov;
	derandy=getplayer();
	if (followactor!=none)attachto();
	if(bLOSCheck&&class'xtmutator'.default.bemitterlos&&!bFOVCheck)  //fov check includes LOS
	{
		if(!derandy.lineofsightto(self))disable('timer');
		else enable('timer');
	}
	if(bdistanceculling&&class'xtmutator'.default.bemitterdist)
	{
		if(IsEmitterInRadius())enable('timer');
		else disable('timer');
	}
	if(bFOVcheck&&class'xtmutator'.default.bemitterfov)
	{
		if(PlayerCanSeeEmitter())enable('timer');
		else disable('timer');
	}
}
simulated function SizeScaler()
{
	if(sizetype==st_default)
	{
		setxtrasizemode();
		p.bgrow=false;
		p.bdefault1=true;
		p.brandsize=false;
		p.bpulsingsize=false;
		p.default.drawscale = particlesize;
	}
	else if(sizetype==st_grow)
	{
		setxtrasizemode();
		p.default.drawscale=particlesize;
		p.bgrow=true;
		p.minsizestrength=particleminsize;
		p.maxsizestrength=particlemaxsize;
		p.brandsize=false;
		p.bpulsingsize=false;
		p.growtime=particlesizinggrowtime;
		p.bdefault1=false;
	}
	else if (sizetype ==st_shrink)
	{
		setxtrasizemode();
		p.default.drawscale=particlesize;
		p.bgrow=false;
		p.minsizestrength=particleminsize;
		p.maxsizestrength=particlemaxsize;
		p.bdefault1=false;
		p.brandsize=false;
		p.bpulsingsize=false;
		p.shrinktime=particlesizingshrinktime;
	}
	else if (sizetype==st_random)
	{
		setxtrasizemode();
		p.bgrow=false;
		p.bdefault1=false;
		p.brandsize=true;
		p.bpulsingsize=false;
		p.randomsize(true,particlesize,particlesizevariance);
	}
	else if (sizetype==st_pulsing_bygrow)
	{
		setxtrasizemode();
		p.bgrow=true;
		p.bdefault1=false;
		p.brandsize=false;
		p.bpulsingsize=true;
		p.growtime=particlesizinggrowtime;
		p.shrinktime=particlesizingshrinktime;
		p.minsizestrength=particleminsize;
		p.maxsizestrength=particlemaxsize;
	}
	else if (sizetype==st_pulsing_byshrink)
	{
		setxtrasizemode();
		p.bgrow=false;
		p.bdefault1=false;
		p.brandsize=false;
		p.bpulsingsize=true;
		p.growtime=particlesizinggrowtime;
		p.shrinktime=particlesizingshrinktime;
		p.minsizestrength=particleminsize;
		p.maxsizestrength=particlemaxsize;
	}
	else if (sizetype==st_sinuswavy)
	{
		setxtrasizemode();
		p.bdefault1=true;
		p.brandsize=false;
		p.bpulsingsize=false;
		p.wavyampli=particlesizingamplitude;
		p.wavyfreq=particlesizingfrequency;
		p.wavysmooth=particlesizingsmoothness;
		p.wavysizer=ws_sinus;
		p.gotostate('nusizer');
	}
	else if (sizetype==st_cosinewavy)
	{
		setxtrasizemode();
		p.bdefault1=true;
		p.brandsize=false;
		p.bpulsingsize=false;
		p.wavyampli=particlesizingamplitude;
		p.wavyfreq=particlesizingfrequency;
		p.wavysmooth=particlesizingsmoothness;
		p.wavysizer=ws_cosine;
		p.gotostate('nusizer');
	}
	else if (sizetype==st_tangenswavy)
	{
		setxtrasizemode();
		p.bdefault1=true;
		p.brandsize=false;
		p.bpulsingsize=false;
		p.wavyampli=particlesizingamplitude;
		p.wavyfreq=particlesizingfrequency;
		p.wavysmooth=particlesizingsmoothness;
		p.wavysizer=ws_tangens;
		p.gotostate('nusizer');
	}
	else if (sizetype==st_atangenswavy)
	{
		setxtrasizemode();
		p.bdefault1=true;
		p.brandsize=false;
		p.bpulsingsize=false;
		p.wavyampli=particlesizingamplitude;
		p.wavyfreq=particlesizingfrequency;
		p.wavysmooth=particlesizingsmoothness;
		p.wavysizer=ws_atangens;
		p.gotostate('nusizer');
	}
	else if (sizetype==st_logewavy)
	{
		setxtrasizemode();
		p.bdefault1=true;
		p.brandsize=false;
		p.bpulsingsize=false;
		p.wavyampli=particlesizingamplitude;
		p.wavyfreq=particlesizingfrequency;
		p.wavysmooth=particlesizingsmoothness;
		p.wavysizer=ws_loge;
		p.gotostate('nusizer');
	}
	else if (sizetype==st_abswavy)
	{
		setxtrasizemode();
		p.bdefault1=true;
		p.brandsize=false;
		p.bpulsingsize=false;
		p.wavyampli=particlesizingamplitude;
		p.wavyfreq=particlesizingfrequency;
		p.wavysmooth=particlesizingsmoothness;
		p.wavysizer=ws_abs;
		p.gotostate('nusizer');
	}
	else if (sizetype==st_expolatewavy)
	{
		setxtrasizemode();
		p.bdefault1=true;
		p.brandsize=false;
		p.bpulsingsize=false;
		p.wavyampli=particlesizingamplitude;
		p.wavyfreq=particlesizingfrequency;
		p.wavysmooth=particlesizingsmoothness;
		p.wavysizer=ws_exp;
		p.gotostate('nusizer');
	}
	else if (sizetype==st_squarewavy)
	{
		setxtrasizemode();
		p.bdefault1=true;
		p.brandsize=false;
		p.bpulsingsize=false;
		p.wavyampli=particlesizingamplitude;
		p.wavyfreq=particlesizingfrequency;
		p.wavysmooth=particlesizingsmoothness;
		p.wavysizer=ws_square;
		p.gotostate('nusizer');
	}
	else if (sizetype==st_smerpwavy)
	{
		setxtrasizemode();
		p.bdefault1=true;
		p.brandsize=false;
		p.bpulsingsize=false;
		p.smerpwvmulti=sizesmerpcombiner;
		p.smerpwvmulti2=sizesmerpcombiner2;
		p.wavyampli=particlesizingamplitude;
		p.wavyfreq=particlesizingfrequency;
		p.wavysmooth=particlesizingsmoothness;
		p.wavysizer=ws_smerp;
		p.gotostate('nusizer');
	}
	else if (sizetype==st_lerpwavy)
	{
		setxtrasizemode();
		p.bdefault1=true;
		p.brandsize=false;
		p.bpulsingsize=false;
		p.lerpwvmulti=sizelerpcombiner;
		p.lerpwvmulti2=sizelerpcombiner2;
		p.wavyampli=particlesizingamplitude;
		p.wavyfreq=particlesizingfrequency;
		p.wavysmooth=particlesizingsmoothness;
		p.wavysizer=ws_lerp;
		p.gotostate('nusizer');
	}
	else if (sizetype==st_fclampwavy)
	{
		setxtrasizemode();
		p.bdefault1=true;
		p.brandsize=false;
		p.bpulsingsize=false;
		p.wavyampli=particlesizingamplitude;
		p.wavyfreq=particlesizingfrequency;
		p.wavysmooth=particlesizingsmoothness;
		p.sfcmulti=fclampcombiner;
		p.sfcmulti2=fclampcombiner2;
		p.wavysizer=ws_fclamp;
		p.gotostate('nusizer');
	}
}
simulated function FadeScaler()
{
	if (fadeeffect == fe_default)
	{
		p.bfadein=false;
		p.bdefault2=true;
		p.brandfade=false;
		p.default.scaleglow=particlescaleglow;
	}
	else if(fadeeffect == fe_fadein)
	{
		SetXtraFadeMode();
		p.maxfadestrength=particlemaxfade;
		p.minfadestrength=particleminfade;
		p.fadeintime=particlefadeintime;
		p.bfadein=true;
		p.bdefault2 = false;
		p.brandfade=false;
	}
	else if (fadeeffect == fe_fadeout)
	{
		SetXtraFadeMode();
		p.fadeouttime=particlefadeouttime;
		p.maxfadestrength=particlemaxfade;
		p.minfadestrength=particleminfade;
		p.bfadein=false;
		p.bdefault2 = false;
		p.brandfade=false;
	}
	else if (fadeeffect == fe_random)
	{
		SetXtraFadeMode();
		p.bfadein=false;
		p.bdefault2=false;
		p.brandfade=true;
		p.randomfadeeffects(true,particlescaleglow,particlescaleglowvariance);
	}
	else if (fadeeffect == FE_Pulsing_ByFadeIn)
	{
		SetXtraFadeMode();
		p.bfadein=true;
		p.bdefault2=false;
		p.brandfade=false;
		p.bpulsingfader=true;
		p.fadeintime=particlefadeintime;
		p.fadeouttime = particlefadeouttime;
		p.maxfadestrength=particlemaxfade;
		p.minfadestrength=particleminfade;
	}
	else if (fadeeffect==fe_pulsing_byfadeout)
	{
		SetXtraFadeMode();
		p.bfadein=false;
		p.bdefault2=false;
		p.brandfade=false;
		p.bpulsingfader=true;
		p.fadeintime = particlefadeintime;
		p.fadeouttime = particlefadeouttime;
		p.maxfadestrength = particlemaxfade;
		p.minfadestrength = particleminfade;
	}
	else if (fadeeffect==fe_sinuswavy)
	{
		SetXtraFadeMode();
		p.bfadein=false;
		p.bdefault2=true;
		p.bpulsingfader=false;
		p.brandfade=false;
		p.fwavyampli=ParticleFadeAmplitude;
		p.fwavyfreq=ParticleFadeFrequency;
		p.fwavysmooth=ParticleFadeSmoothness;
		p.fwavysizer=fws_sinus;
		p.gotostate('nufsizer');
	}
	else if (fadeeffect==fe_tangenswavy)
	{
		SetXtraFadeMode();
		p.bdefault2=true;
		p.bpulsingfader=false;
		p.brandfade=false;
		p.fwavyampli=ParticleFadeAmplitude;
		p.fwavyfreq=ParticleFadeFrequency;
		p.fwavysmooth=ParticleFadeSmoothness;
		p.fwavysizer=fws_tangens;
		p.gotostate('nufsizer');
	}
	else if (fadeeffect==fe_cosinewavy)
	{
		SetXtraFadeMode();
		p.bdefault2=true;
		p.bpulsingfader=false;
		p.brandfade=false;
		p.fwavyampli=ParticleFadeAmplitude;
		p.fwavyfreq=ParticleFadeFrequency;
		p.fwavysmooth=ParticleFadeSmoothness;
		p.fwavysizer=fws_cosine;
		p.gotostate('nufsizer');
	}
	else if (fadeeffect==fe_atangenswavy)
	{
		SetXtraFadeMode();
		p.bdefault2=true;
		p.bpulsingfader=false;
		p.brandfade=false;
		p.fwavyampli=ParticleFadeAmplitude;
		p.fwavyfreq=ParticleFadeFrequency;
		p.fwavysmooth=ParticleFadeSmoothness;
		p.fwavysizer=fws_atangens;
		p.gotostate('nufsizer');
	}
	else if (fadeeffect==fe_abswavy)
	{
		SetXtraFadeMode();
		p.bdefault2=true;
		p.bpulsingfader=false;
		p.brandfade=false;
		p.fwavyampli=ParticleFadeAmplitude;
		p.fwavyfreq=ParticleFadeFrequency;
		p.fwavysmooth=ParticleFadeSmoothness;
		p.fwavysizer=fws_abs;
		p.gotostate('nufsizer');
	}
	else if (fadeeffect==fe_squarewavy)
	{
		SetXtraFadeMode();
		p.bdefault2=true;
		p.bpulsingfader=false;
		p.brandfade=false;
		p.fwavyampli=ParticleFadeAmplitude;
		p.fwavyfreq=ParticleFadeFrequency;
		p.fwavysmooth=ParticleFadeSmoothness;
		p.fwavysizer=fws_square;
		p.gotostate('nufsizer');
	}
	else if (fadeeffect==fe_expolatewavy)
	{
		SetXtraFadeMode();
		p.bdefault2=true;
		p.bpulsingfader=false;
		p.brandfade=false;
		p.fwavyampli=ParticleFadeAmplitude;
		p.fwavyfreq=ParticleFadeFrequency;
		p.fwavysmooth=ParticleFadeSmoothness;
		p.fwavysizer=fws_exp;
		p.gotostate('nufsizer');
	}
	else if (fadeeffect==fe_sqrtwavy)
	{
		SetXtraFadeMode();
		p.bdefault2=true;
		p.bpulsingfader=false;
		p.brandfade=false;
		p.fwavyampli=ParticleFadeAmplitude;
		p.fwavyfreq=ParticleFadeFrequency;
		p.fwavysmooth=ParticleFadeSmoothness;
		p.fwavysizer=fws_loge;
		p.gotostate('nufsizer');
	}
	else if (fadeeffect==fe_logewavy)
	{
		SetXtraFadeMode();
		p.bdefault2=true;
		p.bpulsingfader=false;
		p.brandfade=false;
		p.fwavyampli=ParticleFadeAmplitude;
		p.fwavyfreq=ParticleFadeFrequency;
		p.fwavysmooth=ParticleFadeSmoothness;
		p.fwavysizer=fws_atangens;
		p.gotostate('nufsizer');
	}
	else if (fadeeffect==fe_smerpwavy)
	{
		setxtrafademode();
		p.bdefault2=true;
		p.bpulsingfader=false;
		p.brandfade=false;
		p.fsmerpwvmulti=fadesmerpcombiner;
		p.fsmerpwvmulti2=fadesmerpcombiner2;
		p.fwavyampli=particlefadeamplitude;
		p.wavyfreq=particlefadefrequency;
		p.fwavysmooth=particlefadesmoothness;
		p.fwavysizer=fws_smerp;
		p.gotostate('fnusizer');
	}
	else if (fadeeffect==fe_lerpwavy)
	{
		setxtrafademode();
		p.bdefault2=true;
		p.bpulsingfader=false;
		p.brandfade=false;
		p.flerpwvmulti=fadelerpcombiner;
		p.flerpwvmulti2=fadelerpcombiner2;
		p.fwavyampli=particlefadeamplitude;
		p.wavyfreq=particlefadefrequency;
		p.fwavysmooth=particlefadesmoothness;
		p.fwavysizer=fws_lerp;
		p.gotostate('fnusizer');
	}
	else if (fadeeffect==fe_fclampwavy)
	{
		setxtrafademode();
		p.bdefault2=true;
		p.bpulsingfader=false;
		p.brandfade=false;
		p.fwavyampli=particlefadeamplitude;
		p.wavyfreq=particlefadefrequency;
		p.fwavysmooth=particlefadesmoothness;
		p.ffcmulti=fadefclampcombiner;
		p.ffcmulti2=fadefclampcombiner2;
		p.fwavysizer=fws_fclamp;
		p.gotostate('fnusizer');
	}
}
simulated function SetDetailLevel(int dlevel)
{
	local int level;
	for(level=0;level<dlevel;level++)setupdetail(1,detailtemplate[level],true);
}
function SetXtraSizeMode()
{
	if (XtraSizeMode==XSize_PerModifierWhenHittingBSP)p.xsizer=xs_bsp;
	else if (xtrasizemode==XSize_PerModifierWhenchangingzone)p.xsizer=xs_zone;
	else if (xtrasizemode==XSize_PerModifierWhenHittingActor)p.xsizer=xs_actor;
	else if (xtrasizemode==XSize_PerModifierWhenHittingpawn)p.xsizer=xs_pawn;
	else if (xtrasizemode==xsize_permodifiertimed)
	{
		p.xsizer=xs_timed;
		p.bprexsizer=true;
		p.sizedelay=xtrasizetimer;
		p.settimer(xtrasizetimer,true);
	}
	else if (xtrasizemode==XSize_PerModifierWhenHittinSpecifiedClass)
	{
		p.xsizer=xs_name;
		p.thingyname=XtraSizeModeClassName;
	}
	else p.xsizer=xs_normal;
}
function SetXtraFadeMode()
{
	if (XtraFadeMode==XfSize_PerModifierWhenHittingBSP)p.xfsizer=xfs_bsp;
	else if (xtraFademode==XfSize_PerModifierWhenchangingzone)p.xfsizer=xfs_zone;
	else if (xtraFademode==XfSize_PerModifierWhenHittingActor)p.xfsizer=xfs_actor;
	else if (xtraFademode==XfSize_PerModifierWhenHittingpawn)p.xfsizer=xfs_pawn;
	else if (xtraFademode==xfsize_permodifiertimed)
	{
		p.xfsizer=xfs_timed;p.bprexfsizer=true;
		p.fadedelay=xtrafadetimer;
		p.settimer(xtrafadetimer,true);
	}
	else if (xtraFademode==XfSize_PerModifierWhenHittinSpecifiedClass)
	{
		p.xfsizer=xfs_name;
		p.thingyname2=XtraFadeModeClassName;
	}
	else p.xfsizer=xfs_normal;
}
function getparticleoptions()
{
	local int si,si2,si3,si4;
	p.drawscale=particlesize;
	p.speed=particlespeed;
	p.momentumtransfer=particlemomentumtransfer;
	p.texture=particlesprite;
	p.scaleglow=particlescaleglow;
	if (texturestyle==ts_default)p.style=sty_normal;
	else if (texturestyle==ts_masked)p.style=sty_masked;
	else if (texturestyle==ts_translucent)p.style=sty_translucent;
	else p.style=sty_modulated;
	if(particledrawstyle==ds_sprite)p.drawtype=dt_sprite;
	else
	{
		p.lodbias=lodbias;
		p.animsequence=meshpclanim;
		p.mesh=meshpclusedmesh;
		p.skin=meshpclskin;
		p.fatness=meshpclfatness;
		p.bunlit=bUnlitMeshPcl;
		p.multiskins[0]=meshpclskin;
		p.multiskins[1]=meshpclskin;
		p.multiskins[2]=meshpclskin;
		p.multiskins[3]=meshpclskin;
		p.multiskins[4]=meshpclskin;
		p.multiskins[5]=meshpclskin;
		p.multiskins[6]=meshpclskin;
		p.multiskins[7]=meshpclskin;
	}
	p.remoterole=role_none;
	p.maxspeed=maximumspeed;
	p.lifespan = particleLifeSpan;
	p.spriteprojforward=SpriteBrushCuttingIntensity;
    	if (bsphitmode==bspmode_destroy)p.bsimpledestr=true;
	else if (bsphitmode==bspmode_reflect)
	{
		p.maxwallreflects=maximumwallreflects;
		p.bReflect=true;
	}
    else if (bsphitmode==bspmode_bounce)
	{
		p.bounceheight=bounceheight;
		if (bounceheight<=1.0)bounceheight=1.0;
		p.bBouncefw=true;
	}
	else if (bsphitmode==bspmode_advreflect)
	{
		p.badvreflect=true;
		p.maxwallreflects=maximumwallreflects;
	}
	else if (bsphitmode==bspmode_glue)p.bglueonbsp=true;
	else p.bslide=true;
	if (particlephysics==pp_falling)p.setphysics(phys_falling);
	else if (particlephysics==pp_projectile)p.setphysics(phys_projectile);
	else if (particlephysics==pp_swimming)
	{
		p.setphysics(phys_swimming);
		p.buoyancy=particlewaterbuoyancy;
	}
	else p.setphysics(phys_flying);
	if(bVelocityIsVector)p.velocity=particlevelocity;
	if (bPclRandomTextures)p.Texture=PclRandomTextures[rand(numsetrandtexes)];
	else p.texture=particlesprite;
	if (bRandomizeLifespan)p.lifespan=class'XTMainUtil'.static.randfloat(particlelifespan,lifespanvariance);
	else p.lifespan = particlelifespan;
	if (brandommovementacceleration)p.rma(-particlevelocity.z,particlespinrate,particlespinfactor,modifierangle);
	if (bVisibilityCulling)
	{
		p.visibilityradius=particlevisibilityradius;
		p.visibilityheight=particlevisibilityheight;
	}
	/*if (brandomizedirection)
	{
		p.randdiracc=randomdiracceleration;
		p.vectoruprate=vectorupdatedelay;
		p.vectormodangle=vectorupdateangle;
		p.seeking=none;
		p.settimer(updatedirtime,true);
		p.branddir=true;
	}*/
	SizeScaler();
	FadeScaler();
}
function Timer()
{
	local vector origvel,tempvector,x,y,z;
	local rotator temprot,dir,rot;
	local int curspd,tint;

	if(bsetdetailbymenu)SetDetailLevel(class'xtmutator'.default.particledetail);

	if (class'xtmutator'.default.particledetail!=0){
	if (particledrawtype==pdt_linear)
	{
		for (i=0;i<maxparticles;i++)
		{
			p=spawn(class'particles',, '',location+vector(rotation)*lineardrawforward,rotation);
			getparticleoptions();
		}
	}
	else if (particledrawtype==pdt_volumetric)
	{
		if ((level.netmode!=nm_dedicatedserver)&&(maxparticles>0))
		{
			for (i=0;i<maxparticles;i++)
			{
				genloc.x=location.x+randloc(radius.x);
				genloc.y=location.y+randloc(radius.y);
				genloc.z=location.z+randloc(radius.z);
				p=spawn(class'particles',,,genloc);
				getparticleoptions();
			}
		}
	}
	else if (particledrawtype==pdt_alldirections)
	{
		for (i=0;i<maxparticles;i++)
		{
			p=spawn(class'particles',,,location,rotrand(false));
			getparticleoptions();
		}
	}
	else if (particledrawtype==pdt_alldirections2)
	{
		for (i=0;i<maxparticles;i++)
		{
			genloc.x=location.x+randloc(radius.x);
			genloc.y=Location.y+randloc(radius.y);
			genloc.z=location.z;
			p=spawn(class'particles',,,genloc,rotrand(false));
			getparticleoptions();
		}
	}
	else if (particledrawtype==pdt_spray)
	{
		for (i=0;i<maxparticles;i++)
		{
			p.velocity=vect2(randloc(particlespeed),randloc(particlespeed),rand(-particlevelocity.z +frand()*1.337));
			p=spawn(class'particles',,, location,rotation);
			getparticleoptions();
		}
	}
	else if (particledrawtype==pdt_convergingsphere)
	{
		for (i=0;i<maxparticles;i++)
		{
			rand1=randloc(sphereangledegrees);
			rand2=randloc(sphereangledegrees);
			genloc.x=location.x+radius.x*sin(rand2)*cos(rand1);
			genloc.y=location.y+radius.y*sin(rand2)*sin(rand1);
			genloc.z=location.z+radius.z*cos(rand2);
			p.bisinconvergingmode=true;
			seekingdir=normal(location-p.location);
			p.velocity=seekingdir*particlespeed;
			p.aimpoint=self;
			p.conerror=(radius.nradius/convergeerrortolerance);
			p=spawn(class'particles',,, genloc,rotation);
			getparticleoptions();
		}
	}
	else if (particledrawtype==pdt_convergingcone)
	{
		for (i=0;i<maxparticles;i++)
		{
			p.bisinconvergingmode=true;
			seekingdir=normal(location-p.location);
			p.velocity=seekingdir*particlespeed;
			p.conerror=(radius.nradius/convergeerrortolerance);
			p.aimpoint=self;
			p.distance=radius.nradius;
			rand1=randloc(planeangledegrees);
			genloc.x=location.x+radius.x*cos(rand1);
			genloc.y=location.y+radius.y*sin(rand1);
			genloc.z=location.z+radius.z;
			p=spawn(class'particles',,,genloc);
			getparticleoptions();
		}
	}
	else if (particledrawtype==pdt_fireworks)
	{
		for (i=0;i<maxparticles;i++)
		{
			genloc.x=location.x+radius.x*cos(radius.x);
			genloc.y=location.y+radius.y*sin(radius.y);
			genloc.z=location.z+radius.z;
			p.SetFireworksVelocity(360,rotation,particlespeed);
			p=spawn(class'particles',,'', genloc,rotation);
			getparticleoptions();
		}
	}
	else if (particledrawtype==pdt_random)
	{
		for (i=0;i<maxparticles;i++)
		{
			tint++;
			genloc.x=(frand()-0.5)*radius.x*tint*4;
			genloc.y=(frand()-0.5)*radius.y*tint*4;
			genloc.z=(frand()-0.5)*radius.z*tint*4;
			p=spawn(class'particles',,'', location+genloc,rotation);
			getparticleoptions();
		}
	}
	else if (particledrawtype==pdt_Steam)
	{
		for (i=0;i<maxparticles;i++)
		{
			tempvector=0.15*steamburstintensity*vrand();
			tempvector=vect2(abs(TempVector.Z),abs(TempVector.x),abs(TempVector.y));
			p.velocity=tempvector*particlespeed;
			p=spawn(class'particles',,, location,rotation);
			getparticleoptions();
			p.velocity=tempvector*particlespeed;
		}
	}
	else if(particledrawtype==pdt_sprayradius)
	{
		for(i=0;i<maxparticles;i++)
		{
			p.Velocity.x==randloc(particlespeed)+FRand();
			p.velocity.y=randloc(particlespeed)+FRand();
			p.velocity.z=randloc(particlevelocity.z+frand()*1.337)+FRand();
			genloc.x=location.x+randloc(radius.x);
			genloc.y=location.y+randloc(radius.y);
			genloc.z=location.z+randloc(radius.z);
		    p=spawn(class'particles',,, genloc,rotation);
			getparticleoptions();
		}
	}
	else if (particledrawtype==pdt_splinter)
	{
		for (i=0;i<maxparticles;i++)
		{
			p.velocity=vrand()*(splinterthrowrange+frand()*150.0+100.0+vsize(tempvector)/80);
			p=spawn(class'particles',,,location,rotation);
			getparticleoptions();
		}
	}
	else if (particledrawtype==pdt_fontain)
	{
		for(i=0;i<maxparticles;i++)
		{
			genloc=location+4*vrand();
			p=spawn(class'particles',,,genloc,rotator(genloc-location));
			getparticleoptions();
		}
	}}
}

defaultproperties
{
     ParticleScaleglow=1.000000
     RepeatDelay=0.125000
     ParticleLifespan=4.000000
     ParticleSizeVariance=1.000000
     ParticleScaleglowVariance=1.000000
     LifespanVariance=1.000000
     ParticleSize=0.500000
     MaxParticles=1
     bUnlitMeshPcl=True
     Radius=(nradius=32,X=16,Y=16,Z=16)
     TurnOffRadius=768.000000
     ParticleVisibilityHeight=512.000000
     ParticleVisibilityRadius=512.000000
     DetailTemplate(0)=0.100000
     DetailTemplate(1)=0.080000
     DetailTemplate(2)=0.025000
     DetailTemplate(3)=0.003500
     DetailTemplate(4)=0.000700
     DetailTemplate(5)=0.000040
     DetailTemplate(6)=0.000001
     bSetDetailByMenu=True
     AllowedFOV=60
     ParticleMomentumTransfer=8000.000000
     MaximumSpeed=64.000000
     ParticleSpeed=32.000000
     ParticleSpinRate=16.000000
     ParticleSpinFactor=32
     SpriteBrushCuttingIntensity=12.000000
     ParticleSizingGrowTime=1.000000
     ParticleSizingShrinkTime=1.000000
     ParticleFadeInTime=1.000000
     ParticleFadeOutTime=1.000000
     ParticleSizingAmplitude=1.000000
     ParticleSizingFrequency=0.500000
     ParticleSizingSmoothness=0.050000
     ParticleFadeAmplitude=1.000000
     ParticleFadeFrequency=0.500000
     ParticleFadeSmoothness=0.050000
     SizeSmerpCombiner=0.000050
     SizeSmerpCombiner2=0.000020
     SizeLerpCombiner=0.000500
     SizeLerpCombiner2=0.000200
     FadeSmerpCombiner=0.000050
     FadeSmerpCombiner2=0.000020
     FadeLerpCombiner=0.000500
     FadeLerpCombiner2=0.000200
     XtraSizeTimer=2.000000
     XtraFadeTimer=2.000000
     SphereAngleDegrees=360
     planeangledegrees=180
     SteamBurstIntensity=64.000000
     SplinterThrowRange=256.000000
     ConvergeErrorTolerance=15
     TextureStyle=TS_Translucent
     bHidden=True
     bStasis=True
     RemoteRole=ROLE_SimulatedProxy
     bDirectional=True
     Texture=Texture'UT99ExtensionPack.EdStuff.S_Emitter'
     DrawScale=0.500000
     bGameRelevant=True
     CollisionRadius=14.000000
     CollisionHeight=32.000000
}
