//=============================================================================
// UNREAL: Phoenix Rising
// once used for LSoNP
// - PUBLIC VERSION -
// class by Shadow
// ParticleConcentratePoint, part of the LSoNP/Phoenix Rising ParticleSystem
// used to concentrate spawned particles to this point
// NOTE : can be gravity point using the BehemothPE Formula "GetGravityPoint"
//=============================================================================
class ParticleConcentratePoint expands Keypoint;
#exec obj load file="..\textures\old_fx.utx"

var bool battach;
var() bool bsuck;
var() float EffectiveRadius,CustForce,ConcIntensity,SuckUpdateRate;

function BeginPlay()
{	
	attachtopemitter(battach);
	if (bsuck)settimer(SuckUpdateRate,true);
}
function attachtopemitter(bool battachto)
{
	if (battachto)
	{
		setphysics(phys_trailer);
		btrailersamerotation=true;
	}
}
function timer()
{
	local vector suck;
	local float force;
	local particles p;
	if (bsuck)
	{
		foreach radiusactors(class'particles',p,effectiveradius)
		{
			SetGravityPoint(custforce,p.drawscale,concintensity,location,p.location,p);
		}
	}
}
static function SetGravityPoint(float f,float scale,float intensity,vector a,vector b,actor other)
{
	local vector suck,v;
	local float force;
	suck=a-b;	
	force=f*(150*scale-vsize(suck));
	other.velocity+=-intensity*normal(suck)*force;
}

defaultproperties
{
     EffectiveRadius=256.000000
     CustForce=0.100000
     ConcIntensity=16.000000
     SuckUpdateRate=0.050000
     bStatic=False
     bStasis=True
     bDirectional=True
     Style=STY_Translucent
     Texture=FireTexture'old_fx.Lights.Firewheel'
     DrawScale=0.250000
     CollisionRadius=12.000000
     CollisionHeight=40.000000
     bCollideActors=True
     bCollideWorld=True
}
