//=============================================================================
// TMale1.
//=============================================================================
class TMale1 extends TournamentMale;

#exec MESH IMPORT MESH=Commando ANIVFILE=MODELS\Cmmndo_a.3D DATAFILE=MODELS\Cmmndo_d.3D UNMIRROR=1 LODSTYLE=12
#exec MESH ORIGIN MESH=Commando X=-150 Y=40 Z=0 YAW=64 ROLL=-64

#exec MESH SEQUENCE MESH=Commando SEQ=All       STARTFRAME=0   NUMFRAMES=700 
#exec MESH SEQUENCE MESH=Commando SEQ=GutHit    STARTFRAME=0   NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=Commando SEQ=AimDnLg   STARTFRAME=1   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=AimDnSm   STARTFRAME=2   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=AimUpLg   STARTFRAME=3   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=AimUpSm   STARTFRAME=4   NUMFRAMES=1				Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=Taunt1    STARTFRAME=5   NUMFRAMES=20 RATE=15		Group=Gesture
#exec MESH SEQUENCE MESH=Commando SEQ=Breath1   STARTFRAME=25  NUMFRAMES=7  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=Breath2   STARTFRAME=32  NUMFRAMES=20 RATE=7		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=CockGun   STARTFRAME=52  NUMFRAMES=8  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=DuckWlkL  STARTFRAME=60  NUMFRAMES=15 RATE=15		Group=Ducking
#exec MESH SEQUENCE MESH=Commando SEQ=DuckWlkS  STARTFRAME=75  NUMFRAMES=15 RATE=15		Group=Ducking
#exec MESH SEQUENCE MESH=Commando SEQ=HeadHit   STARTFRAME=90  NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=Commando SEQ=JumpLgFr  STARTFRAME=91  NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Commando SEQ=JumpSmFr  STARTFRAME=92  NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Commando SEQ=LandLgFr  STARTFRAME=93  NUMFRAMES=1				Group=Landing
#exec MESH SEQUENCE MESH=Commando SEQ=LandSmFr  STARTFRAME=94  NUMFRAMES=1				Group=Landing
#exec MESH SEQUENCE MESH=Commando SEQ=LeftHit   STARTFRAME=95  NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=Commando SEQ=Look      STARTFRAME=96  NUMFRAMES=40 RATE=15     Group=Waiting 
#exec MESH SEQUENCE MESH=Commando SEQ=RightHit  STARTFRAME=136 NUMFRAMES=1				Group=TakeHit
#exec MESH SEQUENCE MESH=Commando SEQ=RunLg     STARTFRAME=137 NUMFRAMES=10 RATE=17
#exec MESH SEQUENCE MESH=Commando SEQ=RunLgFr   STARTFRAME=147 NUMFRAMES=10 RATE=17     Group=MovingFire
#exec MESH SEQUENCE MESH=Commando SEQ=RunSm     STARTFRAME=157 NUMFRAMES=10 RATE=17
#exec MESH SEQUENCE MESH=Commando SEQ=RunSmFr   STARTFRAME=167 NUMFRAMES=10 RATE=17		Group=MovingFire
#exec MESH SEQUENCE MESH=Commando SEQ=StillFrRp STARTFRAME=177 NUMFRAMES=10 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=StillLgFr STARTFRAME=187 NUMFRAMES=10 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=StillSmFr STARTFRAME=197 NUMFRAMES=8  RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=SwimLg    STARTFRAME=205 NUMFRAMES=15 RATE=15
#exec MESH SEQUENCE MESH=Commando SEQ=SwimSm    STARTFRAME=220 NUMFRAMES=15 RATE=15
#exec MESH SEQUENCE MESH=Commando SEQ=TreadLg   STARTFRAME=235 NUMFRAMES=15 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=TreadSm   STARTFRAME=250 NUMFRAMES=15 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=Victory1  STARTFRAME=265 NUMFRAMES=18 RATE=11 	Group=Gesture
#exec MESH SEQUENCE MESH=Commando SEQ=WalkLg    STARTFRAME=283 NUMFRAMES=15 RATE=18
#exec MESH SEQUENCE MESH=Commando SEQ=WalkLgFr  STARTFRAME=298 NUMFRAMES=15 RATE=18		Group=MovingFire
#exec MESH SEQUENCE MESH=Commando SEQ=WalkSm    STARTFRAME=313 NUMFRAMES=15 RATE=18
#exec MESH SEQUENCE MESH=Commando SEQ=WalkSmFr  STARTFRAME=328 NUMFRAMES=15 RATE=18		Group=MovingFire
#exec MESH SEQUENCE MESH=Commando SEQ=Wave      STARTFRAME=343 NUMFRAMES=15 RATE=15		Group=Gesture
#exec MESH SEQUENCE MESH=Commando SEQ=Walk      STARTFRAME=358 NUMFRAMES=15 RATE=18
#exec MESH SEQUENCE MESH=Commando SEQ=TurnLg    STARTFRAME=298 NUMFRAMES=2  RATE=15					// 2 frames of walklgfr
#exec MESH SEQUENCE MESH=Commando SEQ=TurnSm    STARTFRAME=328 NUMFRAMES=2  RATE=15					// 2 frames of walksmfr
#exec MESH SEQUENCE MESH=Commando SEQ=Breath1L  STARTFRAME=373 NUMFRAMES=7  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=Breath2L  STARTFRAME=380 NUMFRAMES=20 RATE=7		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=CockGunL  STARTFRAME=400 NUMFRAMES=8  RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=LookL     STARTFRAME=408 NUMFRAMES=40 RATE=15     Group=Waiting 
#exec MESH SEQUENCE MESH=Commando SEQ=WaveL     STARTFRAME=448 NUMFRAMES=15 RATE=15		Group=Gesture
#exec MESH SEQUENCE MESH=Commando SEQ=Chat1     STARTFRAME=463 NUMFRAMES=13 RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=Chat2     STARTFRAME=476 NUMFRAMES=10 RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Commando SEQ=Thrust    STARTFRAME=486 NUMFRAMES=15 RATE=20		Group=Gesture
#exec MESH SEQUENCE MESH=Commando SEQ=DodgeB    STARTFRAME=501 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Commando SEQ=DodgeF    STARTFRAME=502 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Commando SEQ=DodgeR    STARTFRAME=503 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Commando SEQ=DodgeL    STARTFRAME=504 NUMFRAMES=1				Group=Jumping
#exec MESH SEQUENCE MESH=Commando SEQ=Fighter   STARTFRAME=187 NUMFRAMES=1								// first frame of stilllgfr
#exec MESH SEQUENCE MESH=Commando SEQ=Flip      STARTFRAME=505 NUMFRAMES=20				Group=Jumping
#exec MESH SEQUENCE MESH=Commando SEQ=Dead1     STARTFRAME=525 NUMFRAMES=13 RATE=10		Group=TakeHit
#exec MESH SEQUENCE MESH=Commando SEQ=Dead2     STARTFRAME=538 NUMFRAMES=16 RATE=10		
#exec MESH SEQUENCE MESH=Commando SEQ=Dead3     STARTFRAME=554 NUMFRAMES=13 RATE=10
#exec MESH SEQUENCE MESH=Commando SEQ=Dead4     STARTFRAME=567 NUMFRAMES=16 RATE=10
#exec MESH SEQUENCE MESH=Commando SEQ=Dead7     STARTFRAME=583 NUMFRAMES=21 RATE=12		Group=TakeHit
#exec MESH SEQUENCE MESH=Commando SEQ=Dead8     STARTFRAME=604 NUMFRAMES=18 RATE=10		Group=TakeHit
#exec MESH SEQUENCE MESH=Commando SEQ=Dead9     STARTFRAME=622 NUMFRAMES=20 RATE=30		Group=TakeHit
#exec MESH SEQUENCE MESH=Commando SEQ=Dead9B    STARTFRAME=642 NUMFRAMES=10 RATE=15		
#exec MESH SEQUENCE MESH=Commando SEQ=Dead11    STARTFRAME=652 NUMFRAMES=18 RATE=10
#exec MESH SEQUENCE MESH=Commando SEQ=BackRun   STARTFRAME=670 NUMFRAMES=10 RATE=17		Group=MovingFire
#exec MESH SEQUENCE MESH=Commando SEQ=StrafeL   STARTFRAME=680 NUMFRAMES=10 RATE=17		Group=MovingFire
#exec MESH SEQUENCE MESH=Commando SEQ=StrafeR   STARTFRAME=690 NUMFRAMES=10 RATE=17		Group=MovingFire

#exec MESH SEQUENCE MESH=Commando SEQ=DeathEnd  STARTFRAME=537 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Commando SEQ=DeathEnd2 STARTFRAME=553 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Commando SEQ=DeathEnd3 STARTFRAME=566 NUMFRAMES=1

#exec MESHMAP SCALE MESHMAP=Commando X=0.0625 Y=0.0625 Z=0.125

#exec MESH NOTIFY MESH=Commando SEQ=RunLG TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=RunLG TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=RunLGFR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=RunLGFR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=RunSM TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=RunSM TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=RunSMFR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=RunSMFR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=StrafeL TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=StrafeL TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=StrafeR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=StrafeR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=BackRun TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=BackRun TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Commando SEQ=Dead1 TIME=0.7 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Commando SEQ=Dead2 TIME=0.9 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Commando SEQ=Dead3 TIME=0.45 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Commando SEQ=Dead4 TIME=0.6 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Commando SEQ=Dead7 TIME=0.7 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Commando SEQ=Dead8 TIME=0.7 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Commando SEQ=Dead9B TIME=0.8 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Commando SEQ=Dead11 TIME=0.57 FUNCTION=LandThump

#exec AUDIO IMPORT FILE="Sounds\male\jump2.WAV" NAME="TMJump3" GROUP="Male"
#exec AUDIO IMPORT FILE="..\UnrealShare\Sounds\male\land12.WAV" NAME="MLand3" GROUP="Male"

defaultproperties
{
	Handedness=-1.000000
	Mesh=Mesh'Botpack.Commando'
	SelectionMesh="Botpack.SelectionMale1"
	SpecialMesh="Botpack.TrophyMale1"
	JumpSound=TMJump3
	LandGrunt=MLand3
	CarcassType=TMale1Carcass
	Menuname="Male Commando"
	VoiceType="BotPack.VoiceMaleOne"
	TeamSkin1=2
	TeamSkin2=3
	FixedSkin=0
	FaceSkin=1
	DefaultSkinName="CommandoSkins.cmdo"
	DefaultPackage="CommandoSkins."
}