//=============================================================================
// CCProtector41 - This mutator protects players at spawn
//=============================================================================
class CCProtector expands Mutator;

var() config int MinGuardTime;
var() config int GuardTime;
var() config bool ShowTimer;
var() config bool MGTWeaponsDisableGT;
var() config bool FlagCarrierCanSpawnKill;
var() config int ProtectedShooterPenalty;
var() config int ProtectedVictimPenalty;
var() config bool TranslocatorIsWeapon;
var() config bool bLog;

var CCPGuardian aCCPGuardians[ 256 ];

function PostBeginPlay()
{
	Super.PostBeginPlay();
	log("################################################################");
	log("#        CCProtector                                           #");
	log("#  4.1 - Helen      - HTTP://www.birdieman.com                 #");
	log("#  3.0 - TheCatcher - HTTP://www.CatchersCTF.com/CCProtector3  #");
	log("#  1.0 - Dr.SiN                                                #");
	log("################################################################");
	log("# [CCProtector41.CCProtector]" );
	log("# MinGuardTime="$MinGuardTime$" - Time in seconds that the player can not be hurt by other players unless the player picks up the flag." );
	log("# GuardTime="$GuardTime$" - Time in seconds that the player can not be hurt by other players unless the player shoots, changes weapons, or picks up the flag." );
	log("# ShowTimer="$ShowTimer$" - Display the amount of protection time remaining on the players hud." );
	log("# MGTWeaponsDisableGT="$MGTWeaponsDisableGT$" - Weapon manipulation during MinGuardTime disables GuardTime." );
	log("# TranslocatorIsWeapon="$TranslocatorIsWeapon$" - Use of translocator disables GuardTime." );
	log("# FlagCarrierCanSpawnKill="$FlagCarrierCanSpawnKill$" - Flag carrier can defend themselves against pretected players." );
	log("# ProtectedShooterPenalty="$ProtectedShooterPenalty$" - Amount of Health to deduct from shooters that are currently protected." );
	log("# ProtectedVictimPenalty="$ProtectedVictimPenalty$" - Amount of Health to deduct from shooters for shooting players that are currently protected." );
	log("# bLog="$bLog$" - Log Spawn Protection usage to the log file." );
	log("###########################################");

	SaveConfig();

	Level.Game.RegisterDamageMutator(Self); // register ourselves as a damage mutator
}	


function ModifyPlayer(Pawn Other)
{
	local CCPGuardian myCCPG;
	//local Mutator HudMutator;

	if ( bLog )
		Log("#### -- Modifying Player"@Other.PlayerReplicationInfo.PlayerID@"-"@Other.PlayerReplicationInfo.PlayerName);

	// 20100110 Helen - All I did in this class was to remove this condition that the
	// player belongs to a team. This allows the mutator to work fairly for DM.
	//if (Other.PlayerReplicationInfo.Team!=255)
	//{
		if ( aCCPGuardians[ Other.PlayerReplicationInfo.PlayerID % 256 ] == NONE )
		{
			if ( bLog )
				log("#### -- Creating Guardian");
				
			myCCPG = Spawn(class 'CCProtector41.CCPGuardian',,,Other.Location,Other.Rotation);
			if (myCCPG !=None)
			{
				myCCPG.AttachTo(Other,GuardTime,MinGuardTime, ProtectedShooterPenalty, ProtectedVictimPenalty, ShowTimer, MGTWeaponsDisableGT, FlagCarrierCanSpawnKill, TranslocatorIsWeapon);
				aCCPGuardians[ Other.PlayerReplicationInfo.PlayerID % 256 ] = myCCPG;
			}
			else
			{
				Log("#### -- Could not attach");
			}
		}
		else
		{
			if ( bLog )
				log("#### -- Reusing Guardian");
				
			aCCPGuardians[ Other.PlayerReplicationInfo.PlayerID % 256 ].AttachTo(Other,GuardTime,MinGuardTime, ProtectedShooterPenalty, ProtectedVictimPenalty, ShowTimer, MGTWeaponsDisableGT, FlagCarrierCanSpawnKill, TranslocatorIsWeapon);
		}
	//}

	if ( NextMutator != None )
		NextMutator.ModifyPlayer(Other);
}

function MutatorTakeDamage(out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
	local int	  iPID;

	if ( ( InstigatedBy != none ) && ( Victim != InstigatedBy ) )
	{
		if ( ( ! Level.Game.bTeamGame )
			|| ( ( Level.Game.bTeamGame )
			//	&& ( Victim.PlayerReplicationInfo.Team != InstigatedBy.PlayerReplicationInfo.Team ) 
				&& ( ( ! FlagCarrierCanSpawnKill ) || ( InstigatedBy.PlayerReplicationInfo.HasFlag == None ) ) ) )
		{
			iPID = Victim.PlayerReplicationInfo.PlayerID % 256;
			if ( ( aCCPGuardians[ iPID ] != NONE ) && ( aCCPGuardians[ iPID ].bActive ) )
			{
				ActualDamage = 0;
				if ( ( InstigatedBy.PlayerReplicationInfo.HasFlag == None )	&& ( InstigatedBy.Health > ProtectedVictimPenalty ) )
					InstigatedBy.Health -= ProtectedVictimPenalty;
			}

			iPID = InstigatedBy.PlayerReplicationInfo.PlayerID % 256;
			if ( ( aCCPGuardians[ iPID ] != NONE ) && ( aCCPGuardians[ iPID ].bActive ) )
			{
				if ( ( InstigatedBy.PlayerReplicationInfo.HasFlag == None )	&& ( InstigatedBy.Health > ProtectedShooterPenalty ) )
					InstigatedBy.Health -= ProtectedShooterPenalty;
			}
		}
	}
	
	if ( NextDamageMutator != None )
		NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType );
}

function bool PreventDeath(Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
	local bool	  bPreventDeath;
	local int	  iPID;

	bPreventDeath = False;
	if ( ( Killer != none )
		&& ( Killed != Killer ) )
		{
		if ( ( ! Level.Game.bTeamGame )
			|| ( ( Level.Game.bTeamGame )
			//	&& ( Killed.PlayerReplicationInfo.Team != Killer.PlayerReplicationInfo.Team ) 
				&& ( ( ! FlagCarrierCanSpawnKill ) || ( Killer.PlayerReplicationInfo.HasFlag == None ) ) ) )
			{
			iPID = Killed.PlayerReplicationInfo.PlayerID % 256;
			if ( ( aCCPGuardians[ iPID ] != NONE ) && ( aCCPGuardians[ iPID ].bActive ) )
				{
				bPreventDeath = True;
				if ( ( Killer.PlayerReplicationInfo.HasFlag == None )
					&& ( Killer.Health > ProtectedVictimPenalty ) )
					Killer.Health -= ProtectedVictimPenalty;
				}

			iPID = Killer.PlayerReplicationInfo.PlayerID % 256;
			if ( ( aCCPGuardians[ iPID ] != NONE ) && ( aCCPGuardians[ iPID ].bActive ) )
				{
				if ( ( Killer.PlayerReplicationInfo.HasFlag == None )
					&& ( Killer.Health > ProtectedShooterPenalty ) )
					Killer.Health -= ProtectedShooterPenalty;
				}
			}
		}

	if ( bPreventDeath )
		return( bPreventDeath );

	return Super.PreventDeath(Killed,Killer,damageType,HitLocation);
}

defaultproperties
{
	MinGuardTime=2
	GuardTime=10
	ShowTimer=true
	MGTWeaponsDisableGT=false
	FlagCarrierCanSpawnKill=true
	TranslocatorIsWeapon=true
	ProtectedShooterPenalty=0
	ProtectedVictimPenalty=0
	bLog=false
}
