class CCPPCRI_HUDInterface expands CCPPCRI;

var bool bActive;
var int iMinGuardTime;
var int iGuardTime;
var int StartingMinGuardTime;
var int StartingGuardTime;
var int ProtectedShooterPenalty;
var int ProtectedVictimPenalty;
var bool ShowTimer;
var bool FlagCarrierCanSpawnKill;
var bool MGTWeaponsDisableGT;
var bool TranslocatorIsWeapon;
var int Checksum;


replication
{
     reliable if ( Role == ROLE_Authority)
		  bActive
		, iMinGuardTime
		, iGuardTime
		, StartingMinGuardTime
		, StartingGuardTime
		, ProtectedShooterPenalty
		, ProtectedVictimPenalty
		, ShowTimer
		, MGTWeaponsDisableGT
		, TranslocatorIsWeapon
		, Checksum
		;
}

simulated function bool PreCacheClientStub ()
{
	//log( "CCPP - Inside CCPPCRI_HUDInterface.PreCacheClientStub" );

	if( Level.NetMode == NM_DedicatedServer ) // don't run on server
		return true;

	settimer(1,false); // check every second until the HUD is spawned
	return true;     
}

simulated function timer()
{
	local PlayerPawn P;
	local CCPHUD myCCPHUD;
	local Mutator aHudMutator;

	//log( "CCPP - Inside CCPPCRI_HUDInterface.Timer" );
	P = PlayerPawn(Owner);
	if ( P.myHud == none )
	{
		settimer(1,false); // continue checking every second until the HUD is spawned
		return;
	}

	//log( "CCPP - Spawning CCPHUD" );
	
	myCCPHUD = Spawn(class 'CCProtector41.CCPHUD',P.myHud,,P.Location);
	if (myCCPHUD!=None)
	{
		// Attach it to the player
		
		// non-relic version start //
		aHudMutator = P.myHud.HudMutator;
		if (aHudMutator != None)
		{
			myCCPHUD.NextHUD = aHudMutator;
		}
		P.myHud.HudMutator = myCCPHUD;
		// non-relic version end //
		
		// Relic version 
		//myCCPHUD.RegisteraHUDMutator(); 

		myCCPHUD.myCCPPCRI_HUDInterface = self;
	}
}

