//=============================================================================
// CCPHUD. -- Displays protection time left
//=============================================================================

// This is the relics declaration
//class CCPHUD extends HUDMutator config(CCProtector);

// This is the non-relics declaration
class CCPHUD extends Mutator config(CCProtector);

var config bool ShowTimer;
var config string HUDID;
var config int HUDX;
var config int HUDY;
var config Color ProtectedColor;
var config Color GuardedColor;

var Mutator NextHUD;
var CCPPCRI_HUDInterface myCCPPCRI_HUDInterface;

var bool bFirstTime;

function PostBeginPlay()
{
	//log( "CCPP - Inside CCPHUD.PostBeginPlay");

	Super.PostBeginPlay();
	bFirstTime = true;
	HUDX = Clamp( HUDX, 0, 100 );
	HUDY = Clamp( HUDY, 0, 100 );
	SetTimer( 1, false );
}	

simulated function Timer()
{
	local int	  iLclChecksum;

	if ( myCCPPCRI_HUDInterface != none )
	{
		iLclChecksum = 323;
		iLclChecksum += myCCPPCRI_HUDInterface.StartingMinGuardTime;
		iLclChecksum += myCCPPCRI_HUDInterface.StartingGuardTime;
		iLclChecksum += myCCPPCRI_HUDInterface.ProtectedShooterPenalty;
		iLclChecksum += myCCPPCRI_HUDInterface.ProtectedVictimPenalty;
		if ( myCCPPCRI_HUDInterface.ShowTimer )
			iLclChecksum += 1;
		if ( myCCPPCRI_HUDInterface.MGTWeaponsDisableGT )
			iLclChecksum += 1;
		if ( myCCPPCRI_HUDInterface.TranslocatorIsWeapon )
			iLclChecksum += 1;
		if ( myCCPPCRI_HUDInterface.FlagCarrierCanSpawnKill )
			iLclChecksum += 1;
		//log( "CTCFSPHUD - iLclChecksum ="@iLclChecksum@"myCCPPCRI_HUDInterface.Checksum ="@myCCPPCRI_HUDInterface.Checksum );
		if ( iLclChecksum == myCCPPCRI_HUDInterface.Checksum )
			LogSettings();
		else
			SetTimer( 1, false );
	}
	else
	{
		SetTimer( 1, false );
	}
}

simulated function LogSettings()
{
	log("################################################################");
	log("#        CCProtector                                           #");
	log("#  4.1 - Helen      - HTTP://www.birdieman.com                 #");
	log("#  3.0 - TheCatcher - HTTP://www.CatchersCTF.com/CCProtector3  #");
	log("#  1.0 - Dr.SiN                                                #");
	log("################################################################");
	log("# Server Settings" );
	log("#------------------------------------------" );
	log("# MinGuardTime=" $ myCCPPCRI_HUDInterface.StartingMinGuardTime $ " - Time in seconds that the player can not be hurt by other players unless the player picks up the flag." );
	log("# GuardTime=" $ myCCPPCRI_HUDInterface.StartingGuardTime $ " - Time in seconds that the player can not be hurt by other players unless the player shoots, changes weapons, or picks up the flag." );
	log("# ShowTimer=" $ myCCPPCRI_HUDInterface.ShowTimer $ " - Display the amount of protection time remaining on the players hud." );
	log("# MGTWeaponsDisableGT=" $ myCCPPCRI_HUDInterface.MGTWeaponsDisableGT $ " - Weapon manipulation during MinGuardTime disables GuardTime." );
	log("# TranslocatorIsWeapon=" $ myCCPPCRI_HUDInterface.TranslocatorIsWeapon $ " - Use of translocator disables GuardTime." );
	log("# FlagCarrierCanSpawnKill=" $ myCCPPCRI_HUDInterface.FlagCarrierCanSpawnKill $ " - Flag carrier can defend themselves against pretected players." );
	log("# ProtectedShooterPenalty=" $ myCCPPCRI_HUDInterface.ProtectedShooterPenalty $ " - Amount of Health to deduct from shooters that are currently protected." );
	log("# ProtectedVictimPenalty=" $ myCCPPCRI_HUDInterface.ProtectedVictimPenalty $ " - Amount of Health to deduct from shooters for shooting players that are currently protected." );
	log("###########################################");
	log("# Local Player Settings" );
	log("# File: CCProtector.ini" );
	log("#------------------------------------------" );
	log("# [CCProtector41.CCPHUD]" );
	log("# ShowTimer="$ShowTimer$" - Show the HUD of the amount of protection time remaining (only applicable if the server has also enabled ShowTimer)." );
	log("# HUDID="$HUDID$" - Spawn Protection Countdown timer HUD identifier." );
	log("# HUDX="$HUDX$" - Horizontal Location of Countdown Timer on screen (in percentage of screen width (0-99))");
	log("# HUDY="$HUDY$" - Vertical Location of Countdown Timer on screen (in percentage of screen Height (0-99))");
	log("# ProtectedColor=(R="$ProtectedColor.R$",G="$ProtectedColor.R$",B="$ProtectedColor.B$",A="$ProtectedColor.A$") - Color of Countdown Timer when NO ONE can hurt you." );
	log("# GuardedColor=(R="$GuardedColor.R$",G="$GuardedColor.R$",B="$GuardedColor.B$",A="$GuardedColor.A$") - Color of Countdown Timer when NO ONE can hurt you, unless you shoot or change weapons." );
	log("###########################################");
	SaveConfig();
	bFirstTime = false;
}

simulated function PostRender( canvas Canvas )
{
	local float fWidth, fHeight;
	local float fUseableScreenWidth, fUseableScreenHeight;
	local float fCurHudX, fCurHudY;
	local font Font;
	local string strLine;
	local int iCountDown;
	local color CCPColor;

	if ( ( myCCPPCRI_HUDInterface.bActive ) && ( ShowTimer ) )
	{
		iCountDown = myCCPPCRI_HUDInterface.iMinGuardTime + myCCPPCRI_HUDInterface.iGuardTime;

		if ( iCountDown > 0 )
		{
			Canvas.Style = ERenderStyle.STY_Translucent;

			if (Canvas.ClipX < 512)
				Font = Font'SmallFont';
			else if (Canvas.ClipX < 800)
				Font = Font(DynamicLoadObject("LadderFonts.UTLadder16", class'Font'));
			else
				Font = Font(DynamicLoadObject("LadderFonts.UTLadder22", class'Font'));
			
			CCPColor = GuardedColor;
			if ( myCCPPCRI_HUDInterface.iMinGuardTime > 0 )
				CCPColor = ProtectedColor;
			
			Canvas.DrawColor = CCPColor;

			strLine = HUDID @ iCountDown;

			Canvas.Font = Font;
			Canvas.TextSize( strLine, fWidth, fHeight );

			fUseableScreenWidth = Canvas.ClipX - ( fWidth + 1 );
			fUseableScreenHeight = Canvas.ClipY - ( fHeight + 1 );

			fCurHudX = (fUseableScreenWidth/100) * HUDX;
			fCurHudY = (fUseableScreenHeight/100) * HUDY;

			Canvas.Font = Font;
			Canvas.SetPos(fCurHudX, fCurHudY);
			Canvas.DrawText(strLine);
		}
	}

	// non-relic version
	if (NextHUD != None && NextHUD != Self)
		NextHUD.PostRender(Canvas);
	
	// relic version
	//if( NextRHUDMutator != None )
	//	NextRHUDMutator.PostRender(Canvas);

}

defaultproperties
{
	ShowTimer=true
	HUDID="Protected:"
	HUDX=0
	HUDY=87
	ProtectedColor=(G=255)
	GuardedColor=(R=255,G=255)
}
