//=============================================================================
// CCPGuardian. -- This actor attaches to a PAWN and keeps them from dying
//=============================================================================
class CCPGuardian expands Info;

#exec Texture Import File=textures\TeleRed.pcx Name=CCPTeleRed Group=CCP Mips=Off Flags=2
#exec Texture Import File=textures\TeleBlue.pcx Name=CCPTeleBlue Group=CCP Mips=Off Flags=2
#exec Texture Import File=textures\TeleGreen.pcx Name=CCPTeleGreen Group=CCP Mips=Off Flags=2
#exec Texture Import File=textures\TeleGold.pcx Name=CCPTeleGold Group=CCP Mips=Off Flags=2


var Pawn Who;
var Weapon WhosGun;
var int WhosAmmoCount;

var int StartingGuardTime;
var int StartingMinGuardTime;
var float fGuardTime;
var float fMinGuardTime;
var int ProtectedShooterPenalty;
var int ProtectedVictimPenalty;
var bool ShowTimer;
var bool FlagCarrierCanSpawnKill;
var bool MGTWeaponsDisableGT;
var bool bFirstTime;
var bool TranslocatorIsWeapon;

var CCPPCRI_HUDInterface myCCPPCRI_HUDInterface;

var bool bActive;


replication
{
	reliable if( RemoteRole==ROLE_AutonomousProxy ) 
		ChangeSkin;
}

function PostBeginPlay()
{
	//log( "CCPP - CCPGuardian.PostBeginPlay" );
	Super.PostBeginPlay();
	Disable('Tick');
	bFirstTime = true;
}	

// 20100110 Helen - centralized logic to this method, and added logic for impact hammer and translocator.
function bool RemoveProtection()
{
	local ImpactHammer aHammer;
	local Translocator aTranslocator;
	local bool TranslocatorChangeExclusion;
	
	if ( (Who == None) || (Who.Weapon == None) )
	 	return false;

	aTranslocator = Translocator(Who.Weapon);
	
	// The weapon switch does not count if the player is holding the translocator, and we have been told that it is not a weapon.
	TranslocatorChangeExclusion = ( (aTranslocator != None) && (!TranslocatorIsWeapon) );
	
	if ( (( Who.Weapon != WhosGun ) && (!TranslocatorChangeExclusion) ) || ( Who.PlayerReplicationInfo.HasFlag != None ) || ( ( Who.Weapon.AmmoType != None ) && ( Who.Weapon.AmmoType.AmmoAmount < WhosAmmoCount ) ) )
		return true;

	// If the player has an impact hammer and they charge it, remove the protection.
	aHammer = ImpactHammer(Who.Weapon);
	if ((aHammer != None) && (aHammer.ChargeSize > 0))
		return true;

	// If the admin has told us to consider the translocator as a weapon, then remove the protection.
	if ((aTranslocator != None) && (TranslocatorIsWeapon) )
		return true;
		
	return false;
}

event Tick(float DeltaTime)
{
	local int TestTeam;
	local int iOldMinGuardTime;
	local int iOldGuardTime;
	local int iMinGuardTime;
	local int iGuardTime;
	local bool bRemoveProtection;

	if (Who == None)		// If not attached, exit
	{
	 	return;
	}

	iOldMinGuardTime = int(fMinGuardTime+0.5);
	iOldGuardTime = int(fGuardTime+0.5);
	
	if ((fMinGuardTime>0) && (Who.PlayerReplicationInfo.HasFlag == None))
	{
		fMinGuardtime -= DeltaTime;

		if (fMinGuardTime<0)
		{
			fGuardTime -= ABS(fMinGuardTime);
			if ( fGuardTime < 0 )
				fGuardTime = 0;
				
			fMinGuardTime = 0;
		}

		if ( MGTWeaponsDisableGT )
		{
			if (RemoveProtection())
			{
				fGuardTime = 0;
			}
			else
			{
				if ( ( Who.Weapon != None ) && ( Who.Weapon.AmmoType != None ) && ( Who.Weapon.AmmoType.AmmoAmount > WhosAmmoCount ) )
					WhosAmmoCount = Who.Weapon.AmmoType.AmmoAmount;
			}
		}
		else
		{
			if ( Who.Weapon != None )
			{
				WhosGun = Who.Weapon;
				if ( Who.Weapon.AmmoType != None )
					WhosAmmoCount = Who.Weapon.AmmoType.AmmoAmount;
			}
		}
	}
	else
	{
		fMinGuardTime = 0;
		fGuardTime -= DeltaTime;

		bRemoveProtection = ( fGuardTime <= 0 );

		if (!bRemoveProtection)
		{
			bRemoveProtection = RemoveProtection();
		}

		if (bRemoveProtection)
		{
			if ( fGuardTime < 0 )
				fGuardTime = 0;
		
			// Turn off protection.
			bActive = false;
			bHidden=true;
			Disable('Tick');
		}
		else
		{
			if ( ( Who.Weapon != None ) && ( Who.Weapon.AmmoType != None ) && ( Who.Weapon.AmmoType.AmmoAmount > WhosAmmoCount ) )
				WhosAmmoCount = Who.Weapon.AmmoType.AmmoAmount;
		}
	}

	if ( myCCPPCRI_HUDInterface != NONE )		// Update the HUD
	{
		//log( "CCPP - CCPGuardian - Sending settings to myCCPPCRI_HUDInterface" );
		if ( ! bActive )
			myCCPPCRI_HUDInterface.bActive = bActive;
		iMinGuardTime = int(fMinGuardTime+0.5);
		if ( iOldMinGuardTime != iMinGuardTime )
			myCCPPCRI_HUDInterface.iMinGuardTime = iMinGuardTime;
		iGuardTime = int(fGuardTime+0.5);
		if ( iOldGuardTime != iGuardTime )
			myCCPPCRI_HUDInterface.iGuardTime = iGuardTime;
	}
	
	SetLocation(Who.Location);
	SetRotation(Who.Rotation);
}

simulated function ChangeSkin(int team )
{
	local Texture T;

	switch (Team)
	{
		case 0 : 	t = texture 'CCProtector40.CCPTeleRed';
				break;
		case 2 : 	t = texture 'CCProtector40.CCPTeleGreen';
				break;
		case 3 : 	t = texture 'CCProtector40.CCPTeleGold';
				break;
		default:	t = texture 'CCProtector40.CCPTeleBlue';
				break;
	}

	Skin = t;
	MultiSkins[0] = t;
	MultiSkins[1] = t;
	MultiSkins[2] = t;
	MultiSkins[3] = t;
	MultiSkins[4] = t;
	
}

function AttachTo(Pawn Target, int iGTime, int iMGTime, int iPSPenalty, int iPVPenalty, bool bST, bool bMGTSDGT, bool bFCCSPK, bool bTIW )
{
	local int	  iShowTimerCS;
	local int	  iMGTWeaponsDisableGT;
	local int	  iTranslocatorIsWeapon;
	local int	  iFlagCarrierCanSpawnKill;

	//log( "CCPP - CCPGuardian.AttachTo" );

	Who = Target;

	bActive = true;
	SetLocation(Who.Location);
	SetRotation(Who.Rotation);
	fGuardTime = float(iGTime);
	fMinGuardTime = float(iMGTime);
	StartingGuardTime = iGTime;
	StartingMinGuardTime = iMGTime;
	ProtectedShooterPenalty = iPSPenalty;
	ProtectedVictimPenalty = iPVPenalty;
	ShowTimer = bST;
	MGTWeaponsDisableGT = bMGTSDGT;
	FlagCarrierCanSpawnKill = bFCCSPK;
	TranslocatorIsWeapon = bTIW;
	WhosGun = Who.Weapon;	
	if ( WhosGun != None )
	{
		if ( Who.Weapon.AmmoType != None )
			WhosAmmoCount = Who.Weapon.AmmoType.AmmoAmount;
		else
			WhosAmmoCount = 0;
	}
	bHidden=false;

	ChangeSkin(Who.PlayerReplicationInfo.Team );

	if ( bFirstTime ) 
	{
		if ( ( ShowTimer ) && ( ! Who.IsA('Bot') ) )
		{
			//log( "CCPGaurdian - Spawning CCPPCRI_HUDInterface" );
			myCCPPCRI_HUDInterface = Spawn(class 'CCProtector40.CCPPCRI_HUDInterface',Who,,Who.Location);
			if (myCCPPCRI_HUDInterface!=None)
			{
				//log( "CCPGaurdian - Spawned CCPPCRI_HUDInterface" );
				iShowTimerCS = 0;
				iMGTWeaponsDisableGT = 0;
				iTranslocatorIsWeapon = 1;
				myCCPPCRI_HUDInterface.StartingMinGuardTime = StartingMinGuardTime;
				myCCPPCRI_HUDInterface.StartingGuardTime = StartingGuardTime;
				myCCPPCRI_HUDInterface.ProtectedShooterPenalty = ProtectedShooterPenalty;
				myCCPPCRI_HUDInterface.ProtectedVictimPenalty = ProtectedVictimPenalty;
				myCCPPCRI_HUDInterface.ShowTimer = ShowTimer;
				myCCPPCRI_HUDInterface.MGTWeaponsDisableGT = MGTWeaponsDisableGT;
				myCCPPCRI_HUDInterface.TranslocatorIsWeapon = TranslocatorIsWeapon;
				myCCPPCRI_HUDInterface.FlagCarrierCanSpawnKill = FlagCarrierCanSpawnKill;
				if ( ShowTimer )
					iShowTimerCS = 1;
				if ( MGTWeaponsDisableGT )
					iMGTWeaponsDisableGT = 1;
				if ( !TranslocatorIsWeapon )
					iTranslocatorIsWeapon = 0;
				myCCPPCRI_HUDInterface.CheckSum = StartingMinGuardTime 
								+ StartingGuardTime
								+ ProtectedShooterPenalty 
								+ ProtectedVictimPenalty
								+ iShowTimerCS
								+ iMGTWeaponsDisableGT
								+ iFlagCarrierCanSpawnKill
								+ iTranslocatorIsWeapon
								+ 323;
			}
		}
		bFirstTime = false;
	}

	if ( myCCPPCRI_HUDInterface != NONE )		// Update the HUD
		{
		myCCPPCRI_HUDInterface.bActive = bActive;
		myCCPPCRI_HUDInterface.iMinGuardTime = int(fMinGuardTime+0.5);
		myCCPPCRI_HUDInterface.iGuardTime = int(fGuardTime+0.5);
		}

	Enable('Tick');
}

auto state Living
{
	function AnimEnd()
	{
		PlayAnim('Teleport');
	}
	
	function BeginState()
	{
		PlayAnim('TelePort');
	}
}

defaultproperties
{
	mesh=LodMesh'Botpack.Tele2'
	bHidden=False
	DrawType=DT_Mesh
}
