//=============================================================================
// Universal Unreal
// Version 1.12N Build 1
// June 2009
// Created By Matthew 'MSuLL' Sullivan
//=============================================================================
class uu_WebServer extends TcpLink;

function PreBeginPlay()
{
	local int port;
	local UniversalUnreal S;

	if(Owner.IsA('UniversalUnreal'))
	{
		AcceptClass = Class'uu_WebServer';

		ForEach Level.AllActors(class'UniversalUnreal',S)
		{
			port = S.TCPServerPort;
			S.xxLog("Universal Unreal HTTP server is listening on TCP "$BindPort(port,false));
			break;
		}

		Listen();
	}
	LinkMode=MODE_Line;
}

event ReceivedLine(string Str)
{
	local UniversalUnreal S;

	Close(); // Don't leave it open longer than needed, remote webserver will think it's just been blown off and move on

	// meanwhile, we crunch on the info that we were given
	if(Left(CAPS(Str), 4) ~= "GET " && InStr(Str,"?universalunreal") != -1)
	{
		if (InStr(Str,"&") != -1)
		Str = Mid(Str,InStr(Str,"&")+1);

		if (InStr(Str,"&") != -1)
		Str = Left(Str,InStr(Str,"&"));

		ForEach Level.AllActors(class'UniversalUnreal',S)
		{
			S.ProcessGetFromWebserver(Str);
			return;
		}
	}
}

defaultproperties
{
   RemoteRole=ROLE_None
}
