//=============================================================================
// Universal Unreal
// Version 1.12N Build 1
// June 2009
// Created By Matthew 'MSuLL' Sullivan
//=============================================================================
class uu_ReplicationInfo extends ReplicationInfo;

var int checksum; // Checksum of replicated data.

var String UniverseID;
var bool bHideHUDForGuests;
var int ServerListYOffset;
var String serverQuery[10];

/***************************************************************************************************
 *  $DESCRIPTION  Replication block.
 **************************************************************************************************/
replication
{
	reliable if (role == ROLE_Authority)
		checksum, UniverseID, bHideHUDForGuests, serverQuery, ServerListYOffset;
}

/***************************************************************************************************
 *  $DESCRIPTION  Calculates a checksum of the replicated dynamic variables.
 *  $RETURN       The checksum of the replicated variables.
 **************************************************************************************************/
simulated function int calcChecksum()
{
	local int checksum;
	local int index;
	
	checksum = 1;

	checksum += class'NexgenUtil'.static.stringHash(UniverseID);
	checksum += int(bHideHUDForGuests);
	checksum += class'NexgenUtil'.static.stringHash(ServerListYOffset);
	
	return checksum;
}

defaultproperties
{
}
