//=============================================================================
// Universal Unreal
// Version 1.12N Build 1
// June 2009
// Created By Matthew 'MSuLL' Sullivan
//=============================================================================
class uu_NexgenGUIPrivateMsgTab extends NexgenPanel;

var uu_NexgenClient xClient;

var UWindowDynamicTextArea history;
var NexgenSimpleListBox playerList;
var UWindowSmallButton sendNormalButton;
var UWindowEditControl msgInp, otherInp;

var bool bIngoreNotify;


/***************************************************************************************************
*  $DESCRIPTION  Creates the contents of the panel.
**************************************************************************************************/
function setContent()
{
	local NexgenContentPanel p;
	
	// Get client controller.
	xClient = uu_NexgenClient(client.getController(class'uu_NexgenClient'.default.ctrlID));

	// Create layout & add components.
	createWindowRootRegion();
	splitRegionV(192, defaultComponentDist);
	
	// Buddy list
	p = addContentPanel();

	p.splitRegionH(48, defaultComponentDist, , true);
	p.splitRegionH(16);
	p.splitRegionH(16);

	p.addLabel("Online Buddies", true, TA_Center);
	playerList = NexgenSimpleListBox(p.addListBox(class'NexgenSimpleListBox'));
	p.addLabel("Other (Enter Universe Name):", true, TA_Center);
	otherInp = p.addEditbox();

	// 'Say' panel.
	splitRegionH(64, defaultComponentDist);
	p = addContentPanel();
	p.divideRegionH(3, defaultComponentDist);
	p.addLabel("Message", true, TA_Center);
	msgInp = p.addEditbox();
	sendNormalButton = p.addButton("Send Message");

	// History panel.
	p = addContentPanel();
	p.splitRegionH(16);
	p.addLabel("History", true, TA_Center);
	history = p.addDynamicTextArea();
	
	// Configure components.
	playerList.register(self);
	sendNormalButton.register(self);

	msgInp.register(self);
	msgInp.setMaxLength(255);

	otherInp.register(self);
	otherInp.setMaxLength(255);
}

function createPlayerListItem(String displayText)
{
	local NexgenSimpleListItem item;

	item = NexgenSimpleListItem(playerList.items.append(class'NexgenSimpleListItem'));
	item.displayText = displayText;
}

/***************************************************************************************************
*  $DESCRIPTION  Notifies the dialog of an event (caused by user interaction with the interface).
*  $PARAM        control    The control object where the event was triggered.
*  $PARAM        eventType  Identifier for the type of event that has occurred.
*  $REQUIRE      control != none
**************************************************************************************************/
function notify(UWindowDialogControl control, byte eventType)
{
	if(bIngoreNotify) return;

	else if( control == otherInp && eventType == DE_Change && playerList.selectedItem != None)
	{
		bIngoreNotify = true;
		playerList.selectedItem.bSelected = false;
		playerList.selectedItem = none;
		bIngoreNotify = false;
	}
	else if( control == playerList && eventType == DE_Click)
	{
		bIngoreNotify = true;
		otherInp.setValue("");
		bIngoreNotify = false;
	}
	// Send normal clicked.
	else if (control == sendNormalButton && eventType == DE_Click) 
	{
		sendMessage();
	}

	// Enter button pressed on message edit box.
	if (control == msgInp && eventType == DE_EnterPressed) 
	{
		sendMessage();
	}
}

/***************************************************************************************************
*  $DESCRIPTION  Adds a new message to the to message history box.
*  $PARAM        msg  The message to add.
**************************************************************************************************/
function addHistoryMsg(string msg)
{
	local string timeStamp;
	
	timeStamp = "[" $ right("0" $ client.level.hour, 2) $ ":" $ right("0" $ client.level.minute, 2) $ "]";
	history.addText(timeStamp @ msg);
}

/***************************************************************************************************
*  $DESCRIPTION  Send the currently enterted message to the selected player.
**************************************************************************************************/
function sendMessage()
{
	local String selectedPlayer;

	// first look for custom player field
	if(otherInp.getValue() != "")
	{
		selectedPlayer = otherInp.getValue();
	}
	// Get selected player.
	else if (playerList.selectedItem != none)
	{
		selectedPlayer = NexgenSimpleListItem(playerList.selectedItem).displayText;
	}
	
	// Send message.
	if (selectedPlayer != "" && msgInp.getValue() != "")
	{
		addHistoryMsg(client.lng.format(client.lng.sendMsgTxt, selectedPlayer, msgInp.getValue()));
		client.player.mutate("UNIVERSALUNREAL PM"@selectedPlayer@msgInp.getValue());
		msgInp.setValue("");
	}
}

/***************************************************************************************************
*  $DESCRIPTION  Called when a new private message was received. Adds the received message to the chat history.
*  $PARAM        msg  The message that was received.
*  $PARAM        playerName  Player player that has sent the message.
**************************************************************************************************/
function receiveMessage(string msg, string playerName) 
{
	addHistoryMsg(client.lng.format(client.lng.receivedMsgTxt, playerName, msg));
}

defaultproperties
{
   panelIdentifier="uu_NexgenGUIPrivateMsgTab"
}
