//=============================================================================
// Universal Unreal
// Version 1.12N Build 1
// June 2009
// Created By Matthew 'MSuLL' Sullivan
//=============================================================================
class uu_NexgenGUILookupTab extends NexgenPanel;

var uu_NexgenClient xClient;

var NexgenSimplePlayerListBox playerList;
var NexgenSimpleListBox nameHistoryList;
var NexgenSimpleListBox ipHistoryList;
var NexgenSimpleListBox playingHistoryList;
var NexgenSimpleListBox actionsHistoryList;
var UMenuLabelControl clientIDLabel;
var UWindowSmallButton lookupThisButton;
var UWindowSmallButton lookupAllButton;
var UWindowSmallButton copyButton;
var UWindowSmallButton saveToFileButton;
var String lookupUserName;
var String lookupClientID;

/***************************************************************************************************
*  $DESCRIPTION  Creates the contents of the panel.
**************************************************************************************************/
function setContent()
{
	local NexgenContentPanel p;

	// Get client controller.
	xClient = uu_NexgenClient(client.getController(class'uu_NexgenClient'.default.ctrlID));
   
	createWindowRootRegion();
   
	splitRegionV(140, defaultComponentDist);
   
	splitRegionH(48, defaultComponentDist, , true);
	splitRegionH(32, defaultComponentDist);
   
	playerList = NexgenSimplePlayerListBox(addListBox(class'NexgenSimplePlayerListBox'));
	divideRegionH(2);
	p = addContentPanel();
	p.splitRegionV(96);
	p.addLabel("Client ID:", true);
	clientIDLabel = p.addLabel("", true);
	p = addContentPanel();
	p.splitRegionH(16, defaultComponentDist, , true);
	p.divideRegionH(2, defaultComponentDist);
	p.splitRegionV(50, defaultComponentDist, true, true);
	p.divideRegionV(2, defaultComponentDist);
	p.divideRegionH(2, defaultComponentDist);
	saveToFileButton = p.addButton("Save To A Text File");
	copyButton = p.addButton("Copy Selected");
	p.splitRegionH(16);
	p.splitRegionH(16);
	p.splitRegionH(16);
	p.splitRegionH(16);
	p.addLabel("Name History", true, TA_Center);
	nameHistoryList = NexgenSimpleListBox(p.addListBox(class'NexgenSimpleListBox'));
	p.addLabel("IP/Host History", true, TA_Center);
	ipHistoryList = NexgenSimpleListBox(p.addListBox(class'NexgenSimpleListBox'));
	p.addLabel("Playing History", true, TA_Center);
	playingHistoryList = NexgenSimpleListBox(p.addListBox(class'NexgenSimpleListBox'));
	p.addLabel("Actions Against This User", true, TA_Center);
	actionsHistoryList = NexgenSimpleListBox(p.addListBox(class'NexgenSimpleListBox'));
   
	lookupThisButton = addButton("Lookup For THIS Server");
	lookupAllButton = addButton("Lookup For ALL Servers");
}

/***************************************************************************************************
*  $DESCRIPTION  Called when a player was selected from the list.
**************************************************************************************************/
function playerSelected()
{
	local NexgenPlayerList item;
	
	item = NexgenPlayerList(playerList.selectedItem);

	if (item == none)
	{
		clientIDLabel.setText("");
	}
	else
	{
		clientIDLabel.setText(item.pClientID);
	}
}

function createListItem(int i,String displayText)
{
	local NexgenSimpleListItem item;

	switch(i)
	{
		case 0:
			item = NexgenSimpleListItem(nameHistoryList.items.append(class'NexgenSimpleListItem'));
			item.displayText = displayText;
			break;
		case 1:
			item = NexgenSimpleListItem(ipHistoryList.items.append(class'NexgenSimpleListItem'));
			item.displayText = displayText;
			break;
		case 2:
			item = NexgenSimpleListItem(playingHistoryList.items.append(class'NexgenSimpleListItem'));
			item.displayText = displayText;
			break;
		case 3:
			if(CAPS(displayText) == "NONE FOUND")
			{
				item = NexgenSimpleListItem(actionsHistoryList.items.append(class'NexgenSimpleListItem'));
				item.displayText = displayText;
			}
			else
			{
				item = NexgenSimpleListItem(actionsHistoryList.items.append(class'NexgenSimpleListItem'));
				item.displayText = Left(displayText, InStr(displayText,":::"));

				item = NexgenSimpleListItem(actionsHistoryList.items.append(class'NexgenSimpleListItem'));
				item.displayText = Mid(displayText, InStr(displayText,":::") + 3);
			}
			break;
	}
}

/***************************************************************************************************
*  $DESCRIPTION  Notifies the dialog of an event (caused by user interaction with the interface).
*  $PARAM        control    The control object where the event was triggered.
*  $PARAM        eventType  Identifier for the type of event that has occurred.
*  $REQUIRE      control != none
**************************************************************************************************/
function notify(UWindowDialogControl control, byte eventType)
{
	local NexgenSimpleListItem item;

	super.notify(control, eventType);

	// Player selected?
	if (control == playerList && eventType == DE_Click)
	{
		playerSelected();
	}
	else if (control == lookupThisButton && eventType == DE_Click)
	{
		if(playerList.selectedItem == None || !playerList.selectedItem.bSelected)
		{
			return;
		}

		resetLists(nameHistoryList, ipHistoryList, playingHistoryList, actionsHistoryList);

		nameHistoryList.items.clear();
		ipHistoryList.items.clear();
		playingHistoryList.items.clear();
		actionsHistoryList.items.clear();
		lookupUserName = NexgenPlayerList(playerList.selectedItem).pName;
		lookupClientID = NexgenPlayerList(playerList.selectedItem).pClientID;
		client.player.mutate("UNIVERSALUNREAL LOOKUP LOCAL"@NexgenPlayerList(playerList.selectedItem).pClientID);
	}
	else if (control == lookupAllButton && eventType == DE_Click)
	{
		if(playerList.selectedItem == None || !playerList.selectedItem.bSelected)
		{
			return;
		}

		resetLists(nameHistoryList, ipHistoryList, playingHistoryList, actionsHistoryList);

		nameHistoryList.items.clear();
		ipHistoryList.items.clear();
		playingHistoryList.items.clear();
		actionsHistoryList.items.clear();
		lookupUserName = NexgenPlayerList(playerList.selectedItem).pName;
		lookupClientID = NexgenPlayerList(playerList.selectedItem).pClientID;
		client.player.mutate("UNIVERSALUNREAL LOOKUP UNIVERSAL"@NexgenPlayerList(playerList.selectedItem).pClientID);
	}
	else if (control == copyButton && eventType == DE_Click)
	{
		if(nameHistoryList.selectedItem != None)
		{
			client.player.CopyToClipboard(NexgenSimpleListItem(nameHistoryList.selectedItem).displayText);
			client.showMsg("<C09>Alias copied successfully!");
		}
		else if(ipHistoryList.selectedItem != None)
		{
			client.player.CopyToClipboard(NexgenSimpleListItem(ipHistoryList.selectedItem).displayText);
			client.showMsg("<C09>IP and hostname copied successfully!");
		}
		else if(playingHistoryList.selectedItem != None)
		{
			client.player.CopyToClipboard(NexgenSimpleListItem(playingHistoryList.selectedItem).displayText);
			client.showMsg("<C09>Playing history entry copied successfully!");
		}
		else if(actionsHistoryList.selectedItem != None)
		{
			client.player.CopyToClipboard(NexgenSimpleListItem(actionsHistoryList.selectedItem).displayText);
			client.showMsg("<C09>Actions history entry copied successfully!");
		}
		else
		{
			client.showMsg("<C09>Cannot copy data, no field selected.");
		}
	}
	else if (control == saveToFileButton && eventType == DE_Click)
	{
		if(lookupUserName == "" || lookupClientID == "")
		{
			client.showMsg("<C09>Failed to save data! No queries have been performed.");
			return;
		}

		xClient.exLog("--------------------BEGIN LOG--------------------");
		xClient.exLog("Saved At"@xClient.GetDate());
		xClient.exLog("Player Name:"@lookupUserName);
		xClient.exLog("Client ID:"@lookupClientID);
		xClient.exLog(" ");
		xClient.exLog("Name History:");

		for (item = NexgenSimpleListItem(nameHistoryList.items); item != none; item = NexgenSimpleListItem(item.next))
		{
			if(len(item.displayText) > 0)
				xClient.exLog(item.displayText);
		}

		xClient.exLog(" ");
		xClient.exLog("IP / Hostname History:");

		for (item = NexgenSimpleListItem(ipHistoryList.items); item != none; item = NexgenSimpleListItem(item.next))
		{
			if(len(item.displayText) > 0)
				xClient.exLog(item.displayText);
		}

		xClient.exLog(" ");
		xClient.exLog("Playing History:");

		for (item = NexgenSimpleListItem(playingHistoryList.items); item != none; item = NexgenSimpleListItem(item.next))
		{
			if(len(item.displayText) > 0)
				xClient.exLog(item.displayText);
		}

		xClient.exLog(" ");
		xClient.exLog("Actions History:");

		for (item = NexgenSimpleListItem(actionsHistoryList.items); item != none; item = NexgenSimpleListItem(item.next))
		{
			if(len(item.displayText) > 0)
				xClient.exLog(item.displayText);
		}

		xClient.exLog("---------------------END LOG---------------------");
		xClient.exLog(" ");

		client.showMsg("<C09>Data saved to /System/"@xClient.uuLog.niceFileName);
	}
	else if( control == nameHistoryList && eventType == DE_Click)
	{
		resetLists(ipHistoryList,playingHistoryList,actionsHistoryList);
	}
	else if( control == ipHistoryList && eventType == DE_Click)
	{
		resetLists(nameHistoryList,playingHistoryList,actionsHistoryList);
	}
	else if( control == playingHistoryList && eventType == DE_Click)
	{
		resetLists(nameHistoryList,ipHistoryList,actionsHistoryList);
	}
	else if( control == actionsHistoryList && eventType == DE_Click)
	{
		resetLists(nameHistoryList,ipHistoryList,playingHistoryList);
	}
}

function resetLists(NexgenSimpleListBox listControl1, optional NexgenSimpleListBox listControl2, optional NexgenSimpleListBox listControl3, optional NexgenSimpleListBox listControl4)
{
	if(listControl1 != None)
	{
		if(listControl1.selectedItem != None)
		{
			listControl1.selectedItem.bSelected = false;
			listControl1.selectedItem = None;
		}
	}

	if(listControl2 != None)
	{
		if(listControl2.selectedItem != None)
		{
			listControl2.selectedItem.bSelected = false;
			listControl2.selectedItem = None;
		}
	}

	if(listControl3 != None)
	{
		if(listControl3.selectedItem != None)
		{
			listControl3.selectedItem.bSelected = false;
			listControl3.selectedItem = None;
		}
	}

	if(listControl4 != None)
	{
		if(listControl4.selectedItem != None)
		{
			listControl4.selectedItem.bSelected = false;
			listControl4.selectedItem = None;
		}
	}
}

/***************************************************************************************************
*  $DESCRIPTION  Notifies the client of a player event. Additional arguments to the event should be
                combined into one string which then can be send along with the playerEvent call.
*  $PARAM        playerNum  Player identification number.
*  $PARAM        eventType  Type of event that has occurred.
*  $PARAM        args       Optional arguments.
*  $REQUIRE      playerNum >= 0
**************************************************************************************************/
function playerEvent(int playerNum, string eventType, optional string args) 
{
	
	// Player has joined the game?
	if (eventType == client.PE_PlayerJoined) 
	{
		addPlayerToList(playerList, playerNum, args);
	}
	
	// Player has left the game?
	if (eventType == client.PE_PlayerLeft) 
	{
		playerList.removePlayer(playerNum);
		playerSelected();
	}
	
	// Attribute changed?
	if (eventType == client.PE_AttributeChanged) 
	{
		updatePlayerInfo(playerList, playerNum, args);
		playerSelected();
	}
}

defaultproperties
{
   panelIdentifier="uu_NexgenGUILookupTab"
   PanelHeight=500.00
}
