//=============================================================================
// Universal Unreal
// Version 1.12N Build 1
// June 2009
// Created By Matthew 'MSuLL' Sullivan
//=============================================================================
class uu_NexgenGUIClientTab extends NexgenPanel;

var uu_NexgenClient xClient;

var UMenuLabelControl serverNameLabel;
var UMenuLabelControl serverAddressLabel;
var NexgenEditControl editUserName, editUserPass;
var UWindowSmallButton saveAuthButton, saveSettingsButton;
var UWindowCheckbox enableDefaultHUD, enableVoiceAlerts;
var String userName;

/***************************************************************************************************
*  $DESCRIPTION  Creates the contents of the panel.
**************************************************************************************************/
function setContent()
{
	local GameReplicationInfo GRI;
	local TournamentGameReplicationInfo TGRI;
	local NexgenContentPanel p;

	// Get client controller.
	xClient = uu_NexgenClient(client.getController(class'uu_NexgenClient'.default.ctrlID));
	
	// Create layout & add components.
	createWindowRootRegion();

	splitRegionH(32, defaultComponentDist);

	// Title.
	p = addContentPanel();
	p.addLabel("Universal Unreal Authentication Settings", true, TA_Center);
	
	// Auth Stuff
	splitRegionH(64, defaultComponentDist);
	p = addContentPanel();
	p.splitRegionV(192);
	p.divideRegionH(3);
	p.divideRegionH(3);
	p.addLabel("Community Universe Username:", true);
	p.addLabel("Community Universe Password:", true);
	saveAuthButton = p.addButton("Save Login Information");

	editUserName = p.addEditBox("",200);
	editUserName.setMaxLength(255);
	editUserPass = p.addEditBox("",200);
	editUserPass.setMaxLength(255);

	splitRegionH(32, defaultComponentDist);
	
	// Title.
	p = addContentPanel();
	p.addLabel("Universal Unreal Client Preferences", true, TA_Center);

	// Settings Stuff
	splitRegionH(64, defaultComponentDist);
	p = addContentPanel();
	p.splitRegionV(256);
	p.divideRegionH(3);
	p.divideRegionH(3);

	enableDefaultHUD = p.addCheckBox(TA_Left, "Auto Show HUD Overlays During Match", true);
	enableVoiceAlerts = p.addCheckBox(TA_Left, "Use Voice Alerts", true);
	saveSettingsButton = p.addButton("Save Client Settings");

	setValues();
}

function setValues()
{
	enableDefaultHUD.bChecked = bool(xClient.client.gc.get("uu_enableDefaultHUD", "True"));
	enableVoiceAlerts.bChecked = bool(xClient.client.gc.get("uu_voiceAlerts", "True"));

	if(userName != "")
	{
		editUserName.setValue(userName);
		editUserPass.setValue("*****");
	}
}

function Notify(UWindowDialogControl C, byte E)
{
	local int i;
	Super.Notify(C, E);

   switch(E)
   {
      case DE_Click:
         switch (C)
			{
				case saveAuthButton:
					if(editUserPass.GetValue() == "*****")
					{
						client.showMsg("<C09>Unable to save credentials! You must specify a password!");
					}
					else
					{
						if(xClient.saveCredentials(editUserName.GetValue(),editUserPass.GetValue()))
						{
							client.showMsg("<C09>Unable to save credentials! All slots in 'UniversalUnreal_CredManager.ini' are filled!");
						}
						else
						{
							if(editUserPass.GetValue() != "")
								editUserPass.setValue("*****");

							client.showMsg("<C09>Credentials saved! You will be logged in automatically on your next reconnect.");
						}
					}
 				break;
				case saveSettingsButton:
					xClient.client.gc.set("uu_enableDefaultHUD",String(enableDefaultHUD.bChecked));
					xClient.client.gc.set("uu_voiceAlerts",String(enableVoiceAlerts.bChecked));
					xClient.client.gc.SaveConfig();

					client.showMsg("<C09>Settings saved! Changes will take effect on your next reconnect.");
 				break;
         }
		break;
	}
}

defaultproperties
{
   panelIdentifier="uu_NexgenGUILogin"
}
