//=============================================================================
// Universal Unreal
// Version 1.12N Build 1
// June 2009
// Created By Matthew 'MSuLL' Sullivan
//=============================================================================
class uu_NexgenGUIBuddiesTab extends NexgenPanel;

var uu_NexgenClient xClient;

var NexgenSimpleListBox buddyList;
var UMenuLabelControl serverNameLabel;
var UMenuLabelControl serverAddressLabel;
var UWindowSmallButton acceptButton, denyButton;

var String buddyData;

/***************************************************************************************************
*  $DESCRIPTION  Creates the contents of the panel.
**************************************************************************************************/
function setContent()
{
	local NexgenContentPanel p;
	
	// Get client controller.
	xClient = uu_NexgenClient(client.getController(class'uu_NexgenClient'.default.ctrlID));
	
	// Create layout & add components.
	createWindowRootRegion();
	splitRegionH(48, defaultComponentDist, , true);
	buddyList = NexgenSimpleListBox(addListBox(class'NexgenSimpleListBox'));
	p = addContentPanel();
	p.divideRegionH(2);
	acceptButton = p.addButton("Accept Request");
	denyButton = p.addButton("Deny Request");
}

/***************************************************************************************************
*  $DESCRIPTION  Loads the buddy list.
**************************************************************************************************/
function loadbuddyList()
{
	local int index, i;
	local String atc[16];
	local NexgenSimpleListItem item;

	atc[0]=left(buddyData,InStr(buddyData,","));
	for(i=0;InStr(buddyData,",")!=-1;i++)
	{
		buddyData=right(buddyData,Len(buddyData)-InStr(buddyData,",")-1);
		atc[i+1]=left(buddyData,InStr(buddyData,","));
	}
	atc[i]=buddyData;
	
	while (index < arrayCount(atc) && atc[index] != "")
	{
		item = NexgenSimpleListItem(buddyList.items.append(class'NexgenSimpleListItem'));
		item.displayText = Mid(atc[index],InStr(atc[index],";")+1);
		item.itemID = int(Left(atc[index],InStr(atc[index],";")));
		
		index++;
	}

	buddySelected();
}

/***************************************************************************************************
*  $DESCRIPTION  Called when a buddy has been selected from the list.
**************************************************************************************************/
function buddySelected()
{
	local NexgenSimpleListItem item;
	
	// Get selected item.
	item = NexgenSimpleListItem(buddyList.selectedItem);
	
	// Update GUI components.
	if (item == none)
	{
		acceptButton.bDisabled = true;
		denyButton.bDisabled = true;
	}
	else
	{
		acceptButton.bDisabled = false;
		denyButton.bDisabled = false;
	}
}

/***************************************************************************************************
*  $DESCRIPTION  Notifies the dialog of an event (caused by user interaction with the interface).
*  $PARAM        control    The control object where the event was triggered.
*  $PARAM        eventType  Identifier for the type of event that has occurred.
*  $REQUIRE      control != none
**************************************************************************************************/
function notify(UWindowDialogControl control, byte eventType)
{
	super.notify(control, eventType);
	
	if (control == buddyList && eventType == DE_Click)
	{
		buddySelected();
	}
	else if (control == acceptButton && eventType == DE_Click && !acceptButton.bDisabled)
	{
		client.player.mutate("UNIVERSALUNREAL ACCEPTBUDDY"@NexgenSimpleListItem(buddyList.selectedItem).itemID);
		xClient.addMsg("You have accepted a buddy request from"@NexgenSimpleListItem(buddyList.selectedItem).displayText);
		NexgenSimpleListItem(buddyList.selectedItem).remove();
		buddyList.selectedItem = None;
		buddySelected();
	}
	else if (control == denyButton && eventType == DE_Click && !acceptButton.bDisabled)
	{
		client.player.mutate("UNIVERSALUNREAL DENYBUDDY"@NexgenSimpleListItem(buddyList.selectedItem).itemID);
		xClient.addMsg("You have denied a buddy request from"@NexgenSimpleListItem(buddyList.selectedItem).displayText);
		NexgenSimpleListItem(buddyList.selectedItem).remove();
		buddyList.selectedItem = None;
		buddySelected();
	}
}

defaultproperties
{
   panelIdentifier="uu_NexgenGUIBuddiesTab"
}
