//=============================================================================
// Universal Unreal
// Version 1.12N Build 1
// June 2009
// Created By Matthew 'MSuLL' Sullivan
//=============================================================================
class uu_NexgenClient extends NexgenClientController;

#exec AUDIO IMPORT NAME="BuddyJoined" FILE="Resources\BuddyJoined.wav" GROUP="UniversalUnreal"
#exec AUDIO IMPORT NAME="NewPrivateMessage" FILE="Resources\NewPrivateMessage.wav" GROUP="UniversalUnreal"
#exec AUDIO IMPORT NAME="LoggedIn" FILE="Resources\LoggedIn.wav" GROUP="UniversalUnreal"
#exec AUDIO IMPORT NAME="LoginFailed" FILE="Resources\LoginFailed.wav" GROUP="UniversalUnreal"
#exec AUDIO IMPORT NAME="BuddyRequests" FILE="Resources\BuddyRequests.wav" GROUP="UniversalUnreal"
#exec AUDIO IMPORT NAME="HenryVIII" FILE="Resources\HenryVIII.wav" GROUP="UniversalUnreal"

var uu_CredentialManager uuCM;
var UniversalUnreal S;

var String universeUserName;
var String lastNotedServerURL;
var String lastNotedServerName;
var bool authSuccess;
var bool hudShowing;
var String buddyInfo[32]; // last 32 buddy joins
var String boundKey;

var Mutator NSVHUD;
var uu_HUDModifier xHUD;
var uu_NexgenGUIPrivateMsgTab uuPMPanel;
var uu_NexgenGUIClientTab uuGUIClientTab;
var uu_NexgenGUILookupTab uuGUILookupTab;

var uu_ExLog uuLog;
var bool bGameEnded;
var bool bLogging;

var bool bChecksumFinished;
var bool bInfoReceivedCalled;
var bool enableDefaultHUD;
var bool bHUDSpawned;
var bool bHUDTimerDisable;
var bool bAuthSuccessful;
var int hudTimer;
var String credentialsUsername, credentialsPassword;

var float checksumWaitSince;            // Waiting for checksum match since this time.
const checksumMatchTimeout = 60;        // Number of second to wait before giving up on checksum match.
var int authTimer;
var uu_ReplicationInfo uuRI;          // Replication info.

replication
{
	reliable if(Role<ROLE_Authority )
		sendLoginCredentials,sendPlayer,storeUniverseUsername;
	reliable if(Role==ROLE_Authority )
		uuRI,spawnHUD,playAlertSound,toggleHUD,addPMHistoryMsg,authSuccessful,
		buddyInfo,authSuccess,createPlayerListItem,removePlayerListItem,
		pmPanelReceiveMessage,addMsg,fillLookupInfo,showBuddies,
		notifyBeforeLevelChange,forceBind;
}

simulated function clientInitialized()
{
	enableDefaultHUD = bool(client.gc.get("uu_enableDefaultHUD", "True"));

	// Wait until initial replication is complete.
	checksumWaitSince = client.timeSeconds;
	setTimer(1.0, true);
}

simulated function setupControlPanel()
{
	local NexgenPanelContainer container;
	
	//uuGUIClientTab = uu_NexgenGUIClientTab(client.mainWindow.mainPanel.addPanel("Universal Unreal", class'uu_NexgenGUIClientTab', , "client"));
	client.addPluginClientConfigPanel(class'uu_NexgenGUIClientTab');
	container = NexgenPanelContainer(client.mainWindow.mainPanel.getPanel("pluginclientsettings"));
	uuGUIClientTab = uu_NexgenGUIClientTab(container.getPanel("uu_NexgenGUILogin"));

	if(client.hasRight("uuLookup"))
	{
		//uuGUILookupTab = uu_NexgenGUILookupTab(client.mainWindow.mainPanel.addPanel("Universal Lookups", class'uu_NexgenGUILookupTab', , "game"));
		client.mainWindow.mainPanel.addPanel("Universal Lookups", class'NexgenScrollPanelContainer', "uuLookupContainer", "game");
		uuGUILookupTab = uu_NexgenGUILookupTab(client.mainWindow.mainPanel.addPanel("", class'uu_NexgenGUILookupTab', , "game,uuLookupContainer"));
	}
}

simulated function timer()
{
	if(bInfoReceivedCalled && !bAuthSuccessful && credentialsUsername != "" && credentialsPassword != "" && client.playerName != "")
	{
		if(authTimer >= 30)
		{
			authTimer = 0;

			storeUniverseUsername(credentialsUsername);
			sendLoginCredentials(credentialsUsername,credentialsPassword,client.playerName,self);
		}
		else
		{
			authTimer++;
		}
	}

	if(bHUDSpawned && !bHUDTimerDisable)
	{
		// spawn HUD now, as long as NSVHUD isn't enabled
		if(enableDefaultHUD && NSVHUD == None)
		{
			bHUDTimerDisable = true;
			if(uuRI.bHideHUDForGuests)
			{
				if(InStr(credentialsUsername,"PLAYERID:") == -1) // configured client
				{
					toggleHUD();
				}
			}
			else
			{
				toggleHUD();
			}
		}
		// if NSVHUD, give it 6 seconds to display and then take over
		else if(enableDefaultHUD && NSVHUD != None)
		{
			if(hudTimer >= 6)
			{
				hudTimer = 0;
				bHUDTimerDisable = true;
				if(uuRI.bHideHUDForGuests)
				{
					if(InStr(credentialsUsername,"PLAYERID:") == -1) // configured client
					{
						toggleHUD();
					}
				}
				else
				{
					toggleHUD();
				}
			}
			else
			{
				hudTimer++;
			}
		}
	}

	if(!bChecksumFinished)
	{
		if (uuRI != none && uuRI.checksum == uuRI.calcChecksum())
		{
			bChecksumFinished = true;
			infoReceived();
		}
		else if (client.timeSeconds - checksumWaitSince >= checksumMatchTimeout)
		{
			// We're probably not going to receive the anything.
			bChecksumFinished = true;
		}
	}
}

simulated function addPMHistoryMsg(String user, String msg)
{
	if(uuPMPanel != None)
		uuPMPanel.addHistoryMsg(client.lng.format(client.lng.sendMsgTxt, user, msg));
}

simulated function authSuccessful()
{
	bAuthSuccessful = True;
	uuPMPanel = uu_NexgenGUIPrivateMsgTab(client.mainWindow.mainPanel.addPanel("Universal Messaging", class'uu_NexgenGUIPrivateMsgTab', , "client"));
}

simulated function createPlayerListItem(String info)
{
	if(uuPMPanel != None)
		uuPMPanel.createPlayerListItem(info);
}

simulated function removePlayerListItem(String info)
{
	local NexgenSimpleListItem item;

	if((uuPMPanel == None) || len(class'NexgenUtil'.static.trim(info)) == 0)
		return;

	for (item = NexgenSimpleListItem(uuPMPanel.playerList.items); item != none; item = NexgenSimpleListItem(item.next))
	{
		if (CAPS(item.displayText) == CAPS(info))
		{
			item.remove();
			break;
		}
	}
}

simulated function pmPanelReceiveMessage(string msg, string playerName)
{
	if(uuPMPanel != None)
		uuPMPanel.receiveMessage(msg,playername);
}

simulated function spawnHUD()
{
	local Mutator nHUD;

	foreach client.player.AllActors(class'Mutator',nHUD)
	{
		if (InStr(CAPS(nHUD.Class),"NSVHUD") != -1)
		{
			NSVHUD = nHUD;
			break;
		}
	}

	// loads the HUD modifier
	xHUD = spawn(class'uu_HUDModifier', self);

	bHUDSpawned = true;
}

simulated function playAlertSound(int i)
{
	if(i == 255)
	{
		client.player.clientPlaySound(sound'HenryVIII', , true);
		return;
	}

	if(bool(client.gc.get("uu_voiceAlerts", "True")))
	{
		switch(i)
		{
			case 0:
				client.player.clientPlaySound(sound'LoggedIn', , true);
				break;
			case 1:
				client.player.clientPlaySound(sound'NewPrivateMessage', , true);
				break;
			case 2:
				client.player.clientPlaySound(sound'BuddyJoined', , true);
				break;
			case 3:
				client.player.clientPlaySound(sound'LoginFailed', , true);
				break;
			case 4:
				client.player.clientPlaySound(sound'BuddyRequests', , true);
				break;
		}
	}
	else
	{
		client.player.clientPlaySound(Sound(DynamicLoadObject("BotPack.Click", class'Sound')));
	}
}

simulated function toggleHUD()
{
	if (xHUD != None)
	{
		if(hudShowing)
		{
			xHUD.hideHUD();
		}
		else
		{
			if(NSVHUD != None && NSVHUD.getItemName("status") == "show")
			{
				NSVHUD.getItemName("hide");
			}
			xHUD.showHUD();
		}

		hudShowing = !hudShowing;
	}
}

simulated function addMsg(String msg, optional bool bEverywhere)
{
	if(xHUD != None)
	{
		if(bEverywhere)
		{
			client.showMsg("<C09>"$msg);
			UTConsole(client.player.Player.Console).AddString(msg);
			xHUD.addMsg(msg);
		}
		else if(xHUD.animSequence != AS_Stationary)
		{
			client.showMsg("<C09>"$msg);
		}
		else
		{
			UTConsole(client.player.Player.Console).AddString(msg);
			xHUD.addMsg(msg);
		}
	}
}

simulated function exLog(string s,optional bool bDate)
{
	local String preamble;

	if(bDate)
	{
		preamble = "["$GetDate()$"] ";
	}

	if (uuLog != None)
	{
		uuLog.LogEventString(preamble$s);

	}
	else
	{
		if(!bLogging && !bGameEnded)
		{
			StartLog();
			uuLog.LogEventString(preamble$s);
		}
	}
}

simulated function StartLog()
{
	// Open the external log

	uuLog = spawn(class'uu_ExLog');

	if (uuLog != None)
	{
		uuLog.StartLog();
		bLogging=True;
	}
}

simulated function notifyBeforeLevelChange()
{
	if (!bGameEnded && uuLog != None)
	{
		uuLog.StopLog();
		uuLog.Destroy();
		uuLog = None;
		bLogging=False;
		bGameEnded=True;
	}
}

simulated function string GetDate()
{
	local string AbsoluteTime;

	AbsoluteTime = string(Level.Year);
	if (Level.Month < 10)
		AbsoluteTime = AbsoluteTime$"-0"$Level.Month;
	else
		AbsoluteTime = AbsoluteTime$"-"$Level.Month;
	if (Level.Day < 10)
		AbsoluteTime = AbsoluteTime$"-0"$Level.Day;
	else
		AbsoluteTime = AbsoluteTime$"-"$Level.Day;
	if (Level.Hour < 10)
		AbsoluteTime = AbsoluteTime$" 0"$Level.Hour;
	else
		AbsoluteTime = AbsoluteTime$" "$Level.Hour;
	if (Level.Minute < 10)
		AbsoluteTime = AbsoluteTime$":0"$Level.Minute;
	else
		AbsoluteTime = AbsoluteTime$":"$Level.Minute;
	return AbsoluteTime;
}

simulated function fillLookupInfo(int i, String data)
{
	if(uuGUILookupTab == None || len(data) < 1)
		return;

	uuGUILookupTab.createListItem(i,urlSafeDecode(data));
}

simulated function infoReceived()
{
	local String alias, keyName;
	local int iSlot, i;

	spawnHUD();

	uuCM = spawn(class'UniversalUnreal_CredManager.uu_CredentialManager',owner);

	iSlot = getCredentialSlot();

	if(iSlot > -1)
	{
		credentialsUsername = uuCM.userName[iSlot];
		credentialsPassword = uuCM.userPass[iSlot];

		uuGUIClientTab.userName = credentialsUsername;
		uuGUIClientTab.setValues();
	}

	if(credentialsUsername != "" && credentialsPassword != "")
	{
		storeUniverseUsername(credentialsUsername);
		sendLoginCredentials(credentialsUsername,credentialsPassword,client.playerName,self);
	}
	else
	{
		addMsg("This server is part of the"@uuRI.UniverseID@"universe, powered by Universal Unreal");
		addMsg("To enjoy all the benefits of Universal Unreal, please register. It only takes 30 seconds.");
		addMsg("Learn more by saying !ABOUT, and UT will close while starting your web browser");
		client.player.clientPlaySound(Sound(DynamicLoadObject("BotPack.Click", class'Sound')));

		credentialsUsername = "PLAYERID:"$client.player.PlayerReplicationInfo.PlayerID;

		storeUniverseUsername(credentialsUsername);
		sendPlayer(client.playerName,self);
	}

	// check for already bound
	for (i=0; i<255; i++)
	{
		keyName = Owner.ConsoleCommand( "KEYNAME "$i );
		if ( keyName != "" )
		{
			alias = Owner.ConsoleCommand( "KEYBINDING"@keyName );
			if ( CAPS(alias) == "MUTATE UNIVERSALUNREAL TOGGLEHUD")
			{
				//boundKey = CAPS(alias);
				boundKey = keyName;
				break;
			}
		}
	}

	// check to see if F7 is a good idea
	if(boundKey == "")
	{
		alias = Owner.ConsoleCommand( "KEYBINDING F7" );
		if(alias == "")
		{
			Owner.ConsoleCommand("set input F7 mutate universalunreal togglehud");
			boundKey = "F7";
		}
	}

	// check to see if any other function keys work
	if(boundKey == "")
	{
		for(i=1;i<13;i++)
		{
			alias = Owner.ConsoleCommand( "KEYBINDING F" $ i);
			if(alias == "")
			{
				Owner.ConsoleCommand( "set input F" $ i $ " mutate universalunreal togglehud" );
				boundKey = "F" $ i;
				break;
			}
		}
	}

	if(boundKey == "")
	{
		addMsg("Toggle ON/OFF the Universal Unreal HUD by saying !HUD");
	}
	else
	{
		addMsg("Toggle ON/OFF the Universal Unreal HUD with " $ boundKey $ " or by saying !HUD");
	}

	bInfoReceivedCalled = true;
}

simulated function forceBind()
{
	local int i;
	local String keyName, alias;

	// check for already bound
	for (i=0; i<255; i++)
	{
		keyName = Owner.ConsoleCommand( "KEYNAME "$i );
		if ( keyName != "" )
		{
			alias = Owner.ConsoleCommand( "KEYBINDING"@keyName );
			if ( CAPS(alias) == "MUTATE UNIVERSALUNREAL TOGGLEHUD")
			{
				Owner.ConsoleCommand("set input " $ keyName);
				break;
			}
		}
	}

	Owner.ConsoleCommand("set input F7 mutate universalunreal togglehud");
}

function sendLoginCredentials(string username, string password, string playername, uu_NexgenClient uuNC)
{
	S.registerLoginCredentials(username,password,playername,uuNC);
}

function sendPlayer(string playername, uu_NexgenClient uuNC)
{
	S.registerPlayer(playername,uuNC);
}

function storeUniverseUsername(String username)
{
	universeUserName = username;
}

simulated function showBuddies(String data)
{
	local uu_NexgenGUIBuddiesTab buddiesTab;
	
	// Get tab.
	buddiesTab = uu_NexgenGUIBuddiesTab(client.mainWindow.mainPanel.getPanel(class'uu_NexgenGUIBuddiesTab'.default.panelIdentifier));
	if (buddiesTab == none)
	{
		buddiesTab = uu_NexgenGUIBuddiesTab(client.mainWindow.mainPanel.addPanel("Universal Buddies", class'uu_NexgenGUIBuddiesTab', , "client"));
	}
		
	buddiesTab.buddyData = data;
	buddiesTab.loadbuddyList();

	// Show the tab.
	client.showPanel(class'uu_NexgenGUIBuddiesTab'.default.panelIdentifier);
}

simulated function bool saveCredentials(string username, string password)
{
	local int i;
	local string password_hash;

	if(!bInfoReceivedCalled)
	{
		addMsg("Failed to save credentials! Either Universal Unreal is not correctly configured");
		addMsg("or your UT client failed to get data from the UT server properly");
		return false;
	}

	password_hash = class'MD5Hash'.static.MD5String(password);

	i=0;
	while(uuCM.serverID[i]!="" && i < arrayCount(uuCM.serverID))
	{
		if(uuCM.serverID[i]==uuRI.UniverseID)
		{
			uuCM.userName[i] = username;
			if(password == "")
				password_hash = "";
			uuCM.userPass[i] = password_hash;
			credentialsUsername = username;
			credentialsPassword = password_hash;
			break;
		}
		i++;
	}

	if(uuCM.serverID[i]=="")
	{
		if(i==127)
		{
			return true; // config slots were full
		}
		else
		{
			uuCM.serverID[i] = uuRI.UniverseID;
			uuCM.userName[i] = username;
			if(password == "")
				password_hash = "";
			uuCM.userPass[i] = password_hash;
			credentialsUsername = username;
			credentialsPassword = password_hash;
		}
	}

	uuCM.SaveConfig();

	uuGUIClientTab.userName = credentialsUsername;
	uuGUIClientTab.setValues();

	return false; // config slots were not full, so add was successful
}

simulated function bool isValidCharacterString(string input)
{
	local int index;
	local string cs;

	while (index < len(input))
	{
		// Retrieve character to encode.
		cs = mid(input, index, 1);
		
		// Encode character.
		if (("0" <= cs && cs <= "9") || ("a" <= cs && cs <= "z") || ("A" <= cs && cs <= "Z") || (cs == "-") || (cs == "_") || (cs == "~"))
		{
		    // valid character, move to next
		    index++;
		}
		else
		{
		    return False;
		}
	}
	
	return True;
}

simulated function int getCredentialSlot()
{
	local int i;

	i=0;
	while(uuCM.serverID[i]!="" && i < arrayCount(uuCM.serverID))
	{
		if(uuCM.serverID[i]==uuRI.UniverseID)
		{
			return i;
		}
		i++;
	}
	return -1;
}

simulated function string urlSafeDecode(string url)
{
	local int index;
	local string output;
	local string cs;

	while (index < len(url)) {

		cs = mid(url, index, 1);

		if(cs == "@")
		{
			output = output $ chr(int(mid(url, index + 1, 3)));
			index += 4;
		}
		else
		{
			output = output $ cs;
			index++;
		}
	}
	
	return output;
}

defaultproperties
{
   ctrlID="UniversalUnrealNexgenClient"
}
