//=============================================================================
// Universal Unreal
// Version 1.12N Build 1
// June 2009
// Created By Matthew 'MSuLL' Sullivan
//=============================================================================
class uu_MsgHandler extends Mutator;

var UniversalUnreal uuS;

var String mutedCommandsList[7];
var String mutedExceptionsList[6];

function tick(float DeltaTime)
{
	local Mutator R;

	Level.Game.RegisterMessageMutator( Self );
	R = Level.Game.BaseMutator;
	Self.NextMutator = R;
	Level.Game.BaseMutator = Self;

	Disable('tick');
}

function bool mutatorBroadcastMessage(Actor sender, Pawn receiver, out coerce string msg, optional bool bBeep, out optional name type)
{
	local PlayerReplicationInfo senderPRI;
	local bool bIsSpecMessage;

	// Get sender player replication info.
	if (sender != none && sender.isA('Pawn')) 
	{
		senderPRI = Pawn(sender).playerReplicationInfo;
	}

	// Check if we're dealing with a spectator chat message.
	bIsSpecMessage = senderPRI != none && sender.isA('Spectator') &&
	                 left(msg, len(senderPRI.playerName) + 1) ~= (senderPRI.playerName $ ":");
	
	// Check for commands.
	if (bIsSpecMessage && Receiver != none && Receiver.NextPawn == None)
	{
		uuS.handleMessage(PlayerPawn(sender), mid(msg, len(senderPRI.playerName) + 1));
	}

	// check against list to block against
	if(senderPRI != None && blockCommand(mid(msg, len(senderPRI.playerName) + 1)))
	{
		return false;
	}

	// Allow other message mutators to do their job.
	if( NextMessageMutator != None )
		return NextMessageMutator.MutatorBroadcastMessage( Sender, Receiver, Msg, bBeep, Type );
	return false;
}

function bool MutatorTeamMessage( Actor Sender, Pawn Receiver, PlayerReplicationInfo PRI, coerce string msg, name Type, optional bool bBeep )
{
	// Check for commands.
	if (Receiver != none && sender.isA('PlayerPawn') && sender == receiver)
	{
		uuS.handleMessage(PlayerPawn(sender), msg);
	}

	// check against list to block against
	if(blockCommand(msg))
	{
		return false;
	}

	// Allow other message mutators to do their job.
	if ( NextMessageMutator != None )
		return NextMessageMutator.MutatorTeamMessage( Sender, Receiver, PRI, msg, Type, bBeep );
	return true;
}

function bool MutatorBroadcastLocalizedMessage( Actor Sender, Pawn Receiver, out class<LocalMessage> Message, out optional int Switch, out optional PlayerReplicationInfo RelatedPRI_1, out optional PlayerReplicationInfo RelatedPRI_2, out optional Object OptionalObject )
{
	if ( NextMessageMutator != None )
	{
		return NextMessageMutator.MutatorBroadcastLocalizedMessage( Sender, Receiver, Message, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject );
	}
	return true;
}

function bool blockCommand(String cmd)
{
	local int i,k;

	for(i=0;i<ArrayCount(mutedCommandsList);i++)
	{
		// check against list to block against
		if(InStr(CAPS(cmd),mutedCommandsList[i]) != -1)
		{
			// check against allowed exceptions
			for(k=0;k<ArrayCount(mutedExceptionsList);k++)
			{
				if(InStr(CAPS(cmd),mutedExceptionsList[k]) != -1)
				{
					return false; // on exceptions list, don't block
				}
			}
			return true; // not on exceptions, block
		}
	}

	return false; // not on mute list, don't block
}

defaultproperties
{
   mutedCommandsList(0)="!GO"
   mutedCommandsList(1)="!MOREINFO"
   mutedCommandsList(2)="!INFO"
   mutedCommandsList(3)="!WHOAT"
   mutedCommandsList(4)="!WHOSAT"
   mutedCommandsList(5)="!UNIVERSALUNREAL"
   mutedCommandsList(6)="!PM "
   mutedExceptionsList(0)="!GO "
   mutedExceptionsList(1)="!GOTHERE "
   mutedExceptionsList(2)="!INFO "
   mutedExceptionsList(3)="!MOREINFO "
   mutedExceptionsList(4)="!WHOAT "
   mutedExceptionsList(5)="!WHOSAT "
}
