//=============================================================================
// Universal Unreal
// Version 1.12N Build 1
// June 2009
// Created By Matthew 'MSuLL' Sullivan
//=============================================================================
class uu_HUDModifier extends Mutator;

var uu_NexgenClient xClient;            // The client that is displaying the player list.


var color standardTextColor;               // Color of the text displayed above a player list.
var color headlineTextColor;               // Color of the text displayed above a player list.

var bool bInitialSetupDone;             // Whether the HUD has been setup.
var float lastClipX;                    // Last known horizontal screen resolution.
var float lastClipY;                    // Last known vertical screen resolution.

var font baseFont;                      // The font used to render the player lists.
var float baseFontHeight;               // Height of the used font.

var int totalWidth;                     // Total width of the player list window.
var int totalHeight;                    // Total height of the player list window.

var float animTimeStart;                // Time at which the animation has started.
var enum EAnimSequence 
{                                       // Animation sequence type.
	AS_SlideIn,                         // Slide in effect.
	AS_Stationary,                      // Stationary on the screen.
	AS_SlideOut,                        // Slide out effect.
	AS_Hidden                           // Not displayed on the screen.
} animSequence;                         // Current animation sequence to use.

var String uuMsgs[3];
var int uuMsgsTime[3];

const lineDistance = 1;                 // Distance between lines.
const borderSize = 2;                  // Border size of the player list window.
const animSlideInTime = 1.0;            // Amount of time it takes to complete the slide in effect.
const animSlideOutTime = 0.5;           // Amount of time it takes to complete the slide out effect.

function postBeginPlay()
{
	xClient = uu_NexgenClient(owner);
	animSequence = AS_Hidden;
}

function showHUD()
{
	animSequence = AS_SlideIn;
	animTimeStart = xClient.client.timeSeconds;
}

function hideHUD()
{
	animSequence = AS_SlideOut;
	animTimeStart = xClient.client.timeSeconds;
}

function tick(float deltaTime)
{
	// Register as HUD mutator if not already done. Note this may fail several times.
	if (!bHUDMutator) registerHUDMutator();
}

function postRender(Canvas c)
{
	// Let other HUD mutators do their job first.
	if (nextHUDMutator != none)
	{
		nextHUDMutator.postRender(c);
	}

	// Render own stuff.
	if (animSequence == AS_Hidden)
	{
		return;
	}

	setup(c);
	renderPlayerList(c);
}

function string getItemName(string cmd)
{
	switch(cmd)
	{
		case "show": // Show the stats.
			showHUD();
			break;
		
		case "hide": // Hide the stats.
			hideHUD();
			break;
		
		case "status": // Return visibility status of stats.
			if (animSequence == AS_Stationary)
			{
				return "show";
			}
			else
			{
				return "hide";
			}
			break;
	}
	return "";
}

function setup(Canvas c)
{
	local bool bNeedsSetup;
	local float cw, ch;
	local int index;
	
	// Check if the HUD should be setup.
	bNeedsSetup = lastClipX != c.clipX || lastClipY != c.clipY || !bInitialSetupDone;
	
	// Setup the HUD only if necessary.
	if (bNeedsSetup)
	{
		// Save updated variables.
		bInitialSetupDone = true;
		lastClipX = c.clipX;
		lastClipY = c.clipY;
		
		// Set base variables.
		baseFont = ChallengeHUD(c.viewport.actor.myHUD).myFonts.getStaticSmallestFont(c.clipX);
		c.font = baseFont;
		c.strLen("TEST", cw, baseFontHeight);

		//percent of screen desired inside the float() conversion
		totalWidth = int((float(15)/100) * c.ClipX);
		totalHeight = int((float(60)/100) * c.ClipY);
	}
}

function addMsg(String msg)
{
	local int index;

	uuMsgs[0] = uuMsgs[1]; uuMsgsTime[0] = uuMsgsTime[1];
	uuMsgs[1] = uuMsgs[2]; uuMsgsTime[1] = uuMsgsTime[2];

	uuMsgs[2] = msg;
	uuMsgsTime[2] = xClient.client.timeSeconds + 16;
}

function renderPlayerList(Canvas c)
{
	local int baseX, baseY;
	local int cx, cy;
	local int index;
	local int count;
	local int rank;
	local int playerNum;
	local float cw, ch;
	local color lineCol;
	local Texture scoreChangeIcon;
	local float animIndex;
	local String strToWrite;
	
	// Determine base position.
	if (animSequence == AS_SlideIn)
	{
		animIndex = (xClient.client.timeSeconds - animTimeStart) / animSlideInTime;
		if (animIndex > 1.0)
		{
			animSequence = AS_Stationary;
			animIndex = 1.0;
		}
		baseX = animIndex * (borderSize + totalWidth) - totalWidth;
	}
	else if (animSequence == AS_SlideOut)
	{
		animIndex = 1.0 - (xClient.client.timeSeconds - animTimeStart) / animSlideOutTime;
		if (animIndex > 1.0)
		{
			animSequence = AS_Hidden;
			animIndex = 1.0;
		}
		baseX = animIndex * (borderSize + totalWidth) - totalWidth;
	}
	else
	{
		baseX = borderSize;
	}
	baseY = (c.clipY - totalHeight) / 2.0;
	
	baseX += borderSize;
	baseY += borderSize;
	
	// Render player lists.
	c.font = baseFont;
	c.style = ERenderStyle.STY_Normal;

	c.drawColor = standardTextColor;

	for (index = 0; index < 3; index++)
	{
		if(uuMsgsTime[index] < xClient.client.timeSeconds)
		{
			uuMsgsTime[index] = 0;
			uuMsgs[index] = "";
		}

		c.setPos(baseX, baseY + cy);

		if(uuMsgs[index] != "")
			c.drawText(uuMsgs[index], false);

		cy += baseFontHeight + lineDistance;
	}

	cy += baseFontHeight + lineDistance;

	if(xClient.authSuccess)
	{
		// Render buddy list title.
		c.drawColor = headlineTextColor;
		c.setPos(baseX, baseY + cy);
		c.drawText("Buddies Currently Online", false);
	}

	cy += baseFontHeight + lineDistance;
	c.drawColor = standardTextColor;

	for (index = 0; index < 13; index++)
	{
		c.setPos(baseX, baseY + cy);

		if(xClient.authSuccess && index == 0 && xClient.buddyInfo[index] == "")
		{
			c.drawText("None", false);
		}
		else if(xClient.buddyInfo[index] != "")
		{
			c.drawText((index + 1)$". "$xClient.buddyInfo[index], false);
		}
		cy += baseFontHeight + lineDistance;
	}

	cy += baseFontHeight + lineDistance + int((float(xClient.uuRI.ServerListYOffset)/100) * c.ClipY);

	// Render list title.
	c.drawColor = headlineTextColor;
	c.setPos(baseX, baseY + cy);

	if(xClient.uuRI.serverQuery[0] != "")
		c.drawText("Populated Servers", false);

	cy += baseFontHeight + lineDistance;
	c.drawColor = standardTextColor;

	for (index = 0; index < arrayCount(xClient.uuRI.serverQuery); index++)
	{
		c.setPos(baseX, baseY + cy);

		if(xClient.uuRI.serverQuery[index] != "")
			c.drawText((index + 1)$". "$xClient.uuRI.serverQuery[index], false);

		cy += baseFontHeight + lineDistance;
	}
}

defaultproperties
{
   standardTextColor=(R=250,G=150,B=50,A=0),
   headlineTextColor=(R=150,G=150,B=250,A=0),
   bAlwaysTick=True
}
