//=============================================================================
// Universal Unreal
// Version 1.12N Build 1
// June 2009
// Created By Matthew 'MSuLL' Sullivan
//=============================================================================
class uu_HTTPClient extends UBrowserHTTPClient;

var UniversalUnreal S;

var bool bQueryInProgress;
var string QueryQueue[50];
var string QueryString;

var bool bContinueAtClose;
var bool bSwitchAtClose;
var bool bResolutionRequest;
var bool bReceivedData;
var bool ingoreTick;
var bool NoSendQueue;
var String lastData;

var int Errors;

function CheckAddresses()
{
	if(!bResolutionRequest && S.resolvedAddress == "")
	{
		bResolutionRequest = True;
		bQueryInProgress = True;

		S.debugLog("CheckAddresses() resolvedAddress Blank, Attempting To Resolve...");
		Resolve(S.UniverseHost);
	}
}

event Resolved( IpAddr Addr )
{
	if(bResolutionRequest)
	{
		S.resolvedAddress = IpAddrToString(Addr);

		// strip out port number
		if (InStr(S.resolvedAddress,":") != -1)
			S.resolvedAddress = Left(S.resolvedAddress,InStr(S.resolvedAddress,":"));

		S.xxLog(S.UniverseHost@"has been resolved to"@S.resolvedAddress);
		S.SaveConfig();

		bResolutionRequest = False;
		bQueryInProgress = False;

		SendQueue();
	}
	else
	{
		Super.Resolved(Addr);
	}
}

event ResolveFailed()
{
	if(bResolutionRequest)
	{
		S.xxLog("Error while resolving"@S.UniverseHost@"to an IP. Please manually set the value of 'resolvedAddress' to the universe host's IP in the configuration, and set 'bNeverPurgeAddress' to True");
		S.bDisableCommunications=True;

		Destroy();
	}
	else
	{
   	SetTimer(0.0, false);
   	SetError(-4);
	}
}

function SendData(string data)
{
   local UniversalUnreal control;

   if(S == None)
   {
		foreach allActors(class'UniversalUnreal', control)
		{
			S = control;
			break;
		}
   }

   if(DataInQueue(data))
      return;// "!Waiting in queue";
   else if(InStr(QueryString, data) != -1)
      return;// "!Resolving now";
   else
   {
      if(QueryQueue[49] != "")
         return;// "!Queue full";
      else
      {
         AddToQueue(data);
         SendQueue();
         return;// "!Added to queue";
      }
   }
}

function string GetIP()
{
    local IPAddr IPAddr;

    GetLocalIP(IpAddr);
    return IpAddrToString(IPAddr);
}

function HTTPReceivedData(string data)
{
	local string atc[6];
	local int i;
	local NexgenSimpleListItem item;
	local uu_NexgenClient uuNC;

	Super.SetTimer(0.0, false); // disable the timeout count

	bReceivedData = true;

	// only parse stuff that we consider new
	if(lastData == data)
	{
		S.debugLog("HTTPReceivedData() Data Not New, Skipping");
		return;
	}
	else // otherwise update what is considered 'new'
	{
		lastData = data;
	}

	S.debugLog("HTTPReceivedData("$data$","$NoSendQueue$") Enter");

	if(InStr(data,"!!!return-data!!!") != -1)
	{
		if (InStr(data,"&") != -1)
		data = Mid(data,InStr(data,"&")+1);

		if (InStr(data,"&") != -1)
		data = Left(data,InStr(data,"&"));

		atc[0]=left(data,InStr(data,"#"));
		for(i=0;InStr(data,"#")!=-1;i++)
		{
			data=right(data,Len(data)-InStr(data,"#")-1);
			atc[i+1]=left(data,InStr(data,"#"));
		}
		atc[i]=data;

		uuNC = S.uu_GetClientByUniverseName(atc[1]);

		switch(atc[0])
		{
			case "universe-server-login":
				if(atc[1] == "accepted")
				{
					S.xxLog("UT Server has logged into the"@ S.UniverseID @"universe.");
					if(atc[2] == "1")
					{
						S.allowLocalLookup = True;
					}
					if(atc[3] == "1")
					{
						S.allowUniversalLookup = True;
					}
				}
				else if(atc[1] == "denied")
				{
					S.xxLog(S.UniverseID @"universe has denied this server's login. Universal Unreal will now unload.");
					S.bDisableCommunications=True;
					Destroy();
				}
				else if(atc[1] == "version")
				{
					S.xxLog(S.UniverseID @"universe has denied this server's login because of a version conflict.");
					S.xxLog("Web component version is " $ S.versionFormat(atc[2]) $ " while this UT server version is " $ S.pluginVersion $ " Build " $ S.Build);
					S.xxLog("Visit the following website for offical releases:" @ S.urlSafeDecode(atc[3]));
					S.bDisableCommunications=True;
					Destroy();
				}
				else
				{
					S.xxLog("UT Server received unexpected data from the"@ S.UniverseID @"universe.");
					S.xxLog("Error occured while trying to login server:"@data);
					S.xxLog("Universal Unreal will now disable its communication to the universe.");
					S.bDisableCommunications=True;
					Destroy();
				}
			break;
			case "universe-player-login":
				if(atc[2] == "accepted")
				{
					if(uuNC != None)
					{
						uuNC.authSuccess = true;
						uuNC.authSuccessful();

						// this user has buddy requests waiting?
						if(atc[3] != "none")
						{
							uuNC.addMsg("You have one or more unanswered buddy requests.",True);
							uuNC.playAlertSound(4);
							uuNC.showBuddies(atc[3]);
						}
						else
						{
							uuNC.addMsg("You have been successfully logged into the"@ S.UniverseID @"universe.",True);
							uuNC.playAlertSound(0);
						}

						if(atc[4] != "none")
						{
							atc[4] = S.urlSafeDecode(atc[4]);

							S.addBuddyInfo(uuNC, left(atc[4],InStr(atc[4],":::")));
							for(i=0;InStr(atc[4],":::")!=-1;i++){
								atc[4]=right(atc[4],Len(atc[4])-InStr(atc[4],":::")-3);
								S.addBuddyInfo(uuNC, left(atc[4],InStr(atc[4],":::")));
							}
							S.addBuddyInfo(uuNC, atc[4]);
						}
					}
				}
				else if(atc[2] == "denied")
				{
					if(uuNC != None)
					{
						uuNC.addMsg(S.UniverseID @"universe has denied your login. Possible causes could include",True);
						uuNC.addMsg("that you have entered an incorrect or unregistered username or password",True);

						uuNC.playAlertSound(3);
					}
				}
				else
				{
					if(uuNC != None)
					{
						S.xxLog("UT Server received unexpected data from the"@ S.UniverseID @"universe.");
						S.xxLog("Error occured while trying to login user"@ uuNC.universeUserName$":"@data);

						uuNC.addMsg("Received unexpected data from the"@ S.UniverseID @"universe.",True);
						uuNC.addMsg("Your login was not completed successfully.",True);
					}
				}
			break;
			case "send-pm-fail":
				if(atc[2] == "not-online")
				{
					if(uuNC != None)
					{
						uuNC.addMsg("The player you are attempting to message is not online at this time.");
					}
				}

			break;
			case "player-lookup-1":
				if(atc[2] != "")
				{
					if(uuNC != None)
					{
						//----------------------------------------------------------------
						uuNC.fillLookupInfo(0,left(atc[2],InStr(atc[2],",")));
						for(i=0;InStr(atc[2],",")!=-1;i++){
							atc[2]=right(atc[2],Len(atc[2])-InStr(atc[2],",")-1);
							uuNC.fillLookupInfo(0,left(atc[2],InStr(atc[2],",")));
						}
						uuNC.fillLookupInfo(0,atc[2]);
						//----------------------------------------------------------------
					}
				}
			break;
			case "player-lookup-2":
				if(atc[2] != "")
				{
					if(uuNC != None)
					{
						//----------------------------------------------------------------
						uuNC.fillLookupInfo(1,left(atc[2],InStr(atc[2],",")));
						for(i=0;InStr(atc[2],",")!=-1;i++){
							atc[2]=right(atc[2],Len(atc[2])-InStr(atc[2],",")-1);
							uuNC.fillLookupInfo(1,left(atc[2],InStr(atc[2],",")));
						}
						uuNC.fillLookupInfo(1,atc[2]);
						//----------------------------------------------------------------
					}
				}
			break;
			case "player-lookup-3":
				if(atc[2] != "")
				{
					if(uuNC != None)
					{
						//----------------------------------------------------------------
						uuNC.fillLookupInfo(2,left(atc[2],InStr(atc[2],",")));
						for(i=0;InStr(atc[2],",")!=-1;i++){
							atc[2]=right(atc[2],Len(atc[2])-InStr(atc[2],",")-1);
							uuNC.fillLookupInfo(2,left(atc[2],InStr(atc[2],",")));
						}
						uuNC.fillLookupInfo(2,atc[2]);
						//----------------------------------------------------------------
					}
				}
			break;
			case "player-lookup-4":
				if(atc[2] != "")
				{
					if(uuNC != None)
					{
						//----------------------------------------------------------------
						uuNC.fillLookupInfo(3,left(atc[2],InStr(atc[2],",")));
						for(i=0;InStr(atc[2],",")!=-1;i++){
							atc[2]=right(atc[2],Len(atc[2])-InStr(atc[2],",")-1);
							uuNC.fillLookupInfo(3,left(atc[2],InStr(atc[2],",")));
						}
						uuNC.fillLookupInfo(3,atc[2]);
						//----------------------------------------------------------------
					}
				}
			break;
/*
			case "player-lookup":
				if(atc[2] != "" && atc[3] != "" && atc[4] != "" && atc[5] != "")
				{
					if(uuNC != None)
					{
						//----------------------------------------------------------------
						uuNC.fillLookupInfo(0,left(atc[2],InStr(atc[2],",")));
						for(i=0;InStr(atc[2],",")!=-1;i++){
							atc[2]=right(atc[2],Len(atc[2])-InStr(atc[2],",")-1);
							uuNC.fillLookupInfo(0,left(atc[2],InStr(atc[2],",")));
						}
						uuNC.fillLookupInfo(0,atc[2]);
						//----------------------------------------------------------------
						uuNC.fillLookupInfo(1,left(atc[3],InStr(atc[3],",")));
						for(i=0;InStr(atc[3],",")!=-1;i++){
							atc[3]=right(atc[3],Len(atc[3])-InStr(atc[3],",")-1);
							uuNC.fillLookupInfo(1,left(atc[3],InStr(atc[3],",")));
						}
						uuNC.fillLookupInfo(1,atc[3]);
						//----------------------------------------------------------------
						uuNC.fillLookupInfo(2,left(atc[4],InStr(atc[4],",")));
						for(i=0;InStr(atc[4],",")!=-1;i++){
							atc[4]=right(atc[4],Len(atc[4])-InStr(atc[4],",")-1);
							uuNC.fillLookupInfo(2,left(atc[4],InStr(atc[4],",")));
						}
						uuNC.fillLookupInfo(2,atc[4]);
						//----------------------------------------------------------------
						uuNC.fillLookupInfo(3,left(atc[5],InStr(atc[5],",")));
						for(i=0;InStr(atc[5],",")!=-1;i++){
							atc[5]=right(atc[5],Len(atc[5])-InStr(atc[5],",")-1);
							uuNC.fillLookupInfo(3,left(atc[5],InStr(atc[5],",")));
						}
						uuNC.fillLookupInfo(3,atc[5]);
						//----------------------------------------------------------------
					}
				}

			break;
*/
			case "brief-info":
				S.uuRI.serverQuery[0]=left(atc[1],InStr(atc[1],":::"));
				for(i=0;InStr(atc[1],":::")!=-1;i++){
					atc[1]=right(atc[1],Len(atc[1])-InStr(atc[1],":::")-3);
					S.uuRI.serverQuery[i+1]=left(atc[1],InStr(atc[1],":::"));
				}
				S.uuRI.serverQuery[i]=atc[1];

				S.uuRI.checksum = S.uuRI.calcChecksum();
			break;
		}
	}
	else
	{
		Data = "";
	}

 	QueryString="";
	bQueryInProgress=False;

	if(!NoSendQueue)
		SendQueue();

	NoSendQueue = False;
}

event Opened()
{
   S.debugLog("Opened() Enter");
   ingoreTick = False;
   Enable('Tick');

   if(ProxyServerAddress != "")
      SendBufferedData("GET http://"$ServerAddress$":"$string(ServerPort)$ServerURI$" HTTP/1.1"$CR$LF);
   else
      SendBufferedData("GET "$ServerURI$" HTTP/1.1"$CR$LF);
   SendBufferedData("Connection: close"$CR$LF);
   SendBufferedData("Host: "$S.UniverseHost$":"$S.UniversePort$CR$LF);
   SendBufferedData("User-Agent: Mozilla/5.0 (Universal Unreal)"$CR$LF$CR$LF);

   CurrentState = WaitingForHeader;
   S.debugLog("Opened() Exit");
}

function SwitchQueryServer()
{
   S.debugLog("SwitchQueryServer() Enter");

   bQueryInProgress=False;

   if(++Errors > S.ErrorLimit)
   {
      if(!bReceivedData && !S.bNeverPurgeAddress)
      {
			S.xxLog("No data was received during the last session; will attempt to re-resolve"@S.UniverseHost@"upon HTTP client reload.");
			S.resolvedAddress = "";
			S.SaveConfig();
      }
      S.restartHTTPClient();
   }
   else
   {
      ServerIpAddr.Addr=0; // ensures that the Browse() function will open a connection to a new address
   }

   S.debugLog("SwitchQueryServer() Exit");
}

// override original function to silence the warning log
function DoBind()
{
   if( BindPort() == 0 )
   {
      SetError(-2);
      return;
   }
   Open( ServerIpAddr );
   bClosed = False;
}

function SetError(int code)
{
   Super.SetError(code);

   switch(code)
   {
      case -1:
         S.xxLog("Error in binding the port while connecting to "$S.UniverseHost);
         break;
      case -2:
         S.xxLog("Error while resolving the host "$S.UniverseHost);
         break;
      case -3:
         S.xxLog(""$S.UniverseHost$" timed out after "$string(S.MaxTimeout)$" seconds");
         break;
      case -4:
         S.xxLog("Error resolving to the host of the IP for the domain "$S.UniverseHost);
         break;
      default:
         S.xxLog("Server received HTTP error with code "$string(code)$" from "$S.UniverseHost);
   }
    // sometimes the connection doesn't break immediately, it is probably due to some bug in UBrowserHTTPClient, if it happens we have to wait for it inside event Closed() cause we cannot open the same socket if it is already opened
   if(IsConnected())
   {
      S.debugLog("SetError() 'IsConnected()' is True, setting bSwitchAtClose=True");
      bSwitchAtClose=True;
   }
   else
   {
      S.debugLog("SetError() 'IsConnected()' is False, Switching Query Server and Sending Que");
      SwitchQueryServer();
      SendQueue();
   }
}

event Closed()
{
   S.debugLog("Closed() Enter");

   Super.Closed();
   bQueryInProgress=False;


   if(bSwitchAtClose)
   {
      NoSendQueue = True;
      HTTPReceivedData(InputBuffer);

      bSwitchAtClose=False;
      SwitchQueryServer();
      SendQueue();
   }
   else if(bContinueAtClose)
   {
      NoSendQueue = True;
      HTTPReceivedData(InputBuffer);

      bContinueAtClose=False;
      bQueryInProgress=False;
      SendQueue();
   }

   S.debugLog("Closed() Exit");
}

function SendQueue()
{
   local int i,bb;

   CheckAddresses();

   if(IsConnected())
      bContinueAtClose=True;

   if(bQueryInProgress || (QueryQueue[0] == "" && QueryString == ""))
      return;

   // this thing pulls the entry QueryQueue[0] and then puts slot [2] into [1],
   // and slot [1] into [0], etc (moves the array up so another entry is in 0)

   QueryString = QueryQueue[0];

   for(i=0;i<ArrayCount(QueryQueue) - 1;i++)
   {
      QueryQueue[i] = QueryQueue[i+1];
   }

   bQueryInProgress=True;

   S.debugLog("SendQueue() Browse:"@QueryString);
   Browse(S.resolvedAddress,QueryString,S.UniversePort,S.MaxTimeout);
}

function AddToQueue(string data)
{
   local int i;

   if(InStr(QueryString, data) != -1)
   {
      return;
   }

   for(i=0;i<ArrayCount(QueryQueue);i++)
   {
      if(QueryQueue[i]!="")
         continue;
      QueryQueue[i] = data;
      S.debugLog("Data added to queue slot " $ i);
      if(!bQueryInProgress)
         SendQueue();
      break;
   }
}

function bool DataInQueue(string data)
{
   local int i;
   local string host;

   for(i=0;i<ArrayCount(QueryQueue);i++)
   {
      if(QueryQueue[i] == data)
         return true;
   }
   return false;
}

event Tick(float deltaTime)
{
	Super.Tick(deltaTime);

	if(ingoreTick)
		return;

	if(InStr(InputBuffer,"<!--EOL-->") != -1)
	{
		S.debugLog("Tick() 'End of Line' Signal Detected, Closing Connection");
		ingoreTick = True;

		Close();
	}
}

defaultproperties
{
   RemoteRole=ROLE_None
}
