//=============================================================================
// Universal Unreal
// Version 1.12N Build 1
// September 2011
// Created By Matthew 'MSuLL' Sullivan ( edited by Letylove49)
//=============================================================================
class UniversalUnreal extends NexgenPlugin config (system);

var config string UniverseID;
var config string UniversePass;
var config string UniverseHost;
var config string UniverseFilePath;
var config int UniversePort;
var config string ServerURL;
var config int TCPServerPort;
var config string ShortServerName;
var config bool bDisableDuringMatchMode;
var config bool bHideHUDForGuests;
var config int ServerListYOffset;
var config string UniverseAboutURL;
var config bool CollectPlayerData;
var config int MaxTimeout;
var config int ErrorLimit;
var config string resolvedAddress;
var config bool bNeverPurgeAddress;
var config bool bDebug;

var uu_WebServer WebServ;
var uu_HTTPClient uuHTTP;
var uu_ReplicationInfo uuRI;

var bool uuHTTPStarted;
var bool bDisableCommunications;
var int briefUniverseInfoTimer;
var int numHTTPRestarts;
var bool allowLocalLookup;
var bool allowUniversalLookup;

var int Build;

function bool initialize()
{
	local UniversalUnreal UUMut;
	local string ServerPackages, ServerActors;

	// Protect against more than 1 instance
	ForEach Level.AllActors(class'UniversalUnreal',UUMut)
	{
		if(UUMut != Self)
			return false;
	}

	if(TCPServerPort == 0)
	{
		TCPServerPort = Level.Game.GetServerPort();
	}

	SaveConfig();

	Log("##############################");
	Log("#      Universal Unreal      #");
	Log("#        Version "$pluginVersion$"        #");
	Log("#        Final Build "$Build$"       #");
	Log("#          By MSuLL          #");
	Log("##############################");

	if(Level.NetMode != NM_DedicatedServer)
	{
		xxLog("Sorry, but Universal Unreal must be run from a dedicated server setup!");
		xxLog("Universal Unreal will now automatically unload...");
		return false;
	}

	ServerPackages = CAPS(ConsoleCommand("get ini:Engine.Engine.GameEngine ServerPackages"));

	// valid for checking anything in the version 1 release naming convention
	if(InStr(ServerPackages,"UNIVERSALUNREAL1") == -1)
	{
		xxLog("Universal Unreal ServerPackage entry not found!");
		xxLog("Universal Unreal will now automatically unload...");
		return false;
	}
	else if(InStr(ServerPackages,"UNIVERSALUNREAL_CREDMANAGER") == -1)
	{
		xxLog("Universal Unreal Credentials ServerPackage entry not found!");
		xxLog("Universal Unreal will now automatically unload...");
		return false;
	}

	// Checks so that morons won't kill their servers because they didn't read the instructions
	UniverseHost = class'NexgenUtil'.static.replace(UniverseHost,"http://", "");

	if(UniverseID == "" || UniversePass == "" || UniverseHost == "" || UniversePort < 1)
	{
		xxLog("Sorry, but Universal Unreal's configuration is not correct!");
		xxLog("Please check the server's configuration file!");
		xxLog("Universal Unreal is automatically unloading...");
		return false;
	}

	// Load replication info.
	uuRI = spawn(class'uu_ReplicationInfo', self);
	uuRI.UniverseID = UniverseID;
	uuRI.bHideHUDForGuests = bHideHUDForGuests;
	uuRI.ServerListYOffset = ServerListYOffset;
	uuRI.checksum = uuRI.calcChecksum();

	control.sConf.addRightDefiniton("uuLookup", "Perform UU Master Lookups.");

	initHTTPFunctions();

	WebServ = spawn(Class'uu_WebServer',self);
	spawn(Class'uu_MsgHandler').uuS = Self;

	httpCmd("&operation=universelogin&version=" $ class'NexgenUtil'.static.replace(pluginVersion,".","") $ PadTwo(Build) $ "&gamesession=" $ right(Level.Year,2)$right("0"$Level.Month,2)$right("0"$Level.Day,2)$right("0"$Level.Hour,2)$right("0"$Level.Minute,2)$right("0"$Level.Second,2));

	// We get brief info about servers every 45 secs, so already have
	// 30 seconds counted so there's only 15 sec left till first query
	briefUniverseInfoTimer = 30;

	xxLog("Initialization Complete");

	return true;
}

function notifyBeforeLevelChange()
{
	local uu_NexgenClient uuNC;

	ForEach AllActors(class'uu_NexgenClient',uuNC)
	{
		uuNC.notifyBeforeLevelChange();
	}
}

function debugLog(String str)
{
	if(!bDebug)
		return;

	Log("[Universal Unreal][Debug]["$GetTimeStr()$"]"@str);
}

function xxLog(String str)
{
	Log("[Universal Unreal]["$GetTimeStr()$"]"@str);
}

function string GetTimeStr()
{
  local string Mon, Day, Min;

  Min = string( Level.Minute );
  if( int( Min ) < 10 ) Min = "0" $ Min;

  switch( Level.month )
  {
    case  1: Mon = "Jan"; break;
    case  2: Mon = "Feb"; break;
    case  3: Mon = "Mar"; break;
    case  4: Mon = "Apr"; break;
    case  5: Mon = "May"; break;
    case  6: Mon = "Jun"; break;
    case  7: Mon = "Jul"; break;
    case  8: Mon = "Aug"; break;
    case  9: Mon = "Sep"; break;
    case 10: Mon = "Oct"; break;
    case 11: Mon = "Nov"; break;
    case 12: Mon = "Dec"; break;
  }

  switch( Level.dayOfWeek )
  {
    case 0: Day = "Sunday";    break;
    case 1: Day = "Monday";    break;
    case 2: Day = "Tuesday";   break;
    case 3: Day = "Wednesday"; break;
    case 4: Day = "Thursday";  break;
    case 5: Day = "Friday";    break;
    case 6: Day = "Saturday";  break;
  }

  return Day @ Level.Day @ Mon @ Level.Year $ "," @ Level.Hour $ ":" $ Min;
}

function mutate(string mutateString, PlayerPawn sender)
{
	local String nameStr, workerStr;
	local uu_NexgenClient uuNC;

	uuNC = uu_GetClient(sender);

	if(CAPS(mutateString) == "UNIVERSALUNREAL TOGGLEHUD")
	{
		uuNC.toggleHUD();
	}
	else if(InStr(CAPS(mutateString),"UNIVERSALUNREAL PM")!=-1)
	{
		workerStr = Mid(mutateString,InStr(CAPS(mutateString),"UNIVERSALUNREAL PM")+19);

		nameStr = Left(workerStr, InStr(workerStr," "));
		workerStr = Mid(workerStr,InStr(workerStr," ")+1);

		uuNC.addMsg("Sending private message to"@nameStr);
		httpCmd("&operation=sendpm&to=" $ urlSafeReplace(nameStr) $ "&from=" $ urlSafeReplace(uuNC.UniverseUserName) $ "&msg=" $ urlSafeReplace(class'NexgenUtil'.static.replace(workerStr," ","+")));
	}
	else if(InStr(CAPS(mutateString),"UNIVERSALUNREAL LOOKUP")!=-1)
	{
		if(!uuNC.client.hasRight("uuLookup"))
		{
			return;
		}

		// workerStr = selected player's client ID
		workerStr = Mid(mutateString,InStr(CAPS(mutateString),"UNIVERSALUNREAL LOOKUP")+23);

		nameStr = Left(workerStr, InStr(workerStr," "));
		workerStr = Mid(workerStr,InStr(workerStr," ")+1);

		if(CAPS(nameStr) == "LOCAL" && !allowLocalLookup)
		{
			uuNC.addMsg("Sorry, but the"@UniverseID@"Universe does not allow local lookups from this server.");
			return;
		}
		else if(CAPS(nameStr) == "UNIVERSAL" && !allowUniversalLookup)
		{
			uuNC.addMsg("Sorry, but the"@UniverseID@"Universe does not allow universal lookups from this server.");
			return;
		}

		uuNC.addMsg("Requesting lookup from"@UniverseID@"Universe, please wait.");
		httpCmd("&operation=lookup&segment=1&scope=" $ nameStr $ "&clientid=" $ urlSafeReplace(workerStr) $ "&username=" $ urlSafeReplace(uuNC.UniverseUserName));
		httpCmd("&operation=lookup&segment=2&scope=" $ nameStr $ "&clientid=" $ urlSafeReplace(workerStr) $ "&username=" $ urlSafeReplace(uuNC.UniverseUserName));
		httpCmd("&operation=lookup&segment=3&scope=" $ nameStr $ "&clientid=" $ urlSafeReplace(workerStr) $ "&username=" $ urlSafeReplace(uuNC.UniverseUserName));
		httpCmd("&operation=lookup&segment=4&scope=" $ nameStr $ "&clientid=" $ urlSafeReplace(workerStr) $ "&username=" $ urlSafeReplace(uuNC.UniverseUserName));
	}
	else if(InStr(CAPS(mutateString),"UNIVERSALUNREAL ACCEPTBUDDY")!=-1)
	{
		workerStr = Mid(mutateString,InStr(CAPS(mutateString),"UNIVERSALUNREAL ACCEPTBUDDY")+28);

		httpCmd("&operation=buddyaction&value=accept&buddyid=" $ workerStr $ "&username=" $ urlSafeReplace(uuNC.UniverseUserName));
	}
	else if(InStr(CAPS(mutateString),"UNIVERSALUNREAL DENYBUDDY")!=-1)
	{
		workerStr = Mid(mutateString,InStr(CAPS(mutateString),"UNIVERSALUNREAL DENYBUDDY")+26);

		httpCmd("&operation=buddyaction&value=deny&buddyid=" $ workerStr $ "&username=" $ urlSafeReplace(uuNC.UniverseUserName));
	}
}

function virtualTimer()
{
	if(briefUniverseInfoTimer >= 45)
	{
		httpCmd("&operation=briefinfo");
		briefUniverseInfoTimer = 0;
	}
	else
	{
		briefUniverseInfoTimer++;
	}
}

function restartHTTPClient()
{
	debugLog("restartHTTPClient() Enter");

	uuHTTP.Destroy();
	uuHTTPStarted = False;

	if(numHTTPRestarts < 4)
	{
		xxLog("Too many HTTP errors in one session, HTTP client restarting.");
		initHTTPFunctions();
		numHTTPRestarts++;	
	}
	else
	{
		xxLog("Too many HTTP client restarts in one session, HTTP functions disabled.");
	}

	debugLog("restartHTTPClient() Exit");
}

function initHTTPFunctions()
{
	debugLog("initHTTPFunctions() Enter");

	if(!uuHTTPStarted)
	{
		uuHTTP = Spawn(class'uu_HTTPClient');
		uuHTTPStarted = true;
	}
	
	if(ServerURL == "")
	{
		ServerURL = uuHTTP.GetIP();
		ServerURL = Left(ServerURL, InStr(ServerURL, ":") + 1);
		ServerURL = ServerURL $ Level.Game.GetServerPort();
		SaveConfig();
	}

	debugLog("initHTTPFunctions() Exit");
}

function ProcessGetFromWebserver(string data)
{
	local string atc[8],ptc[32];

	local int i, pi, bb;
	local uu_NexgenClient uuNC;
	local Pawn P;

	debugLog("ProcessGetFromWebserver("$data$") Enter");

	atc[0]=left(data,InStr(data,":::"));
	for(i=0;InStr(data,":::")!=-1;i++)
	{
		data=right(data,Len(data)-InStr(data,":::")-3);
		atc[i+1]=left(data,InStr(data,":::"));
	}
	atc[i]=data;

	if(urlSafeDecode(atc[0]) != UniverseID || atc[1] != UniversePass)
	{
		// wrong universe username or password
		return;
	}

	switch (atc[2])
	{
		case "processlogout":
			// atc3=universe name that left
			if(atc[3] != "")
			{
				ptc[0]=left(atc[3],InStr(atc[3],","));
				for(i=0;InStr(atc[3],",")!=-1;i++)
				{
					atc[3]=right(atc[3],Len(atc[3])-InStr(atc[3],",")-1);
					ptc[i+1]=left(atc[3],InStr(atc[3],","));
				}
				ptc[i]=atc[3];

				for(i=0;i<32;i++)
				{
					if(ptc[i]=="")
						break;

					ForEach AllActors(class'uu_NexgenClient',uuNC)
					{
						removeBuddyInfo(uuNC, ptc[i]);
					}
				}
			}
		break;
		case "alertbuddy":
			// atc3=target names, atc4=buddy name, atc5=current alias, atc6=servername, atc7=serverip
			if(atc[3] != "" && atc[4] != "" && atc[5] != "" && atc[6] != "" && atc[7] != "")
			{
				uuNC = uu_GetClientByUniverseName(atc[3]);

				// buddy is on here
				if(uuNC != None)
				{
					atc[5] = urlSafeDecode(atc[5]);

					uuNC.lastNotedServerName = atc[6];
					uuNC.lastNotedServerURL = atc[7];

					if(CAPS(atc[6]) == CAPS(ShortServerName))
					{
						uuNC.addMsg("Your buddy"@atc[4]@"just joined this server as"@atc[5]);
					}
					else
					{
						uuNC.addMsg("Your buddy"@atc[4]@"just joined"@atc[6]@"as"@atc[5]);
						uuNC.addMsg("To go to"@atc[6]@"now, say !go, or for live match details say !info");
					}

					addBuddyInfo(uuNC, atc[4]@"(as "$atc[5]$") @"@atc[6]);
					uuNC.playAlertSound(2);
				}
			}
		break;
		case "sendmatchinfo":
			// atc3=server to give data to, atc4=return to target
			if(atc[3] != "" && atc[4] != "")
			{
				httpCmd("&operation=returnquerydata&returnto=" $ atc[3] $ "&username=" $ atc[4] $ "&map=" $ urlSafeReplace(Left(string(Level), InStr(string(Level), "."))) $ "&numplayers=" $ level.game.numPlayers $ "&maxplayers=" $ level.game.maxPlayers);
			}
		break;
		case "sendwhoatinfo":
			// atc3=server to give data to, atc4=return to target
			if(atc[3] != "" && atc[4] != "")
			{
				atc[5] = "";

				for(P=level.pawnlist; P!=none ; P=P.nextpawn)
				{
					if(P.IsA('PlayerPawn') && !P.IsA('MessagingSpectator') && P.PlayerReplicationInfo != None)
					{
						atc[5] = atc[5] $ P.PlayerReplicationInfo.PlayerName $ ", ";
					}
				}
				atc[5] = Left(atc[5],len(atc[5])-2);

				httpCmd("&operation=returnwhoatdata&returnto=" $ atc[3] $ "&username=" $ atc[4] $ "&players=" $ urlSafeReplace(atc[5]));
			}
		break;
		case "sendbriefinfo":

			atc[3] = "";

			for(P=level.pawnlist; P!=none ; P=P.nextpawn)
			{
				if(P.IsA('PlayerPawn') && !P.IsA('MessagingSpectator') && P.PlayerReplicationInfo != None)
				{
					atc[3] = atc[3] $ P.PlayerReplicationInfo.PlayerName $ ",";
				}
			}
			atc[3] = Left(atc[3],len(atc[3])-1);

			httpCmd("&operation=returnbriefinfo&map=" $ urlSafeReplace(Left(string(Level), InStr(string(Level), "."))) $ "&numplayers=" $ level.game.numPlayers $ "&maxplayers=" $ level.game.maxPlayers $ "&players=" $ urlSafeReplace(atc[3]));
		break;
		case "receivematchinfo":
			// atc3=server data came from, atc4=return to target, atc5=map, atc6=numplayers, atc7=maxplayers
			if(atc[3] != "" && atc[4] != "")
			{
				uuNC = uu_GetClientByUniverseName(atc[4]);

				// target is on here
				if(uuNC != None)
				{
					atc[5] = urlSafeDecode(atc[5]);

					if(atc[3] == "notfound")
					{
						uuNC.lastNotedServerName = "";
						uuNC.lastNotedServerURL = "";

						uuNC.addMsg("Error: Given name is not a recognized server name in this universe");
						uuNC.client.player.ClientReliablePlaySound(Sound(DynamicLoadObject("BotPack.Click", class'Sound')));
					}
					else if(atc[3] == "servers")
					{
						uuNC.addMsg("Universe Servers:"@atc[5]);
						uuNC.client.player.ClientReliablePlaySound(Sound(DynamicLoadObject("BotPack.Click", class'Sound')));
					}
					else
					{
						uuNC.lastNotedServerURL = atc[3];

						uuNC.addMsg(atc[3]$" is currently hosting"@atc[5]@"with"@atc[6]$"/"$atc[7]);
						uuNC.addMsg("Say !go to travel to that server now");
						uuNC.client.player.ClientReliablePlaySound(Sound(DynamicLoadObject("BotPack.Click", class'Sound')));
					}
				}
			}
		break;
		case "receivewhoatinfo":
			// atc3=server data came from, atc4=return to target, atc5=players

			if(atc[3] != "" && atc[4] != "")
			{
				uuNC = uu_GetClientByUniverseName(atc[4]);

				// target is on here
				if(uuNC != None)
				{
					atc[5] = urlSafeDecode(atc[5]);

					uuNC.lastNotedServerURL = atc[3];

					uuNC.addMsg(atc[3]$"'s players:"@atc[5]);
					uuNC.addMsg("Say !go to travel to that server now");
					uuNC.client.player.ClientReliablePlaySound(Sound(DynamicLoadObject("BotPack.Click", class'Sound')));
				}
			}
		break;
		case "receivegothereinfo":
			// atc3=return to target, atc4=translated server from name to IP
			if(atc[3] != "" && atc[4] != "")
			{
				uuNC = uu_GetClientByUniverseName(atc[3]);

				// target is on here
				if(uuNC != None)
				{
					if(InStr(atc[4],"://")!=-1) // what the hell? Hacking attempt...?
						return;

					uuNC.client.clientCommand("open"@atc[4]);
				}
			}
		break;
		case "receivepm":
			// atc3=return to target, atc4=from server ,atc5=from, atc6=msg
			if(atc[3] != "" && atc[4] != "" && atc[5] != "" && atc[6] != "")
			{
				uuNC = uu_GetClientByUniverseName(atc[3]);

				// target is on here
				if(uuNC != None)
				{
					atc[5] = urlSafeDecode(atc[5]);
					atc[6] = urlSafeDecode(atc[6]);

					if(!checkForBuddyInfo(uuNC, atc[5]))
					{
						if(CAPS(atc[4]) == "WEBSITE")
							addBuddyInfo(uuNC, atc[5]@"(as "$atc[5]$") @ Website");
						else
							addBuddyInfo(uuNC, atc[5]@"(not buddies) @"@atc[4]);
					}

					uuNC.addMsg("[Universe PM]"@atc[5]@"(at"@atc[4]$"):"@atc[6]);
					uuNC.pmPanelReceiveMessage(atc[6],atc[5]);

					uuNC.playAlertSound(1);
				}
			}
		break;
	}

	debugLog("ProcessGetFromWebserver() Exit");
}

function registerLoginCredentials(string username, string password, string playername, uu_NexgenClient uuNC)
{
	local String playerIP;
	local String clientID;

	debugLog("registerLoginCredentials("$username@password@playername$") Enter");

	if(CollectPlayerData)
	{
		playerIP = getIPFromClient(uuNC);
		clientID = uuNC.client.playerID;
	}
	else
	{
		playerIP = "censored";
		clientID = "censored";
	}

	httpCmd("&operation=login&collectplayerdata=" $ CollectPlayerData $ "&username=" $ username $ "&password=" $ password $ "&playername=" $ urlSafeReplace(playername) $ "&clientid=" $ clientID $ "&playerip=" $ playerIP);

	debugLog("registerLoginCredentials() Exit");
}

function registerPlayer(string playername, uu_NexgenClient uuNC)
{
	if(!CollectPlayerData)
		return;

	debugLog("registerPlayer("$playername$") Enter");

	httpCmd("&operation=registerplayer&playername=" $ urlSafeReplace(playername) $ "&clientid=" $ uuNC.client.playerID $ "&playerip=" $ getIPFromClient(uuNC));

	debugLog("registerPlayer() Exit");
}

function string getIPFromClient(uu_NexgenClient uuNC)
{
	local int i;
	local String PlayerIP;

	PlayerIP = uuNC.client.player.GetPlayerNetworkAddress();
	i = InStr(PlayerIP, ":");
	if (i != -1)
		PlayerIP = Left(PlayerIP, i);

	return PlayerIP;
}

function gameStarted()
{
	if(control.sConf.matchModeActivated && bDisableDuringMatchMode)
	{
		bDisableCommunications = true;
	}
}

function httpCmd(string cmd)
{
	debugLog("httpCmd("$cmd$") Enter");

	if(uuHTTPStarted && !bDisableCommunications)
	{
		uuHTTP.SendData(UniverseFilePath $ "?universalunreal=true&universeid=" $ urlSafeReplace(UniverseID) $ "&universepass=" $ UniversePass $ "&thisserver=" $ ServerURL $ cmd);
	}

	debugLog("httpCmd() Exit");
}

function playerLeft(NexgenClient client)
{
	local uu_NexgenClient uuNC;

	uuNC = uu_GetClient(PlayerPawn(client.Owner));

	if(uuNC.authSuccess)
		httpCmd("&operation=logout&username=" $ urlSafeReplace(uuNC.UniverseUserName));

	uuNC.Destroy();
}

function uu_NexgenClient uu_GetClient(PlayerPawn P)
{
	local uu_NexgenClient client;

	ForEach AllActors(class'uu_NexgenClient',client)
	{
		if(PlayerPawn(client.client.Owner) == P)
			return client;
	}

	return None;
}

function uu_NexgenClient uu_GetClientByPlayerID(int ID)
{
	local uu_NexgenClient client;

	ForEach AllActors(class'uu_NexgenClient',client)
	{
		if(PlayerPawn(client.client.Owner).PlayerReplicationInfo != None &&
		 PlayerPawn(client.client.Owner).PlayerReplicationInfo.PlayerID == ID)
			return client;
	}

	return None;
}

function uu_NexgenClient uu_GetClientByUniverseName(string universeUserName)
{
	local uu_NexgenClient client;

	ForEach AllActors(class'uu_NexgenClient',client)
	{
		if(CAPS(client.universeUserName) == CAPS(universeUserName))
		{
			return client;
		}
		// not found? could be a playerID name
		else if(Left(CAPS(universeUserName), InStr(CAPS(universeUserName), ":")) == "PLAYERID:")
		{
			if(int(Mid(CAPS(universeUserName),InStr(CAPS(universeUserName),"PLAYERID:")+9)) == client.client.player.PlayerReplicationInfo.PlayerID)
			{
				return client;
			}
		}
	}

	return None;
}

//function bool handleMsgCommand(PlayerPawn sender, string msg)
function handleMessage(PlayerPawn sender, string msg)
{
	local String cmd, swCmd;
	local String workerStr, nameStr;
	local uu_NexgenClient uuNC;

	cmd = class'NexgenUtil'.static.trim(msg);
	swCmd = CAPS(cmd);

	uuNC = uu_GetClient(sender);

	if(uuNC.universeUserName == "")
	{
		return;
	}

	if(swCmd == "!GOTHERE" || swCmd == "!GO")
	{		if(uuNC.lastNotedServerURL != "")
		{
			// what the hell? Hacking attempt...?
			if(InStr(uuNC.lastNotedServerURL,"://")!=-1)
				return;

			uuNC.client.showMsg("<C09>Now connecting to"@uuNC.lastNotedServerName@"("$uuNC.lastNotedServerURL$")");
			uuNC.client.clientCommand("open"@uuNC.lastNotedServerURL);
		}
		else
		{
			uuNC.client.showMsg("<C09>No buddies have joined universe servers since your login.");
		}
	}
	else if(swCmd == "!MOREINFO" || swCmd == "!INFO")
	{
		if(uuNC.lastNotedServerURL != "")
		{
			uuNC.client.showMsg("<C09>Requesting info for"@uuNC.lastNotedServerName@"("$uuNC.lastNotedServerURL$")");
			httpCmd("&operation=query&server=" $ uuNC.lastNotedServerURL $ "&username=" $ urlSafeReplace(uuNC.UniverseUserName));
		}
		else
		{
			uuNC.client.showMsg("<C09>No buddies have joined universe servers since your login.");
		}
	}
	else if(swCmd == "!WHOAT" || swCmd == "!WHOSAT")
	{
		if(uuNC.lastNotedServerURL != "")
		{
			uuNC.client.showMsg("<C09>Requesting info for"@uuNC.lastNotedServerName@"("$uuNC.lastNotedServerURL$")");
			httpCmd("&operation=whoat&server=" $ uuNC.lastNotedServerName $ "&username=" $ urlSafeReplace(uuNC.UniverseUserName));
		}
		else
		{
			uuNC.client.showMsg("<C09>No buddies have joined universe servers since your login.");
		}
	}
	else if(swCmd == "!UNIVERSALUNREAL")
	{
		uuNC.client.showMsg("<C09>Universal Unreal"@pluginVersion@"(Final Build "$Build$") by MSuLL");
	}
	else if(swCmd == "!BIND")
	{
		uuNC.forceBind();
		uuNC.client.showMsg("<C09>F7 bound to show/hide Universal Unreal HUD component.");
	}
	else if(swCmd == "!ABOUT")
	{
		if(UniverseAboutURL != "")
		{
			uuNC.client.showMsg("<C09>Attempting to open"@UniverseAboutURL);
			uuNC.client.clientCommand("start"@UniverseAboutURL);
			uuNC.client.clientCommand("exit");
		}
		else
		{
			uuNC.client.showMsg("<C09>The admin has not configured the 'UniverseAboutURL' setting. Operation aborted.");
		}
	}
	else if(swCmd == "!HUD")
	{
		uuNC.toggleHUD();
	}
	else if(swCmd == "!HENRY")
	{
		uuNC.playAlertSound(255);
	}
	else if(InStr(swCmd,"!MOREINFO ") != -1)
	{
		nameStr = Mid(cmd,InStr(swCmd,"!MOREINFO ")+10);

		if(len(nameStr) < 2)
		{
			// resolve a name from a number
			if(int(nameStr) < 10 && int(nameStr) > 0)
			{
				nameStr = Left(uuRI.serverQuery[int(nameStr) - 1],Instr(uuRI.serverQuery[int(nameStr) - 1],":"));
				if(nameStr == "")
				{
					// not a valid number, fail
					uuNC.client.showMsg("<C09>Cannot complete request! Specified number server list entry is empty!");
					return;
				}
			}
		}

		uuNC.lastNotedServerName = nameStr;
		uuNC.client.showMsg("<C09>Requesting info for"@nameStr);
		httpCmd("&operation=queryspecial&server=" $ urlSafeReplace(class'NexgenUtil'.static.replace(nameStr," ","+")) $ "&username=" $ urlSafeReplace(uuNC.UniverseUserName));
	}
	else if(InStr(swCmd,"!GOTHERE ") != -1)
	{
		nameStr = Mid(cmd,InStr(swCmd,"!GOTHERE ")+9);

		if(len(nameStr) < 2)
		{
			// resolve a name from a number
			if(int(nameStr) < 10 && int(nameStr) > 0)
			{
				nameStr = Left(uuRI.serverQuery[int(nameStr) - 1],Instr(uuRI.serverQuery[int(nameStr) - 1],":"));
				if(nameStr == "")
				{
					// not a valid number, fail
					uuNC.client.showMsg("<C09>Cannot complete request! Specified number server list entry is empty!");
					return;
				}
			}
		}

		uuNC.lastNotedServerName = nameStr;
		uuNC.client.showMsg("<C09>Now connecting to"@nameStr);
		httpCmd("&operation=gotherespecial&server=" $ urlSafeReplace(class'NexgenUtil'.static.replace(nameStr," ","+")) $ "&username=" $ urlSafeReplace(uuNC.UniverseUserName));
	}
	else if(InStr(swCmd,"!INFO ") != -1)
	{
		nameStr = Mid(cmd,InStr(swCmd,"!INFO ")+6);

		if(len(nameStr) < 2)
		{
			// resolve a name from a number
			if(int(nameStr) < 10 && int(nameStr) > 0)
			{
				nameStr = Left(uuRI.serverQuery[int(nameStr) - 1],Instr(uuRI.serverQuery[int(nameStr) - 1],":"));
				if(nameStr == "")
				{
					// not a valid number, fail
					uuNC.client.showMsg("<C09>Cannot complete request! Specified number server list entry is empty!");
					return;
				}
			}
		}

		uuNC.lastNotedServerName = nameStr;
		uuNC.client.showMsg("<C09>Requesting info for"@nameStr);
		httpCmd("&operation=queryspecial&server=" $ urlSafeReplace(class'NexgenUtil'.static.replace(nameStr," ","+")) $ "&username=" $ urlSafeReplace(uuNC.UniverseUserName));
	}
	else if(InStr(swCmd,"!GO ") != -1)
	{
		nameStr = Mid(cmd,InStr(swCmd,"!GO ")+4);

		if(len(nameStr) < 2)
		{
			// resolve a name from a number
			if(int(nameStr) < 10 && int(nameStr) > 0)
			{
				nameStr = Left(uuRI.serverQuery[int(nameStr) - 1],Instr(uuRI.serverQuery[int(nameStr) - 1],":"));
				if(nameStr == "")
				{
					// not a valid number, fail
					uuNC.client.showMsg("<C09>Cannot complete request! Specified number server list entry is empty!");
					return;
				}
			}
		}

		uuNC.lastNotedServerName = nameStr;
		uuNC.client.showMsg("<C09>Now connecting to"@nameStr);
		httpCmd("&operation=gotherespecial&server=" $ urlSafeReplace(class'NexgenUtil'.static.replace(nameStr," ","+")) $ "&username=" $ urlSafeReplace(uuNC.UniverseUserName));
	}
	else if(InStr(swCmd,"!PM ") != -1)
	{
		if(!uuNC.authSuccess)
		{
			uuNC.client.showMsg("<C09>You are not logged into Universal Unreal and therefore cannot make use of the !pm command");
			uuNC.client.showMsg("<C09>To learn more about Universal Unreal, say !about, and UT will close while starting your web browser");
			return;
		}

		workerStr = Mid(cmd,InStr(swCmd,"!PM ")+4);
		nameStr = Left(workerStr, InStr(workerStr, " "));
		workerStr = Mid(workerStr,InStr(workerStr," ")+1);

		if(len(nameStr) < 3)
		{
			// resolve a name from a number, hopefully...
			if(int(nameStr) < 14 && int(nameStr) > 0)
			{
				nameStr = CAPS(Left(uuNC.BuddyInfo[int(nameStr) - 1], InStr(uuNC.BuddyInfo[int(nameStr) - 1], " (")));
				if(nameStr == "")
				{
					// not a valid number, fail
					uuNC.client.showMsg("<C09>Cannot send PM! Specified number buddy list entry is empty!");
					return;
				}
			}
			else
			{
				// not a valid number, fail
				uuNC.client.showMsg("<C09>Cannot send PM! Specified number did not correspond to a buddy list entry!");
				return;
			}
		}
		// now we should have the name of the person to PM
		uuNC.client.showMsg("<C09>Sending private message to"@nameStr);
		uuNC.addPMHistoryMsg(nameStr,workerStr);
		httpCmd("&operation=sendpm&to=" $ urlSafeReplace(nameStr) $ "&from=" $ urlSafeReplace(uuNC.UniverseUserName) $ "&msg=" $ urlSafeReplace(class'NexgenUtil'.static.replace(workerStr," ","+")));
	}
	else if(InStr(swCmd,"!WHOAT ") != -1)
	{
		nameStr = Mid(cmd,InStr(swCmd,"!WHOAT ")+7);

		if(len(nameStr) < 2)
		{
			// resolve a name from a number
			if(int(nameStr) < 10 && int(nameStr) > 0)
			{
				nameStr = Left(uuRI.serverQuery[int(nameStr) - 1],Instr(uuRI.serverQuery[int(nameStr) - 1],":"));
				if(nameStr == "")
				{
					// not a valid number, fail
					uuNC.client.showMsg("<C09>Cannot complete request! Specified number server list entry is empty!");
					return;
				}
			}
		}

		uuNC.client.showMsg("<C09>Requesting info for"@nameStr);
		httpCmd("&operation=whoat&server=" $ urlSafeReplace(class'NexgenUtil'.static.replace(nameStr," ","+")) $ "&username=" $ urlSafeReplace(uuNC.UniverseUserName));
	}
	else if(InStr(swCmd,"!WHOSAT ") != -1)
	{
		nameStr = Mid(cmd,InStr(swCmd,"!WHOSAT ")+8);

		if(len(nameStr) < 2)
		{
			// resolve a name from a number
			if(int(nameStr) < 10 && int(nameStr) > 0)
			{
				nameStr = Left(uuRI.serverQuery[int(nameStr) - 1],Instr(uuRI.serverQuery[int(nameStr) - 1],":"));
				if(nameStr == "")
				{
					// not a valid number, fail
					uuNC.client.showMsg("<C09>Cannot complete request! Specified number server list entry is empty!");
					return;
				}
			}
		}

		uuNC.client.showMsg("<C09>Requesting info for"@nameStr);
		httpCmd("&operation=whoat&server=" $ urlSafeReplace(class'NexgenUtil'.static.replace(nameStr," ","+")) $ "&username=" $ urlSafeReplace(uuNC.UniverseUserName));
	}
}

function bool checkForBuddyInfo(uu_NexgenClient uuNC, String info)
{
	local int index;

	if(!uuNC.authSuccess || len(class'NexgenUtil'.static.trim(info)) == 0)
		return false;

	if(InStr(info, " (") != -1)
	{
		info = Left(info, InStr(info, " ("));
	}

	// if buddy name is already on list, return true
	for (index = 0; index < arrayCount(uuNC.buddyInfo); index++)
	{
		if(CAPS(info) == CAPS(Left(uuNC.buddyInfo[index], InStr(uuNC.buddyInfo[index], " ("))))
		{
			return true;
		}
	}

	return false;
}

function notifyEvent(string type, optional string arguments)
{
	local uu_NexgenClient Sender,Receiver;

	if (type == "pm_send")
	{
		Sender = uu_GetClientByPlayerID(int(class'NexgenUtil'.static.getProperty(arguments, "sender")));
		Receiver = uu_GetClientByPlayerID(int(class'NexgenUtil'.static.getProperty(arguments, "receiver")));
		
		// are either the sender or receiver members of this universe?
		if(Sender.authSuccess || Receiver.authSuccess)
		{
			httpCmd("&operation=nexgenpm&senderplayername=" $ urlSafeReplace(Sender.client.playerName) $ "&senderuniversename=" $ urlSafeReplace(Sender.UniverseUserName) $ "&receiverplayername=" $ urlSafeReplace(Receiver.client.playerName) $ "&receiveruniversename=" $ urlSafeReplace(Receiver.UniverseUserName) $ "&message=" $ urlSafeReplace(class'NexgenUtil'.static.getProperty(arguments, "message")));
		}
	}

	if(!CollectPlayerData)
		return;

	Sender = uu_GetClientByPlayerID(int(class'NexgenUtil'.static.getProperty(arguments, "client")));
	Receiver = uu_GetClientByPlayerID(int(class'NexgenUtil'.static.getProperty(arguments, "target")));

	if(Sender == Receiver)
	{
		return; // user performed action on himself, we don't care about it
	}
	else if(type == "player_muted" && bool(class'NexgenUtil'.static.getProperty(arguments, "muted")))
	{
		httpCmd("&operation=nexgenaction&performerid=" $ Sender.client.playerID $ "&performername=" $ urlSafeReplace(Sender.client.playerName) $ "&performerip=" $ getIPFromClient(Sender) $ "&receiverid=" $ Receiver.client.playerID $ "&receivername=" $ urlSafeReplace(Receiver.client.playerName) $ "&receiverip=" $ getIPFromClient(Receiver) $ "&information=" $ urlSafeReplace("Muted"));
	}
	else if(type == "player_name_set")
	{
		httpCmd("&operation=nexgenaction&performerid=" $ Sender.client.playerID $ "&performername=" $ urlSafeReplace(Sender.client.playerName) $ "&performerip=" $ getIPFromClient(Sender) $ "&receiverid=" $ Receiver.client.playerID $ "&receivername=" $ urlSafeReplace(Receiver.client.playerName) $ "&receiverip=" $ getIPFromClient(Receiver) $ "&information=" $ urlSafeReplace("Renamed, from " $ class'NexgenUtil'.static.getProperty(arguments, "oldName") $ " to " $ class'NexgenUtil'.static.getProperty(arguments, "newName")));
	}
	else if(type == "player_kicked")
	{
		httpCmd("&operation=nexgenaction&performerid=" $ Sender.client.playerID $ "&performername=" $ urlSafeReplace(Sender.client.playerName) $ "&performerip=" $ getIPFromClient(Sender) $ "&receiverid=" $ Receiver.client.playerID $ "&receivername=" $ urlSafeReplace(Receiver.client.playerName) $ "&receiverip=" $ getIPFromClient(Receiver) $ "&information=" $ urlSafeReplace("Kicked, reason: " $ class'NexgenUtil'.static.getProperty(arguments, "reason")));
	}
	else if(type == "player_banned")
	{
		httpCmd("&operation=nexgenaction&performerid=" $ Sender.client.playerID $ "&performername=" $ urlSafeReplace(Sender.client.playerName) $ "&performerip=" $ getIPFromClient(Sender) $ "&receiverid=" $ Receiver.client.playerID $ "&receivername=" $ urlSafeReplace(Receiver.client.playerName) $ "&receiverip=" $ getIPFromClient(Receiver) $ "&information=" $ urlSafeReplace("Banned until " $ class'NexgenUtil'.static.getProperty(arguments, "period") $ ", reason: " $ class'NexgenUtil'.static.getProperty(arguments, "reason")));
	}
}

function removeBuddyInfo(uu_NexgenClient uuNC, String info)
{
	local int index, bb;

	if(!uuNC.authSuccess || len(class'NexgenUtil'.static.trim(info)) == 0)
		return;

	if(InStr(info, " (") != -1)
	{
		info = Left(info, InStr(info, " ("));
	}

	// if buddy name is already on list, remove him and move everything up
	for (index = 0; index < arrayCount(uuNC.buddyInfo); index++)
	{
		if(CAPS(info) == CAPS(Left(uuNC.buddyInfo[index], InStr(uuNC.buddyInfo[index], " ("))))
		{
			uuNC.buddyInfo[index]="";
			for(bb=index; bb<arrayCount(uuNC.buddyInfo)-1; bb++){
				if (uuNC.buddyInfo[bb+1] != "") {
					uuNC.buddyInfo[bb]=uuNC.buddyInfo[bb+1];
				}
				else {
					uuNC.buddyInfo[bb]= "";
					break;
				}
			}
			if(index == (arrayCount(uuNC.buddyInfo) - 1))
			{
				uuNC.buddyInfo[index] = "";
			}
		}
	}

	uuNC.removePlayerListItem(info);
}

function addBuddyInfo(uu_NexgenClient uuNC, String info)
{
	local int index;

	if(!uuNC.authSuccess || len(class'NexgenUtil'.static.trim(info)) == 0)
		return;

	// remove any old buddy information first
	removeBuddyInfo(uuNC, info);

	for (index = (arrayCount(uuNC.buddyInfo) - 1); index > 0; index--)
	{
		uuNC.buddyInfo[index] = uuNC.buddyInfo[index-1];
	}
	uuNC.buddyInfo[0] = info;

	uuNC.createPlayerListItem(Left(info, InStr(info, " (")));
}

function clientCreated(NexgenClient client)
{
	local uu_NexgenClient xClient;

	debugLog("clientCreated("$client.playerName$") Enter");

	xClient = uu_NexgenClient(client.addController(class'uu_NexgenClient', self));
	xClient.S = Self;
	xClient.uuRI = uuRI;

	debugLog("clientCreated("$client.playerName$") Exit");
}

function string urlSafeReplace(string url) 
{
	local int index;
	local string cs;
	local string ns;
	local int ascnr;
	local string output;
	
	// Encode each character in the url string.
	while (index < len(url)) {
		// Retrieve character to encode.
		cs = mid(url, index, 1);
		
		// Encode character.
		if (("0" <= cs && cs <= "9") || ("a" <= cs && cs <= "z") || ("A" <= cs && cs <= "Z") ||
		    (cs == "-") || (cs == "_") || (cs == ".") || (cs == "[") || (cs == "]") || (cs == "<") || (cs == ">") ||
			 (cs == "(") || (cs == ")") || (cs == "*") || (cs == "|") || (cs == "~") || (cs == "^") ||
				 (cs == "{") || (cs == "}") || (cs == "$") || (cs == "=") || (cs == ":") || (cs == ";") || (cs == "!") || (cs == "+"))
		{
		    ns = cs;
		}
		else
		{
			ascnr = asc(cs);

			if (ascnr < 0)
				ascnr+=256;

			ns = "@" $ PadThree(ascnr);
		}

		output = output $ ns;
		index++;
	}
	
	// Return URL encoded string
	return output;
}

function string urlSafeDecode(string url)
{
	local int index;
	local string output;
	local string cs;

	while (index < len(url)) 
	{
		cs = mid(url, index, 1);

		if(cs == "@")
		{
			output = output $ chr(int(mid(url, index + 1, 3)));
			index += 4;
		}
		else
		{
			output = output $ cs;
			index++;
		}
	}
	return output;
}

function string PadThree(int i)
{
    if (i<10)
        return "00"$string(i);
    else if (i<100)
        return "0"$string(i);
    else
        return string(i);
}

function string PadTwo(int i)
{
    if (i<10)
        return "0"$string(i);
    else
        return string(i);
}

function string versionFormat(String version)
{
	local string str;

	str = Left(version,1) $ ".";
	str = str $ Mid(version,1);
	str = Left(str,4);
	str = str $ " Build ";
	str = str $ string(int(Mid(version,3)));

	return str;
}

defaultproperties
{
    UniverseHost="www.example.org"
    UniverseFilePath="/universalunreal/utinterface.php"
    UniversePort=80
    shortServerName="My Clanserver"
    CollectPlayerData=True
    MaxTimeout=20
    ErrorLimit=10
    Build=1
    pluginName="Universal Unreal"
    pluginAuthor="MSuLL"
    pluginVersion="1.12N"
}
