<?php
/**
 * Mailer.php
 *
 * The Mailer class is meant to simplify the task of sending
 * emails to users. Note: this email system will not work
 * if your server is not setup to send mail.
 *
 * If you are running Windows and want a mail server, check
 * out this website to see a list of freeware programs:
 * <http://www.snapfiles.com/freeware/server/fwmailserver.html>
 *
 * Written by: Jpmaster77 a.k.a. The Grandmaster of C++ (GMC)
 * Last Updated: August 19, 2004
 */
 
include("phpmailer/class.phpmailer.php");
include("phpmailer/class.smtp.php"); // gets called from main class if not already loaded
 
class Mailer
{
   /**
    * sendWelcome - Sends a welcome message to the newly
    * registered user, also supplying the username and
    * password.
    */
   function sendWelcome($user, $email, $pass){
      //$from = "From: ".EMAIL_FROM_NAME." <".EMAIL_FROM_ADDR.">";
      $subject = "Welcome to the ".UNIVERSE_ID." Universe";
      $body = $user.",<br><br>"
             ."You've just registered an account at the ".UNIVERSE_ID." universe, powered by Universal Unreal.<br>"
			 ."The universe is located at: ".UNIVERSE_URL."<br>"
			 ."The following is your account information:<br><br>"
             ."Username: ".$user."<br>"
             ."Password: ".$pass."<br><br>"
             ."If you ever lose or forget your password, a new "
             ."password will be generated for you and sent to this "
             ."email address, if you would like to change your "
             ."email address you can do so by going to the "
             ."'Account' page after signing in. You are highly "
			 ."encouraged to view the 'Help & How To Use' page so "
			 ."that you can properly configure your Nexgen client "
			 ."and learn more about the types of commands Universal "
			 ."Unreal accepts. You can view this page at:<br>"
			 .UNIVERSE_URL."index.php?p=help<br><br>"
             ."- ".UNIVERSE_ID." Universe Administration";

      return $this->doMail($email,$subject,$body);
   }
   
   function sendBuddyRequest($user, $email, $buddyname){
      $subject = "Buddy Request from ".$buddyname." at the ".UNIVERSE_ID." Universe";
      $body = $user.",<br><br>"
             ."You've just received a new buddy request at the ".UNIVERSE_ID." universe, powered by Universal Unreal.<br>"
			 ."The user that initated this request was: ".$buddyname."<br><br>"
			 ."To accept or deny this request, please login to your "
			 .UNIVERSE_ID." account at:<br>"
			 .UNIVERSE_URL."index.php<br><br>"
             ."- ".UNIVERSE_ID." Universe Administration";

      return $this->doMail($email,$subject,$body);
   }
   
   /**
    * sendNewPass - Sends the newly generated password
    * to the user's email address that was specified at
    * sign-up.
    */
   function sendNewPass($user, $email, $pass){
      $subject = "Your password has been reset at the ".UNIVERSE_ID." Universe";
      $body = $user.",<br><br>"
             ."We've generated a new password for you at your "
             ."request, you can use this new password with your "
             ."username to log in to the ".UNIVERSE_ID." Universe website.<br><br>"
             ."Username: ".$user."<br>"
             ."New Password: ".$pass."<br><br>"
             ."It is recommended that you change your password "
             ."to something that is easier to remember, which "
             ."can be done by going to the 'Account' page "
             ."after signing in to your ".UNIVERSE_ID." Universe account at:<br>"
			 .UNIVERSE_URL."index.php<br><br>"
             ."- ".UNIVERSE_ID." Universe Administration";
             
      return $this->doMail($email,$subject,$body);
   }
   
   function sendHelp($user, $email){
      $subject = "Need help with your ".UNIVERSE_ID." Universe account?";
      $body = $user.",<br><br>"
             ."It's been a week or more since you signed up for your account "
             ."at the ".UNIVERSE_ID." Universe website, but you have "
             ."not yet signed into your account from in-game (inside UT). "
             ."If you need assistance with getting your login credentials "
             ."entered into Nexgen, please visit the 'Help And How To Use' "
			 ."page at:<br>"
			 .UNIVERSE_URL."index.php?p=help<br><br>"
			 ."If you need further assistance, contact the ".UNIVERSE_ID." "
			 ."Universe administrator.<br><br>"
             ."- ".UNIVERSE_ID." Universe Administration";
             
      return $this->doMail($email,$subject,$body);
   }
   
   function sendUpdate($url){
      $subject = "Software update for Universal Unreal available";
      $body = UNIVERSE_ADMIN_NAME.",<br><br>"
             ."A software update is available for Universal Unreal. "
             ."It is important to keep your installation of Universal "
             ."Unreal up to date to ensure server security and stability. "
             ."Learn more and download this recent update at:<br>"
			 .$url."<br><br>"
             ."- ".UNIVERSE_ID." Universe Installation<br>[This Is An Automated Message]";
             
      return $this->doMail(UNIVERSE_ADMIN_EMAIL,$subject,$body);
   }
   
   function doMail($email,$subject,$body)
   {
	$mail = new PHPMailer();
   
    if(SMTP_USE)
	{
		$mail->IsSMTP(); // set mailer to use SMTP
		$mail->SMTPAuth = true; // turn on SMTP authentication
		$mail->Host       = SMTP_HOST;
		$mail->Port       = SMTP_PORT;
		$mail->Username   = SMTP_USERNAME;
		$mail->Password   = SMTP_PASSWORD;
	}
	
	$mail->From       = EMAIL_FROM_ADDR;
	$mail->FromName   = EMAIL_FROM_NAME;
	$mail->Subject    = $subject;
	$mail->AltBody    = str_replace("<br>","\n",$body); //Text Body

	$mail->MsgHTML($body);

	$mail->AddAddress($email,$email);

	$mail->IsHTML(true); // send as HTML

	return $mail->Send();
   }
};

/* Initialize mailer object */
$mailer = new Mailer;
 
?>
