<?php
/**
 * Database Constants - these constants are required
 * in order for there to be a successful connection
 * to the MySQL database. Make sure the information is
 * correct.
 */
define("DB_SERVER", "localhost");
define("DB_USER", "db_user");
define("DB_PASS", "db_pass");
define("DB_NAME", "db_name");

/**
 * The universe name and password; you must give this
 * to participating servers before they can connect to this installation
 */
define("UNIVERSE_ID", "universeid");
define("UNIVERSE_PASS", "universepass");

/**
 * The primary admin of this installation, the name and e-mail
 * address will be displayed to users
 */
define("UNIVERSE_ADMIN_NAME", "someone");
define("UNIVERSE_ADMIN_EMAIL", "someone@somewhere.com");

// you must correctly enter the world-viewable URL to this installation, and it *MUST END IN A FORWARD SLASH!*
define("UNIVERSE_URL", "http://www.mywebsite.com/universalunreal/");

// welcome message on the front page, change to define("PORTAL_MSG", ""); to disable
define("PORTAL_MSG", "Welcome to our new installation of Universal Unreal!");

/**
 * Log Player Data - if you wish to have Universal Unreal
 * save data from participating servers about player
 * joins, administrative actions, etc, set this True
 */
define("LOG_PLAYER_DATA",True);

/**
 * Email Constants - these specify what goes in
 * the from field in the emails that Universal Unreal
 * sends to users
 */
define("EMAIL_FROM_NAME", "My Universe");
define("EMAIL_FROM_ADDR", "myuniverse@mywebsite.com");

/**
 * SMTP Constants - by default, Universal Unreal
 * uses PHP's built-in mail() function for sending e-mail.
 * Should you need to use SMTP for sending mail,
 * set SMTP_USE to True and and fill in
 * the appropriate information.
 */
define("SMTP_USE",False);
define("SMTP_HOST", "mail.myhost.com");
define("SMTP_PORT", 25);
define("SMTP_USERNAME","someuser");
define("STMP_PASSWORD","somepass");

/**
 * Some web server hosting companies don't allow
 * what is called 'url fopen' for their own security.
 * However, this is the primary way that Universal Unreal
 * transmits data. If your host has the cURL libraries
 * installed, Universal Unreal can use these instead.
 * Set QUERY_METHOD to 0 to use url fopen,
 * and if you have issues try setting QUERY_METHOD
 * to 1 to use cURL instead (if installed)
 */
define("QUERY_METHOD",0);

// =========================================================================
// Do not edit below this line unless you know exactly what you are doing!
// =========================================================================





/**
 * Timeout Constants - these constants refer to
 * the maximum amount of time (in minutes) after
 * their last page fresh that a user and guest
 * are still considered active visitors. We
 */
define("USER_TIMEOUT", 5);
define("GUEST_TIMEOUT", 5);

/**
 * Cookie Constants - these are the parameters
 * to the setcookie function call, change them
 * if necessary to fit your website. If you need
 * help, visit www.php.net for more info.
 * <http://www.php.net/manual/en/function.setcookie.php>
 */
define("COOKIE_EXPIRE", 60*60*24*180);  //180 days by default
define("COOKIE_PATH", "/");  //Avaible in whole domain

// Version 110, Build 2 (Version 110, Build 02)
define("BUILD","11002");
?>