//=============================================================================
// Original SplashNotify Copyright PJMODOS (pjmodos@atlas.cz)
// LogoSplashV3 made by [es]Rush
//=============================================================================
class SplashNotify expands SpawnNotify;

var string LogoTexture;
var byte   LogoDrawTime;
var string CaptionLineOne;
var string CaptionLineTwo;
var string CaptionLineThree;
var string CaptionLineFour;
var string IntroSound;
var bool LogoTranslucent;
var string Position;
var string Size;

replication
{
	reliable if(Role==ROLE_Authority)
		LogoTexture,LogoDrawTime,CaptionLineOne,CaptionLineTwo,CaptionLineThree,CaptionLineFour,IntroSound,LogoTranslucent,Position,Size;
}


simulated function PreBeginPlay()
{
	bAlwaysRelevant = true;
	Log("SplashNotify::PreBeginPlay()");
}

simulated function PostNetBeginPlay()
{
	local ChallengeHUD PlayerHUD;

	Log("SplashNotify::PostNetBeginPlay()");
	foreach AllActors(Class'ChallengeHUD',PlayerHUD)
	{
		SpawnNotification(PlayerHUD);
	}
}


/*simulated function Spawned()
{
	local ChallengeHUD PlayerHUD;

	foreach AllActors(Class'ChallengeHUD',PlayerHUD)
	{
		SpawnNotification(PlayerHUD);
	}
}*/


simulated event Actor SpawnNotification(actor Actor)
{
	local SplashHUDMutator tmpHUD;

	Log("SplashNotify::SpawnNotification(1)");
	if (Actor != None)
		{
	Log("SplashNotify::SpawnNotification(2)");
		if (Actor.IsA('HUD') && (HUD(Actor).HUDMutator == None || !HUD(Actor).HUDMutator.IsA('SplashHUDMutator')))
			{
	Log("SplashNotify::SpawnNotification(3)");
			tmpHUD = spawn(class'SplashHUDMutator', Actor);
	Log("SplashNotify::SpawnNotification(4)");
			if (tmpHUD != None)
				{
				tmpHUD.Player = PlayerPawn(Actor.Owner);
	Log("SplashNotify::SpawnNotification(5)");
				tmpHUD.LogoTexture = LogoTexture;
				tmpHUD.LogoDrawTime = LogoDrawTime;
				tmpHUD.CaptionLineOne = CaptionLineOne;
				tmpHUD.CaptionLineTwo = CaptionLineTwo;
				tmpHUD.CaptionLineThree = CaptionLineThree;
				tmpHUD.CaptionLineFour = CaptionLineFour;
				tmpHUD.IntroSound = IntroSound;
				tmpHUD.LogoTranslucent = LogoTranslucent;
				tmpHUD.Position = Position;
				tmpHUD.Size = Size;
	Log("SplashNotify::SpawnNotification(6)");
				if (HUD(Actor).HUDMutator == None)
					HUD(Actor).HUDMutator = tmpHUD;
				else
					{
					tmpHUD.NextHUDMutator = HUD(Actor).HUDMutator;
					HUD(Actor).HUDMutator = tmpHUD;
					}
	Log("SplashNotify::SpawnNotification(7)");
				}
			}
		}

	Log("SplashNotify::SpawnNotification(8)");
	return Actor;
}


defaultproperties
{
    ActorClass=Class'Engine.HUD'
    Texture=None
}
