//=============================================================================
// Original SplashLogoSA Copyright PJMODOS (pjmodos@atlas.cz)
// LogoSplashV3 made by [es]Rush
//=============================================================================
class SplashLogoSA expands Actor config;

var config string LogoTexture;
var config int    LogoDrawTime;
var config string CaptionLineOne;
var config string CaptionLineTwo;
var config string CaptionLineThree;
var config string CaptionLineFour;
var config string IntroSound;
var config string CustomRedFlag;
var config string CustomBlueFlag;
var config bool LogoTranslucent;
var config string Position;
var config string Size;

var Texture FlagTeamTextures[2];
var Texture OrigTextures[2];

function PreBeginPlay()
{
	local SplashNotify s;

	log("LogoSplashV3 by [es]Rush");

	s = spawn(class'SplashNotify');
	s.LogoTexture = LogoTexture;
	s.LogoDrawTime = LogoDrawTime;
	s.CaptionLineOne = CaptionLineOne;
	s.CaptionLineTwo = CaptionLineTwo;
	s.CaptionLineThree = CaptionLineThree;
	s.CaptionLineFour = CaptionLineFour;
	s.IntroSound = IntroSound;
	s.LogoTranslucent = LogoTranslucent;
	s.Position = Position;
	s.Size = Size;

	if(CustomRedFlag!="" && CustomBlueFlag!="")
	{
		FlagTeamTextures[0]=texture(DynamicLoadObject(CustomRedFlag, class'Texture'));
		FlagTeamTextures[1]=texture(DynamicLoadObject(CustomBlueFlag, class'Texture'));
	}

	if(FlagTeamTextures[0] != None && FlagTeamTextures[1] != None && Level.Game.IsA('CTFGame'))
		SetTimer(1.0,True); /* allow some mutators to set their things */
}

simulated function Timer()
{
	local int i;
	local FlagBase Base;
	local CTFReplicationInfo CTFRI;

	foreach AllActors(class'FlagBase',Base)
	{
		if (Base.Skin==OrigTextures[Base.Team])
			Base.Skin = FlagTeamTextures[Base.Team];
		else
			FlagTeamTextures[Base.Team] = Base.Skin;
	}
	CTFRI = CTFReplicationInfo(Level.Game.GameReplicationInfo);
	if (CTFRI!=None)
	{
		for (i=0;i<3;i++)
		{
			if ((CTFRI.FlagList[i]!=None) && (CTFRI.FlagList[i].Skin==OrigTextures[i]))
				CTFRI.FlagList[i].Skin = FlagTeamTextures[i];
		}
		SetTimer(0.0,false);
	}

}

defaultproperties
{
    OrigTextures(0)=Texture'Botpack.Skins.JpflagR'
    OrigTextures(1)=Texture'Botpack.Skins.JpflagB'
    LogoTranslucent=False
    LogoDrawTime=6
    Texture=None
    Position="center,center"
    Size="byself:1.0"
}
