//=============================================================================
// Original SpashHUDMutator Copyright by PJMODOS (pjmodos@atlas.cz)
// LogoSplashV3 made by [es]Rush
//=============================================================================
class SplashHUDMutator expands Mutator;

var PlayerPawn Player;

var bool bDrawSplash;

var string LogoTexture;
var int    LogoDrawTime;
var string CaptionLineOne;
var string CaptionLineTwo;
var string CaptionLineThree;
var string CaptionLineFour;
var string IntroSound;
var string Position;
var string Size;
var float EndScale;
var int PosX, PosY;

var enum EDrawState
	{
	DRAW_BLANK,
	DRAW_FADE_IN,
	DRAW_DISPLAY,
	DRAW_FADE_OUT,
	DRAW_DONE

	} DrawState;

var float DrawTime;
var float DrawTick;
var bool LogoTranslucent;

var texture SplashLogo;
var sound SplashSound;

simulated function PostRender(canvas Canvas)
{
	Super.PostRender(Canvas);

	if (Player != None)
	if (Player.PlayerReplicationInfo != None)
	if (DrawState != DRAW_DONE)
	{
		if (!bDrawSplash)
		{
			Log("Loading texture "$LogoTexture);
			SplashLogo = texture(DynamicLoadObject(LogoTexture, class'Texture'));
			Log("Loading sound "$IntroSound);
			SplashSound = Sound(DynamicLoadObject(IntroSound, class'Sound'));

			if (SplashLogo != None)
			{
				SetEndScale(Canvas);
				PosX = GetPosX(Canvas);
				PosY = GetPosY(Canvas);
				bDrawSplash = True;
				DrawState = EDrawState.DRAW_BLANK;
				DrawTick = 0.0625;
				SetTimer(DrawTick, True);
				if (SplashSound == None)
					Log("SplashLogo: Can't load sound "$IntroSound);
			}
			else
			{
				DrawState = DRAW_DONE;
				Log("SplashLogo: Can't load texture "$LogoTexture);
				if (SplashSound == None)
					Log("SplashLogo: Can't load sound "$IntroSound);
			}
		}
		else if (DrawState != DRAW_DONE)
			DrawSplash(Canvas);
	}
	if (NextHUDMutator != None)
		NextHUDMutator.PostRender(Canvas);

}


simulated function DrawSplash(canvas Canvas)
{
	local font PreviousFont;
	local bool PreviousCenter;
	local color PreviousColor;
	local byte PreviousStyle;
    local float W, H;

	if (DrawState != EDrawState.DRAW_BLANK)
	{
		PreviousCenter = Canvas.bCenter;
		PreviousColor = Canvas.DrawColor;
		PreviousFont = Canvas.Font;
		PreviousStyle = Canvas.Style;
		Canvas.Reset();
		log("Positions"@string(GetPosX(Canvas))@string(GetPosY(Canvas))@EndScale);
		Canvas.SetPos(PosX, PosY);
//		Canvas.SetPos(Canvas.ClipX/2 - SplashLogo.Usize/2, Canvas.ClipY/2 + 25);

		Switch (DrawState)
			{
			case EDrawState.DRAW_FADE_IN :
				Canvas.Style = ERenderStyle.STY_Translucent;
				Canvas.DrawColor.R = 225 * DrawTime;
				Canvas.DrawColor.G = 225 * DrawTime;
				Canvas.DrawColor.B = 225 * DrawTime;
				break;

			case EDrawState.DRAW_DISPLAY :
				if(LogoTranslucent)
					Canvas.Style = ERenderStyle.STY_Translucent;
				else
					Canvas.Style = ERenderStyle.STY_Normal;
				Canvas.DrawColor.R = 225;
				Canvas.DrawColor.G = 225;
				Canvas.DrawColor.B = 225;
				break;

			case EDrawState.DRAW_FADE_OUT :
				Canvas.Style = ERenderStyle.STY_Translucent;
				Canvas.DrawColor.R = 225 - (225 * DrawTime);
				Canvas.DrawColor.G = 225 - (225 * DrawTime);
				Canvas.DrawColor.B = 225 - (225 * DrawTime);
				break;
			}

		Canvas.DrawIcon(SplashLogo, EndScale);

		Canvas.Reset();
		Canvas.bCenter = False;

		Switch (DrawState)
			{
			case EDrawState.DRAW_FADE_IN :
			        Canvas.Style = ERenderStyle.STY_Translucent;
				Canvas.DrawColor.R = 225 * DrawTime;
				Canvas.DrawColor.G = 225 * DrawTime;
				Canvas.DrawColor.B = 225 * DrawTime;
				break;

			case EDrawState.DRAW_DISPLAY :
				Canvas.Style = ERenderStyle.STY_Normal;
				Canvas.DrawColor.R = 225;
				Canvas.DrawColor.G = 225;
				Canvas.DrawColor.B = 225;
				break;

			case EDrawState.DRAW_FADE_OUT :
				Canvas.Style = ERenderStyle.STY_Translucent;
				Canvas.DrawColor.R = 225 - (225 * DrawTime);
				Canvas.DrawColor.G = 225 - (225 * DrawTime);
				Canvas.DrawColor.B = 225 - (225 * DrawTime);
				break;
			}

		Canvas.Font = Canvas.SmallFont;
		Canvas.TextSize(CaptionLineOne,W,H);
        Canvas.SetPos(PosX + int(float(SplashLogo.USize)*EndScale/2.0 - W/2.0), PosY + int(float(SplashLogo.VSize)*EndScale) + 10);
		Canvas.DrawText(CaptionLineOne);
		Canvas.TextSize(CaptionLineTwo,W,H);
		Canvas.SetPos(PosX + int(float(SplashLogo.USize)*EndScale/2.0 - W/2.0), PosY + int(float(SplashLogo.VSize)*EndScale) + 20);
		Canvas.DrawText(CaptionLineTwo);
		Canvas.TextSize(CaptionLineThree,W,H);
		Canvas.SetPos(PosX + int(float(SplashLogo.USize)*EndScale/2.0 - W/2.0), PosY + int(float(SplashLogo.VSize)*EndScale) + 30);
		Canvas.DrawText(CaptionLineThree);
		Canvas.TextSize(CaptionLineFour,W,H);
		Canvas.SetPos(PosX + int(float(SplashLogo.USize)*EndScale/2.0 - W/2.0), PosY + int(float(SplashLogo.VSize)*EndScale) + 40);
		Canvas.DrawText(CaptionLineFour);
/*		Canvas.SetPos(10, 10+SplashLogo.VSize+50);*/

		Canvas.bCenter = PreviousCenter;
		Canvas.DrawColor = PreviousColor;
		Canvas.Font = PreviousFont;
		Canvas.Style = PreviousStyle;
	}
}

function int GetPosX(canvas Canvas)
{
	local string XCode, Instruction, Parameter, Value;

	XCode = SelElem(Position, 1, ",");
	log(XCode);
	if(XCode ~= "center" || XCode == "")
		return Canvas.ClipX/2 - float(SplashLogo.USize)*EndScale/2.0;
	else if(Left(XCode, 5) ~= "left:")
	{
		Parameter = SepRight(XCode);
		if(Right(Parameter, 1) == "%")
		{
			Value = Left(Parameter, len(Parameter)-1);
			return int((float(Value)/100) * Canvas.ClipX);
		}
		else if(Right(Parameter, 2) == "px")
		{
			Value = Left(Parameter, len(Parameter)-2);
			return int(Value);
		}
	}
	else if(Left(XCode, 6) ~= "right:")
	{
		Parameter = SepRight(XCode);
		if(Right(Parameter, 1) == "%")
		{
			Value = Left(Parameter, len(Parameter)-1);
			return Canvas.ClipX - int((float(Value)/100) * Canvas.ClipX) - int(float(SplashLogo.Usize) * EndScale);
		}
		else if(Right(Parameter, 2) == "px")
		{
			Value = Left(Parameter, len(Parameter)-2);
			return Canvas.ClipX - int(Value) * Canvas.ClipX - int(float(SplashLogo.Usize) * EndScale);
		}
	}
}

function int GetPosY(Canvas Canvas)
{
	local string YCode, Instruction, Parameter, Value;

	YCode = SelElem(Position, 2, ",");
	log(YCode);
	if(YCode ~= "center" || YCode == "")
		return Canvas.ClipY/2 - float(SplashLogo.VSize)*EndScale/2.0;
	else if(Left(YCode, 4) ~= "top:")
	{
		Parameter = SepRight(YCode);
		if(Right(Parameter, 1) == "%")
		{
			Value = Left(Parameter, len(Parameter)-1);
			return int((float(Value)/100) * Canvas.ClipY);
		}
		else if(Right(Parameter, 2) == "px")
		{
			Value = Left(Parameter, len(Parameter)-2);
			return int(Value);
		}
	}
	else if(Left(YCode, 7) ~= "bottom:")
	{
		Parameter = SepRight(YCode);
		if(Right(Parameter, 1) == "%")
		{
			Value = Left(Parameter, len(Parameter)-1);
			return Canvas.ClipY - int(((float(Value)/100) * Canvas.ClipY)) - int(float(SplashLogo.Vsize) * EndScale);
		}
		else if(Right(Parameter, 2) == "px")
		{
			Value = Left(Parameter, len(Parameter)-2);
			return Canvas.ClipX - int(Value) - (float(SplashLogo.Vsize) * EndScale);
		}
	}
}

function SetEndScale(canvas Canvas)
{
	local string parameter;
	if(Left(Size, 7) == "byself:")
	{
		EndScale = float(SepRight(Size));
		return;
	}
	else if(Left(Size, 10) == "byscreenx:")
	{
	 	parameter = SepRight(Size);
	 	if(Right(parameter, 1) == "%")
	 		EndScale = (float(Left(parameter, len(parameter)-1))/100.0 * Canvas.ClipX) / float(SplashLogo.Usize);
	 	else
	 		EndScale = (float(parameter) * Canvas.ClipX) / float(SplashLogo.Usize);
	}
	else if(Left(Size, 10) == "byscreeny:")
	{
	 	parameter = SepRight(Size);
	 	if(Right(parameter, 1) == "%")
	 		EndScale = (float(Left(parameter, len(parameter)-1))/100.0 * Canvas.ClipY) / float(SplashLogo.Vsize);
	 	else
	 		EndScale = (float(parameter) * Canvas.ClipY) / float(SplashLogo.Vsize);
	}
	else
		EndScale = 1.0;
}

simulated function Timer()
{
	DrawTime = DrawTime + DrawTick;

	Switch (DrawState)
	{
		case EDrawState.DRAW_BLANK :
			if (DrawTime >= 1.0)
			{
				DrawState = EDrawState.DRAW_FADE_IN;
				DrawTime = 0.0;
			}
			break;
		case EDrawState.DRAW_FADE_IN :
			if (DrawTime >= 1.0)
			{
				DrawState = EDrawState.DRAW_DISPLAY;
				DrawTime = 0.0;
				Player.ClientReliablePlaySound(SplashSound);
			}
			break;
		case EDrawState.DRAW_DISPLAY :
			if (DrawTime >= LogoDrawTime)
			{
				DrawState = EDrawState.DRAW_FADE_OUT;
				DrawTime = 0.0;
			}
			break;
		case EDrawState.DRAW_FADE_OUT :
			if (DrawTime >= 1.0)
			{
				DrawState = EDrawState.DRAW_DONE;
				DrawTime = 0.0;
			}
			break;

		case EDrawState.DRAW_DONE :
			SetTimer(0.0, False);
			SplashLogo = None;
			break;
	}

	Super.Timer();
}

function int ElementsNum(string Str, optional string Char)
{
	local int count, pos;

	if(Char=="")
		Char=":";

	while(true)
	{
		pos = InStr(Str, Char);
		if(pos == -1)
			break;
		Str=Mid(Str, pos+1);
		count++;
	}
	return count+1;
}

function string SelElem(string Str, int Elem, optional string Char)
{
	local int pos;
	if(Char=="")
		Char=":";

	while(Elem>1)
	{
		Str=Mid(Str, InStr(Str, Char)+1);
		Elem--;
	}
	pos=InStr(Str, Char);
	if(pos != -1)
    	Str=Left(Str, pos);
    return Str;
}

function string SepLeft(string Input)
{
	local int pos;

	pos = InStr(Input, ":");
	if(pos != -1)
	{
		return Left(Input, pos);
	}
	else
		return "";
}

function string SepRight(string Input)
{
	local int pos;

	pos = InStr(Input, ":");
	if(pos != -1)
	{
		return Right(Input, len(Input)-pos-1);
	}
	else
		return "";
}

defaultproperties
{
}
