#!/usr/bin/perl

# NOP cgi written by denis moeller, nop@n-o-p.com, www.n-o-p.com

# this script opens the NOP player data file and searches for a playername that
# was either passed via form or argument, it then puts out html-tables with the
# player statistics. the search is a case-sensitive substring-search.

# last update 5 oct 1999

# -----------------------------------------------------------
# ADJUST THE PATH BELOW IF IT DOESN'T FIND THE PATH BY ITSELF
# -----------------------------------------------------------
# don't forget to remove the # after editing:

# $Filename="../nopdata.txt";

print "Content-type: text/html\n\n";
$SearchType = 0;

# get form data
read(STDIN, $Daten, $ENV{'CONTENT_LENGTH'});

$PlayerName = "";

@Formfelder = split(/&/, $Daten);
foreach $Feld (@Formfelder) {
	($fname, $value) = split(/=/, $Feld);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	$value =~ s/,/ /g;

	if ($fname =~ /Player/) {
		$PlayerName=$value;
	}

	if ($fname =~ /Type/) {
		$SortType=$value;
	}

	if ($fname =~ /Game/) {
		$GameFlag=$value;
	}
}

# if the playername isn't passed by a form, check parameters
if ($PlayerName eq "") {
	#$PlayerName="$ENV{QUERY_STRING}";

	foreach (split('&', $ENV{QUERY_STRING})) {
		($name, $value) = split('=', $_);
		$value =~ s!\+! !g; $value =~ s!%(..)!pack('c',hex($1))!eg;
	
		if ($name =~ /Player/) {
			$PlayerName = $value;
			$SearchType = 0;
		}
		
		if ($name =~ /IgnPos/) {
			$IgnPos = $value;
			$SearchType = 0;
		}

	
		if ($name =~ /Type/) {
			$SortType = $value;
			$SearchType = 0;
		}
	
		if ($name =~ /Game/) {
			$GameFlag = $value;
			$SearchType = 0;
		}
	
		if ($name =~ /pos/) {
			$PlayerName = $value;
			$SearchType = 1;
		}
		
		if ($name =~ /type/) {
			$SortType = $value;
			$SearchType = 1;
		}
	}

}

$ref = "$ENV{'HTTP_REFERER'}";

$start = index($ref,"//");
$start = substr($ref, $start+2);
$start = substr($start, index($start, "/"), rindex($start, "/")-index($start, "/"));

if ($Filename eq "") {
	$Filename = "..$start/nopdata.txt";
}

#html head
print "<HTML><HEAD><TITLE>Player stats</TITLE>";
print "<style type=\"text/css\">\n";
print "<!--\n";

# include css file. locate it, open it, read it and put it out
$calling = substr($ref, rindex($ref, "/")+1);		# calling html file
$base = substr($Filename, 0, rindex($Filename, "/"));	# get path from nopdata.txt filename
$calling = "$base/$calling";				# calling html with path
$css = "";

# open html file and read it to find css line
if (open(f1, "<$calling") == false) {
	print "Couldn't open html file \"$calling\".<br>";
} else {
	while (<f1>) {
		$a = $_;
		if ($a =~ /.css/) {
			$a = substr($a, 0, index($a, ".css")+4);
			$css = substr($a, rindex($a, "\"")+1);
			$css = "$base/$css";
			last;
		}
	}
}
close f1;

# open css file and read it line by line
if (open(f1, "<$css") == false) {
	print "Couldn't open style file \"$css\".<br>";
} else {
	while (<f1>) {
		$a = $_;
		print "$a";
	}
}
close f1;

print "\n-->\n";
print "</style>\n";
print "</HEAD>";
print "<BODY id=\"back\" color=#AAAAAA link=#999999 vlink=#AAAAAA>";

#print "$start<br>";
#print "$Filename<br>";

$Found = 0;
$Number = 0;
$PosInFile = 0;

# open file and read it line by line
if (open(f1, "<$Filename") == false) {
	print "<font size=4 color=#AAAAAA><center>Internal error: couldn't open file \"$Filename\", please inform the admin.</font><br><br>\n";
	$Found = 1;
} else {
	while (<f1>) {
		($Player,$Country,$LastSeen,$Game,$Bot,$Frags,$Deaths,$Suicides,$Efficiency,$Skill,$Ping,$TimeMin,$Games,$GamesWon,$Duels,$DuelsWon,$Teams,$Score,$Rank,$TeamFrags,$CTFCaptures,$CTFReturns,$CTFGets,$CTFGames,$Frag[0],$Frag[1],$Frag[2],$Frag[3],$Frag[4],$Frag[5],$Frag[6],$Frag[7],$Frag[8],$Frag[9],$Frag[10],$Frag[11],$Frag[12],$Frag[13],$Frag[14],$Frag[15],$Frag[16],$Frag[17],$Frag[18],$Frag[19],$Frag[20],$Frag[21],$Frag[22],$Frag[23],$Frag[24],$Position[0],$Position[1],$Position[2],$Position[3],$Position[4],$Position[5],$Position[6],$Position[7],$Position[8],$Position[9],$Position[10],$Position[11],$Position[12],$Position[13],$Position[14],$Position[15],$Position[16],$Position[17]) = split(/\"/, $_);

		if ($SearchType == 0) {
			if ($Player =~ /$PlayerName/ && $Game eq $GameFlag) {
				$Found = 1;
				$Number ++;
				if ($Number < 6) {
					&Display;
				}
			}
		} else {
			if ($PosInFile == $PlayerName) {	# check position
				$Found = 1;
				&Display;
				last;
			}
		}
		
		$PosInFile++;
	}
	close f1;
}

if ($Found == 0) {
	print "<center><p>A player with the name \"$PlayerName\" could not be found.</p><br><br>\n";
}

if ($Number > 5) {
	print "<center><p>Too many players found with \"$PlayerName\". Please refine your search.</p><br>\n";
}

# end html file
print "<center><p>nop stats, generated by nop<br>\n";
print "written by denis moeller, 1999 - <a target=_top href=\"http://www.n-o-p.com\">www.n-o-p.com</a><br>\n";
print "</p>\n</body></html>";

sub Display {
	print "<center><table width=450 cellpadding=8 cellspacing=2 border=0>\n";
	print "<tr><td colspan=4 align=\"center\">\n";

	#for ($i=0; $i<12; $i++) { print "$Position[$i] "; }

	if ($Bot==1) {
		$Bot="(BOT)";
	} else {
		$Bot="";
	}

	if ($Position[$SortType] > 0) {
		#print "<font face=\"Arial\" size=2 color=#FFFF00><b>Statistics for No $Position \"$Player\"";
		print "<p id=\"tablefeet\">Statistics for No $Position[$SortType] \"$Player\" $Bot</p>\n";
	} else {
		if ($IgnPos == 1) {
			print "<p id=\"tablefeet\">Statistics for \"$Player\" $Bot</p>\n";
		} else {
			print "<p id=\"tablefeet\">Statistics for \"$Player\" $Bot (not ranked)</p>\n";
		}
	}

	$TotalGames = $Games+$Teams+$Duels;
	$Hours = int($TimeMin / 60);
	$Minutes = $TimeMin % 60;
	$FPG=0;
	$FPH=0;
	
	$CTFPoints = 0;
	if ($CTFGames > 0) { 
		$CTFPoints = ($CTFCaptures * 10 + $CTFReturns * 8 + $CTFGets * 5) / $CTFGames; 
		if (index($CTFPoints,".")>0) { 
			$CTFPoints = substr($CTFPoints,0,index($CTFPoints,"."));
		}
	}
	
	if ($TotalGames > 0) { $FPG = int($Frags / $TotalGames); }
	if ($TimeMin > 0) { $FPH = int($Frags / $TimeMin * 60); }

	print "<tr><td colspan=4 id=\"o\" align=center>\n";
	print "Score: $Score<br>\n";
	print "Last seen $LastSeen at $Country<br>\n";
	
	if ($Game == 4) {
		@Classes = ("Engineer","Spy","Pyro","HWGuy","Medic","Demoman","Soldier","Sniper","Scout","Civilian");
		print "Last class: $Classes[$Frag[24]]\n";
	}
	print "</td></tr>\n";	

	print "<tr><td colspan=4></td></tr>\n";

	print "<tr><td id=\"e\" width=30%% align=right>\n";
	if ($Game==0) {		# quake 3
		print "	Time:<br><br>Games played:<br>Tourneys played:<br>FFA:<br><br>Deaths:<br>Rank:<br><br>Frags:<br>Frags per hour:<br><br>CTF Flag Pickups:<br>CTF Flag Captures:<br>\n";
	} elsif ($Game==1) {	# unreal tournament
		print "	Time:<br><br>Games played:<br>Deathmatch:<br><br>Deaths:<br>Rank:<br><br>Frags:<br>Frags per hour:<br><br>CTF Flag Pickups:<br>CTF Flag Captures:<br>\n";
	} elsif ($Game==2 || $Game==3 || $Game==4) { 	# half life
		print "	Time:<br><br>Games played:<br><br>Deaths:<br>Rank:<br><br>Frags:<br>Frags per hour:<br>\n";
	}
	print "</td>\n";
	
	print "<td id=\"o\" width=20%>\n";
	if ($Game==0) {
		print "	$Hours h $Minutes min<br><br>$TotalGames<br>$Duels<br>$Games<br><br>$Deaths<br>$Rank<br><br>$Frags<br>$FPH<br><br>$CTFGets<br>$CTFCaptures\n";
	} elsif ($Game==1) {
		print "	$Hours h $Minutes min<br><br>$TotalGames<br>$Games<br><br>$Deaths<br>$Rank<br><br>$Frags<br>$FPH<br><br>$CTFGets<br>$CTFCaptures\n";
	} elsif ($Game==2 || $Game==3 || $Game==4) {
		print "	$Hours h $Minutes min<br><br>$TotalGames<br><br>$Deaths<br>$Rank<br><br>$Frags<br>$FPH\n";
	}
	print "</td>\n";	

	print "<td id=\"e\" width=30%% align=right>\n";
	if ($Game==0) {
		print "	Avrg. Ping:<br><br>Games won:<br>Tourneys won:<br>Teamgames / CTF:<br><br>Suicides:<br>Efficiency:<br><br>Teamfrags:<br>Frags per game:<br><br>CTF Flag Returns:<br>CTF Points:<br>\n";
	} elsif ($Game==1) {
		print "	Avrg. Ping:<br><br>Games won:<br>Teamgames / CTF:<br><br>Suicides:<br>Efficiency:<br><br>Teamfrags:<br>Frags per game:<br><br>CTF Flag Returns:<br>CTF Points:<br>\n";
	} elsif ($Game==2 || $Game==3 || $Game==4) {
		print "	Avrg. Ping:<br><br>Games won:<br><br>Suicides:<br>Efficiency:<br><br>Teamfrags:<br>Frags per game:<br>\n";
	}
	print "</td>\n";
	
	$Perc1 = 0; if ($TotalGames>0) { $Perc1 = int($GamesWon/$TotalGames*100); } 
	$Perc2 = 0; if ($Duels>0) { $Perc2 = int($DuelsWon/$Duels*100); }	
	
	print "<td id=\"o\" width=20%>\n";
	if ($Game==0) {
		print "	$Ping<br><br>$GamesWon ( $Perc1 %)<br>$DuelsWon ( $Perc2 %)<br>$Teams / $CTFGames<br><br>$Suicides<br>$Efficiency<br><br>$TeamFrags<br>$FPG<br><br>$CTFReturns<br>$CTFPoints<br>\n";
	} elsif ($Game==1) {
		print "	$Ping<br><br>$GamesWon ( $Perc1 %)<br>$Teams / $CTFGames<br><br>$Suicides<br>$Efficiency<br><br>$TeamFrags<br>$FPG<br><br>$CTFReturns<br>$CTFPoints<br>\n";
	} elsif ($Game==2 || $Game==3 || $Game==4) {
		print "	$Ping<br><br>$GamesWon ( $Perc1 %)<br><br>$Suicides<br>$Efficiency<br><br>$TeamFrags<br>$FPG<br>\n";
	}
	print "</td></tr>\n";
	
	print "<tr><td colspan=4></td></tr>\n";

	print "<td id=\"e\" width=30% align=right>\n";
	
	if ($Game == 0) {
		print "	Gauntlet:<br>Shotgun:<br>Machinegun:<br>Grenade / splash:<br>Rocket / splash:<br>Plasma / splash:<br>Railgun:<br>Lightning:<br>BFG-10k:<br>Telefrags:<br>Unknown:<br>\n";
	} elsif ($Game==1) {
		#print "	Translocator:<br>Impact Hammer:<br>Enforcer / double:<br>Minigun:<br>Pulse Gun:<br>Shock Rifle:<br>Rocket Launcher:<br>Unknown:<br>\n";
		print "	Translocator:<br>Impact Hammer:<br>Chainsaw:<br>Enforcer / double:<br>Minigun:<br>Pulse Gun:<br>Shock Rifle:<br>Rocket Launcher:<br>GES Bio Rifle:<br>Ripper:<br>Flak Cannon:<br>Redeemer:<br>Sniper Rifle:<br>Unknown:<br>\n";
	} elsif ($Game==2) {
		@Weapons = ("Unknown","Magnum","9mmAR","9mmHandGun","Bolt","Crossbow","Crowbar","Gluon Gun","Tau Cannon","Glock","Hand Grenade","Hornet Gun","MP5","RPG","Satchel","Shotgun","Snark","Tripmine");
		for (@Weapons) { print $_,":<br>"; }
	} elsif ($Game==3) {
		@Weapons = ("Unknown","AK-47","AI Arctic Warfare","Desert Eagle","G3/SG-1","Glock18","Knife","FN M249 Para","Benelli M3","Colt M4A1","MP5-Navy","FN P90","Sig SG-552","Steyr TMP","USP");
		for (@Weapons) { print $_,":<br>"; }
	} elsif ($Game==4) {
		@Weapons = ("Unknown","Combat Knife","Crowbar","Assault Cannon","Auto Rifle","Head Shot","Super Nailgun","Nailgun","Super Shotgun","Shotgun","Rocket Launcher","Sniper Rifle","Sentry Gun","Railgun","Flamethrower","Grenade","Pipebomb","Caltrops","Infection","Spanner","Timer","Dispenser");
		for (@Weapons) { print $_,":<br>"; }
	}
	print "</td>\n";
	print "<td id=\"o\" width=20%>\n";
	
	if ($Game < 2) {
		for ($i=0; $i<15; $i++) { $Perc[$i] = 0; }
		
		if ($Game == 0) {
			
			# q3a weapons
			if ($Frag[2]>0 && $Frags+$TeamFrags*2>0) { $Perc[1] = $Frag[2]/($Frags+$TeamFrags*2)*100;  }
			print "$Frag[2]<br>\n";		# gauntlet
			
			if ($Frag[1]>0 && $Frags+$TeamFrags*2>0) { $Perc[2] = $Frag[1]/($Frags+$TeamFrags*2)*100;  }
			print "$Frag[1]<br>\n";		# shotgun
			
			if ($Frag[3]>0 && $Frags+$TeamFrags*2>0) { $Perc[3] = $Frag[3]/($Frags+$TeamFrags*2)*100;  }
			print "$Frag[3]<br>\n";		# machine
			
			if ($Frag[4]+$Frag[5]>0 && $Frags+$TeamFrags*2>0) { $Perc[4] = ($Frag[4]+$Frag[5])/($Frags+$TeamFrags*2)*100; }
			print "$Frag[4] / $Frag[5]<br>\n";	# grenade

			if ($Frag[6]+$Frag[7]>0 && $Frags+$TeamFrags*2>0) { $Perc[5] = ($Frag[6]+$Frag[7])/($Frags+$TeamFrags*2)*100; }
			print "$Frag[6] / $Frag[7]<br>\n";	# rocket

			if ($Frag[8]+$Frag[9]>0 && $Frags+$TeamFrags*2>0) { $Perc[6] = ($Frag[8]+$Frag[9])/($Frags+$TeamFrags*2)*100; }
			print "$Frag[8] / $Frag[9]<br>\n";	# plasma
			
			if ($Frag[10]>0 && $Frags+$TeamFrags*2>0) { $Perc[7] = $Frag[10]/($Frags+$TeamFrags*2)*100; }
			print "$Frag[10]<br>\n";		# rail
			
			if ($Frag[11]>0 && $Frags+$TeamFrags*2>0) { $Perc[8] = $Frag[11]/($Frags+$TeamFrags*2)*100; }
			print "$Frag[11]<br>\n";		# light

			if ($Frag[12]>0 && $Frags+$TeamFrags*2>0) { $Perc[9] = $Frag[12]/($Frags+$TeamFrags*2)*100; }
			print "$Frag[12]<br>\n";		# bfg
			
			if ($Frag[18]>0 && $Frags+$TeamFrags*2>0) { $Perc[10] = $Frag[18]/($Frags+$TeamFrags*2)*100; }
			print "$Frag[18]<br>\n";		# telefrags
		
			if ($Frag[0]>0 && $Frags+$TeamFrags*2>0) { $Perc[11] = $Frag[0]/($Frags+$TeamFrags*2)*100; }
			print "$Frag[0]<br>\n";			# unknown
			
			$WeaponsNum = 12;
		} elsif ($Game==1) {
			
			# unreal tournament weapons
			#0 {"Unknown","Translocator","Impact Hammer","Enforcer","Double Enforcer","Minigun","Pulse Gun",
			#7 "Shock Rifle","Rocket Launcher","GES Bio Rifle","Ripper","Flak Cannon","Redeemer","Chainsaw","Sniper Rifle"};

			if ($Frag[1]>0 && $Frags+$TeamFrags*2>0) { $Perc[1] = $Frag[1]/($Frags+$TeamFrags*2)*100;  }
			print "$Frag[1]<br>\n";		# translocator
			
			if ($Frag[2]>0 && $Frags+$TeamFrags*2>0) { $Perc[2] = $Frag[2]/($Frags+$TeamFrags*2)*100;  }
			print "$Frag[2]<br>\n";		# impact hammer
			
			if ($Frag[13]>0 && $Frags+$TeamFrags*2>0) { $Perc[3] = $Frag[13]/($Frags+$TeamFrags*2)*100;  }
			print "$Frag[13]<br>\n";	# chainsaw
			
			if ($Frag[3]+$Frag[4]>0 && $Frags+$TeamFrags*2>0) { $Perc[4] = ($Frag[3]+$Frag[4])/($Frags+$TeamFrags*2)*100; }
			print "$Frag[3] / $Frag[4]<br>\n";	# enforcer / dbl enforcer
	
			if ($Frag[5]>0 && $Frags+$TeamFrags*2>0) { $Perc[5] = $Frag[5]/($Frags+$TeamFrags*2)*100;  }
			print "$Frag[5]<br>\n";		# minigun
			
			if ($Frag[6]>0 && $Frags+$TeamFrags*2>0) { $Perc[6] = $Frag[6]/($Frags+$TeamFrags*2)*100; }
			print "$Frag[6]<br>\n";		# pulse gun
			
			if ($Frag[7]>0 && $Frags+$TeamFrags*2>0) { $Perc[7] = $Frag[7]/($Frags+$TeamFrags*2)*100; }
			print "$Frag[7]<br>\n";		# shock rifle
			
			if ($Frag[8]>0 && $Frags+$TeamFrags*2>0) { $Perc[8] = $Frag[8]/($Frags+$TeamFrags*2)*100; }
			print "$Frag[8]<br>\n";		# rocket launcher

			if ($Frag[9]>0 && $Frags+$TeamFrags*2>0) { $Perc[9] = $Frag[9]/($Frags+$TeamFrags*2)*100; }
			print "$Frag[9]<br>\n";		# bio rifle
			
			if ($Frag[10]>0 && $Frags+$TeamFrags*2>0) { $Perc[10] = $Frag[10]/($Frags+$TeamFrags*2)*100; }
			print "$Frag[10]<br>\n";	# ripper
			
			if ($Frag[11]>0 && $Frags+$TeamFrags*2>0) { $Perc[11] = $Frag[11]/($Frags+$TeamFrags*2)*100; }
			print "$Frag[11]<br>\n";	# flak cannon
			
			if ($Frag[12]>0 && $Frags+$TeamFrags*2>0) { $Perc[12] = $Frag[12]/($Frags+$TeamFrags*2)*100; }
			print "$Frag[12]<br>\n";	# redeemer
			
			if ($Frag[14]>0 && $Frags+$TeamFrags*2>0) { $Perc[13] = $Frag[14]/($Frags+$TeamFrags*2)*100; }
			print "$Frag[14]<br>\n";	# sniper rifle
			
			if ($Frag[0]>0 && $Frags+$TeamFrags*2>0) { $Perc[14] = $Frag[0]/($Frags+$TeamFrags*2)*100; }
			print "$Frag[0]<br>\n";		# unknown
			
			$WeaponsNum = 15;
		}
		print "</td>\n";
	
		print "<td colspan=2 id=\"o\" align=left>\n";
		for ($k=1; $k<$WeaponsNum; $k++) {	
			if (index($Perc[$k],".")>0) { $Perc[$k] = substr($Perc[$k],0,index($Perc[$k],".")+2); }
			if ($Perc[$k]>100) { $Perc[$k]=100; }
			
			for($i=0; $i<$Perc[$k]; $i+=2) { 
				print "|"; 
			} 
			if ($Perc[$k]>0) { 
				print " $Perc[$k]%<br>\n"; 
			} else {
				print "<br>";
			}
				
		}
	} else {
		$k=0;
		for (@Weapons) {
			print "$Frag[$k]<br>\n";
			$k++;
		}

		print "</td>\n";
		print "<td colspan=2 id=\"o\" align=left>\n";

		$k=0;
		for (@Weapons) {
			$Perc=0;
			if ($Frag[$k]>0 && $Frags+$TeamFrags*2>0) { $Perc = $Frag[$k]/($Frags+$TeamFrags*2)*100;  }
			if (index($Perc,".")>0) { $Perc = substr($Perc,0,index($Perc,".")+2); }
			if ($Perc>100) { $Perc=100; }
			
			for($i=0; $i<$Perc; $i+=2) { 
				print "|"; 
			} 
			if ($Perc>0) { 
				print " $Perc%<br>\n"; 
			} else {
				print "<br>";
			}
			$k++;
		}		
	} 
	print "</td>\n";	

	print "</table><br>";
}

