// Preserves score if player is disconnected from server.  by MrLoathsome
class SS extends Mutator config(ScoreSave);

var int		NumPlyrs;
var string	PlyrList[128];
var float	PlyrScore[128];
var float	PlyrDeaths[128];
var int 	PlyrHealth[128];
var int 	PlyrStartTime[128];
var int 	PlyrDieCount[128];
var int 	PlyrItemCount[128];
var int 	PlyrKillCount[128];
var int 	PlyrSecretCount[128];
var int 	PlyrSpree[128];
var() config float SSDelay;

function PostBeginPlay()
{
	local int i;

	Super.PostBeginPlay();

	for (i=0; i < 128; i++)
	{
		PlyrList[i] = "";
		PlyrScore[i] = 0.0;
		PlyrDeaths[i] = 0.0;
		PlyrHealth[i] = 0;
		PlyrStartTime[i] = 0;
		PlyrDieCount[i] = 0;
		PlyrItemCount[i] = 0;
		PlyrKillCount[i] = 0;
		PlyrSecretCount[i] = 0;
		PlyrSpree[i] = 0;
	}
	NumPlyrs = 0;
	SetTimer(SSDelay, True);
	log("SS Init.....  Delay= "$SSDelay);
}

function Timer()
{
	local int i;
	local PlayerReplicationInfo PRI;

	foreach AllActors(class'PlayerReplicationInfo', PRI)
	{
		if ((!PRI.bIsABot) && (!PRI.bIsSpectator))
			for(i=0; i <= NumPlyrs; i++)
			{
				if (PRI.PlayerName == PlyrList[i])
				{
					PlyrScore[i] = PRI.Score;
					PlyrDeaths[i] = PRI.Deaths;
					PlyrHealth[i] = Pawn(PRI.Owner).Health;
					PlyrDieCount[i] = Pawn(PRI.Owner).DieCount;
					PlyrItemCount[i] = Pawn(PRI.Owner).ItemCount;
					PlyrKillCount[i] = Pawn(PRI.Owner).KillCount;
					PlyrSecretCount[i] = Pawn(PRI.Owner).SecretCount;
					PlyrSpree[i] = Pawn(PRI.Owner).Spree;
				}
			}
	}
}

function ModifyPlayer(Pawn Other)
{
	local TournamentPlayer NewPlayer;
	local int i,j;
	local string PName;
	local PlayerReplicationInfo PRI;

	if ( NextMutator != None )
		NextMutator.ModifyPlayer(Other);
	SetTimer(0.0, False);
	NewPlayer = TournamentPlayer(Other);
	if ((NewPlayer != None) && ((NewPlayer.PlayerReplicationInfo.Score == 0) && (NewPlayer.PlayerReplicationInfo.Deaths == 0)))
	{
		PName = NewPlayer.PlayerReplicationInfo.PlayerName;
		for(i=0; i <= NumPlyrs; i++)
		{
			if (PName == PlyrList[i])
				{
					NewPlayer.PlayerReplicationInfo.Score = PlyrScore[i];
					NewPlayer.PlayerReplicationInfo.Deaths = PlyrDeaths[i];
					NewPlayer.PlayerReplicationInfo.StartTime = PlyrStartTime[i];
					NewPlayer.Health = PlyrHealth[i];
					NewPlayer.DieCount = PlyrDieCount[i];
					NewPlayer.ItemCount = PlyrItemCount[i];
					NewPlayer.KillCount = PlyrKillCount[i];
					NewPlayer.SecretCount = PlyrSecretCount[i];
					NewPlayer.Spree = PlyrSpree[i];
					log("Player returned "$PName$"  Health = "$NewPlayer.Health);
					break;
				}
		}
		if (i > NumPlyrs)
		{
			NumPlyrs++;
			PlyrList[i] = PName;
			PlyrStartTime[i] = NewPlayer.PlayerReplicationInfo.StartTime;
		}
	}
	SetTimer(SSDelay, True);
}

defaultproperties
{
      SSDelay=4.0
}
