//*  Random Spawn Location Mutator -- 2013 MrLoathsome *//
//*  Players & Bots will Spawn at "random" locations *//

class RSL expands Mutator;

var Vector SpawnLocs[4096]; // array of "New" SpawnPoints
var Vector TeamBases[4];
var int SpawnLocCount, TeamCnt;
var float SpBaseDist;

function PostBeginPlay()
{
   local Actor SWtmp;
   local NavigationPoint N;
   local Inventory Inv;
   local Decoration Deco;
   local Ambientsound AmbS;
   local Light Lb;
   local vector L;

	Super.PostBeginPlay();
	N = Level.NavigationPointList;
	While ((SWtmp == None) && (N != NONE))
	{
		SWtmp = spawn(class'UnrealShare.SteelBarrel',,,N.Location);
		N = N.NextNavigationPoint;
	}
	SWtmp.SetCollisionSize(17, 39);
	SWtmp.bCollideWhenPlacing = True;

	for (N = Level.NavigationPointList; N != NONE; N = N.NextNavigationPoint)
	{
	   if ((N.IsA('PathNode') || N.IsA('SpawnPoint') || N.IsA('PlayerStart')) || N.IsA('InventorySpot') || N.IsA('FlagBase'))
		if ((!N.Region.Zone.bWaterZone) && (!N.Region.Zone.bPainZone) && (!N.Region.Zone.bKillZone) && (!N.Region.Zone.bDestructive) && (!N.Region.Zone.IsA('SkyZoneInfo')))
		{
			if (SpawnLocCount <= 4095)
			{
				L = N.Location;
				if ((!FastTrace(L, L - vect(0,0,300))) && (SWtmp.SetLocation(L)))
				{
//					log(N@L@N.Region.Zone@"-"@SpawnLocCount);
					SpawnLocs[SpawnLocCount] = L;
					++SpawnLocCount;
					if (N.IsA('FlagBase'))
					{
						TeamBases[FlagBase(N).Team] = L;
						++TeamCnt;
					}
				}
			}
		}
	}

	forEach AllActors(class'Decoration', Deco)
	{
		if ((!Deco.Region.Zone.bWaterZone) && (!Deco.Region.Zone.bPainZone) && (!Deco.Region.Zone.bKillZone) && (!Deco.Region.Zone.bDestructive) && (!Deco.Region.Zone.IsA('SkyZoneInfo')) && (Deco != SWtmp))
		{
			if (SpawnLocCount <= 4095)
			{
				L = Deco.Location;
				if ((!FastTrace(L, L - vect(0,0,300))) && (SWtmp.SetLocation(L)) && (NearNavPoint(L)))
				{
//					log(Deco@L@Deco.Region.Zone@"-"@SpawnLocCount);
					SpawnLocs[SpawnLocCount] = L;
					++SpawnLocCount;
				}
			}
		}
	}

	forEach AllActors(class'AmbientSound', AmbS)
	{
		if ((!AmbS.Region.Zone.bWaterZone) && (!AmbS.Region.Zone.bPainZone) && (!AmbS.Region.Zone.bKillZone) && (!AmbS.Region.Zone.bDestructive) && (!AmbS.Region.Zone.IsA('SkyZoneInfo')))
		{
			if (SpawnLocCount <= 4095)
			{
				L = AmbS.Location;
				if ((!FastTrace(L, L - vect(0,0,300))) && (SWtmp.SetLocation(L)) && (NearNavPoint(L)))
				{
//					log(AmbS@L@AmbS.Region.Zone@"-"@SpawnLocCount);
					SpawnLocs[SpawnLocCount] = L;
					++SpawnLocCount;
				}
			}
		}
	}

	forEach AllActors(class'Light', Lb)
	{
		if ((!Lb.Region.Zone.bWaterZone) && (!Lb.Region.Zone.bPainZone) && (!Lb.Region.Zone.bKillZone) && (!Lb.Region.Zone.bDestructive) && (!Lb.Region.Zone.IsA('SkyZoneInfo')))
		{
			if (SpawnLocCount <= 4095)
			{
				L = Lb.Location;
				if ((!FastTrace(L, L - vect(0,0,300))) && (SWtmp.SetLocation(L)) && (NearNavPoint(L)))
				{
//					log(Lb@L@Lb.Region.Zone@"-"@SpawnLocCount);
					SpawnLocs[SpawnLocCount] = L;
					++SpawnLocCount;
				}
			}
		}
	}

	SWtmp.Destroy();
	log("RandomSpawnLoc Init - Spawnpoint count: "$SpawnLocCount@" #Teams: "$TeamCnt);
	SpBaseDist = VSize(TeamBases[0] - TeamBases[1]) * 0.5;
}

function bool NearNavPoint(Vector Loc)
{
	local PathNode P;

	foreach RadiusActors(class'PathNode', P, 300.0, Loc) { return true; }
	return false;
}

function bool ValidTeamLoc(Vector Loc, byte Tnum)
{
	local Vector V;

	if (VSize(TeamBases[Tnum] - Loc) < SpBaseDist) return true;
	return false;
}

function ModifyPlayer(Pawn Other)
{
	local UTTeleportEffect TelEff;
	local PlayerPawn pp;
	local Bot bb;
	local Vector V;
	local int i;
	local byte T;

	Super.ModifyPlayer(Other);

	T = Other.PlayerReplicationInfo.Team;
	foreach RadiusActors(class'UTTeleportEffect', TelEff, 20.0, Other.Location) { TelEff.Destroy(); }
	do
	{
		V = SpawnLocs[Rand(SpawnLocCount)];
		foreach RadiusActors(class'PlayerPawn', pp, 300.0, V) { break; }

		if (pp == None)
		{
			foreach RadiusActors(class'Bot', bb, 300.0, V) { break; }
		}

		if ((pp == None) && (bb == None) && ((TeamCnt == 0) || (!Level.Game.bTeamGame) || (ValidTeamLoc(V, T))))
		{
			Other.SetLocation(V); i = 16;
		}
		else
		{
			++i;
//			log("Spawn attempt #"$i);
		}
	}
	until ((i == 16));

	Level.Game.PlayTeleportEffect(Other, True, True);
}

defaultproperties
{
}
