//*  Random Spawn Location Mutator -- 2013 MrLoathsome *//
//*  Players & Bots will Spawn at "random" locations *//

class RSL expands Mutator;

var Vector SpawnLocs[2048]; // array of "New" SpawnPoints
var int SpawnLocCount;

function PostBeginPlay()
{
   local Actor SWtmp;
   local NavigationPoint N;
   local Inventory Inv;
   local vector L;

	Super.PostBeginPlay();
	N = Level.NavigationPointList;
	While ((SWtmp == None) && (N != NONE))
	{
		SWtmp = spawn(class'UnrealShare.SteelBarrel',,,N.Location);
		N = N.NextNavigationPoint;
	}
	SWtmp.SetCollisionSize(17, 39);
	for (N = Level.NavigationPointList; N != NONE; N = N.NextNavigationPoint)
	{
//	**Initial version included SpawnPoints/PlayerStarts in the location array.   I excluded those as they will be the default if the attempted relocation fails....
//		if ((N.IsA('PathNode') || N.IsA('SpawnPoint') || N.IsA('PlayerStart')) && !N.Region.Zone.bWaterZone)
		if (N.IsA('PathNode') && !N.Region.Zone.bWaterZone)
		{
			if (SpawnLocCount <= 2047)
			{
				if (SWtmp.SetLocation(N.Location))
				{
					SpawnLocs[SpawnLocCount] = N.Location;
					SpawnLocCount++;
				}
			}
		}
	}
	forEach AllActors(class'Inventory', Inv)
	{
		if ((!Inv.Region.Zone.bWaterZone) && (!Inv.Region.Zone.bPainZone))
		{
			if (SpawnLocCount <= 2047)
			{
				L = Inv.Location;   L.z = L.z + 90;
				if (SWtmp.SetLocation(Inv.Location))
				{
					SpawnLocs[SpawnLocCount] = Inv.Location;
					SpawnLocs[SpawnLocCount].Z = SpawnLocs[SpawnLocCount].Z + 90;
					SpawnLocCount++;
				}

			}
		}
	}

	SWtmp.Destroy();
	log("RandomSpawnLoc Init - Spawnpoint count: "$SpawnLocCount);
}

function ModifyPlayer(Pawn Other)
{
	local UTTeleportEffect TelEff;

	Super.ModifyPlayer(Other);

	foreach RadiusActors(class'UTTeleportEffect', TelEff, 20.0, Other.Location) { TelEff.Destroy(); } ;

	If (Other.SetLocation(SpawnLocs[Rand(SpawnLocCount)]))		
		Level.Game.PlayTeleportEffect(Other, True, True);
}

defaultproperties
{
}
