// QFeedBack for MonsterHunt
// Modification of original QFeedBack by Scott "Frood" Shingler
// By Ti-Lung 18/08/2007
// Version 1.0 - 20070801
// Created for the Smiling Monsters community
// http://www.smiling-monsters.com/community/

class QFeedBackMH expands Mutator;

#exec AUDIO IMPORT FILE="Sounds\QFeedbackWav.wav" NAME="QFeedbackWav" GROUP="QFeedback"
#exec AUDIO IMPORT FILE="Sounds\QFeedbackArmourWav.wav" NAME="QFeedbackArmourWav" GROUP="QFeedback"
#exec AUDIO IMPORT FILE="Sounds\QFeedbackTeamWav.wav" NAME="QFeedbackTeamWav" GROUP="QFeedback"

// Config variable
var config float HitVolume;

var bool bInitialized;

function PostBeginPlay()
{
	if (bInitialized)
		return;

	bInitialized = True;

	log("Mutator initialized.",'QFeedBackMH');

	if( !Level.Game.IsA('MonsterHunt') )
	{
		log("This mutator is for MonsterHunt and will not work properly on other gametype",'QFeedBackMH');
		log("The gametype is now"@Level.Game.GameName,'QFeedBackMH');
	}

	Level.Game.RegisterDamageMutator(Self);

	// If there is another mutator execute the postbeginplay
	if ( NextMutator != None )
		NextMutator.PostBeginPlay();
}

function MutatorTakeDamage( out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
	if ( InstigatedBy.IsA('PlayerPawn') && (Victim != InstigatedBy) )
	{
		// When player shoot other player
		if( Victim.IsA('PlayerPawn') || Victim.IsA('Bot') )
		{
			// Play sound on all slot except talk so incoming sound does not interfere
			// Remove Playsound Slot_Ambient to stop native error on server
			PlayerPawn(InstigatedBy).PlaySound(Sound'QFeedbackTeamWav', SLOT_None, HitVolume, false);
			PlayerPawn(InstigatedBy).PlaySound(Sound'QFeedbackTeamWav', SLOT_Interface, HitVolume, false);
			PlayerPawn(InstigatedBy).PlaySound(Sound'QFeedbackTeamWav', SLOT_Interact, HitVolume, false);
			// PlayerPawn(InstigatedBy).PlaySound(Sound'QFeedbackTeamWav', SLOT_Misc, HitVolume, false);
		}

		// When player shoot ScriptedPawn
		if( Victim.IsA('ScriptedPawn') )
		{
			// Nali and animal are friends
			if(
				Victim.IsA('Nali')
				|| Victim.IsA('NaliPriest')
				|| Victim.IsA('Cow')
				|| Victim.IsA('BabyCow')
				|| Victim.IsA('NaliRabbit')
			)
			{
				PlayerPawn(InstigatedBy).PlaySound(Sound'QFeedbackTeamWav', SLOT_None, HitVolume, false);
				PlayerPawn(InstigatedBy).PlaySound(Sound'QFeedbackTeamWav', SLOT_Interface, HitVolume, false);
				PlayerPawn(InstigatedBy).PlaySound(Sound'QFeedbackTeamWav', SLOT_Interact, HitVolume, false);
				// PlayerPawn(InstigatedBy).PlaySound(Sound'QFeedbackTeamWav', SLOT_Misc, HitVolume, false);
			}
			else // ScriptedPawn is ennemy
			{
				PlayerPawn(InstigatedBy).PlaySound(Sound'QFeedbackWav', SLOT_None, HitVolume, false);
				PlayerPawn(InstigatedBy).PlaySound(Sound'QFeedbackWav', SLOT_Interface, HitVolume, false);
				PlayerPawn(InstigatedBy).PlaySound(Sound'QFeedbackWav', SLOT_Interact, HitVolume, false);
				// PlayerPawn(InstigatedBy).PlaySound(Sound'QFeedbackWav', SLOT_Misc, HitVolume, false);
			}
		}
	}

	// Go to next Damage mutator
	if ( NextDamageMutator != None )
		NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType );
}

defaultproperties
{
    HitVolume=16.0
}
