<?php

class UPackage {
	
	private static $uSignature = 0x9E2A83C1;
	private static $validVersions = array(69);
	
	private static $loadedPackage = false;
	private static $header = null;
	private static $packageVersion = null;
	private static $nameTable = null;
	private static $importTable = null;
	private static $exportTable = null;
	private static $dependencies = null;
	
	
	
	
	public static function loadPackage($package_path){
		if (is_null($package_path) || empty($package_path))
			throw new Exception("package_path empty!", 1);
			
		self::reset();
		self::$loadedPackage = file_get_contents($package_path);
		if (self::$loadedPackage === false)
			throw new Exception("Loading of package $package_path failed.", 2);
			
		self::loadHeader();
		if (self::getSignature() != self::$uSignature){
			self::reset();
			throw new Exception("Invalid package signature.", 3);
		}
		
		self::$packageVersion = self::getVersion();
		if (!in_array(self::$packageVersion, self::$validVersions)){
			$msgVersion = self::$packageVersion;
			self::reset();
			throw new Exception("Invalid package version: $msgVersion.", 4);
		}
	}
	

	public static function reset(){
		self::$loadedPackage = false;
		self::$nameTable = null;
		self::$importTable = null;
		self::$exportTable = null;
		self::$header = null;
		self::$packageVersion = null;
		self::$dependencies = null;
	}
	
	
	protected static function loadHeader(){
		if (is_null(self::$header))
			self::$header = self::getHeader();
	}
	
	
	public static function getValue(&$data, $struct_type, $returnHex=false){
		
		switch ($struct_type){
			case 'u_signature':		$offset = 0;	$dl = 4; 	break;
			case 'package_version':	$offset = 4; 	$dl = 2;	break;
			case 'license_mode': 	$offset = 6;	$dl = 2; 	break;
			case 'u_flags': 		$offset = 8; 	$dl = 4;	break;
			case 'name_count': 		$offset = 12; 	$dl = 4;	break;
			case 'name_table': 		$offset = 16; 	$dl = 4;	break;
			case 'export_count': 	$offset = 20; 	$dl = 4;	break;
			case 'export_table': 	$offset = 24; 	$dl = 4;	break;
			case 'import_count': 	$offset = 28; 	$dl = 4;	break;
			case 'import_table': 	$offset = 32; 	$dl = 4;	break;
			default:
				return false;
		}
	
		$ref = substr($data, $offset, $dl);
		$hexArray = array();
		for ($i = 0; $i<strlen($ref); $i++)
			$hexArray[] = dechex(ord(substr($ref, $i, 1)));
		$value = implode('', array_reverse($hexArray));
		if (!$returnHex)
			return hexdec($value);
		return $value;
	}
	
	
	public static function getCompactedIndex($data, &$l=0)
	{
		$l = self::getCompactedIndexLength($data);
		$output = 0;
		$signed = false;
		for ($i = 0; $i < $l; $i++){
			$x = ord(substr($data, $i, 1));
			if($i == 0){
				$signed = (($x & 0x80) > 0);
				$output |= ($x & 0x3F);
			}
			else if($i == 4)
				$output |= ($x & 0x1F) << (6 + (3 * 7));
			else
				$output |= ($x & 0x7F) << (6 + (($i - 1) * 7));
		}
		return ($signed) ? -1*$output : $output;
	}
	
	
	public static function getCompactedIndexLength($data)
	{
		for ($i = 0; $i < 4; $i++){
			$b = ord(substr($data, $i, 1));
			if (($i == 0 && ($b & 0x40)==0) || ($i > 0 && ($b & 0x80)==0))
				return ($i+1);
		}
		return 5;
	}
	
	
	public static function getPiece(&$data, $offset=0, $word_type='WORD'){
		switch ($word_type){
			case 'BYTE':	$l = 1;		break;
			case 'WORD':	$l = 2;		break;
			case 'DWORD':	$l = 4;		break;
			case 'INDEX':	$l = 5;		break;
			case 'QWORD':	$l = 8;		break;
			default:
				return null;
		}
		return substr($data, $offset, $l);
	}
	
	
	public static function getWord($data, $word_type='WORD')
	{
		switch ($word_type){
			case 'BYTE':	$l = 1;		break;
			case 'WORD':	$l = 2;		break;
			case 'DWORD':	$l = 4;		break;
			case 'QWORD':	$l = 8;		break;
			default:
				return null;
		}

		$hexArray = array();
		for ($i = 0; $i < $l; $i++)
			$hexArray[] = dechex(ord(substr($data, $i, 1)));
		return hexdec(implode(array_reverse($hexArray)));
	}
	
	
	public static function getHeader(){
		if (self::$loadedPackage === false)
			return null;
		return substr(self::$loadedPackage, 0, 36);
	}
	
	
	public static function getSignature($bHumanReadable=false){
		if (self::$loadedPackage === false)
			return null;
		self::loadHeader();
		return self::getValue(self::$header, 'u_signature', $bHumanReadable);
	}
	
	
	public static function getVersion($bHumanReadable=false){
		if (self::$loadedPackage === false)
			return null;
		self::loadHeader();
		return self::getValue(self::$header, 'package_version', $bHumanReadable);
	}
	
	
	public static function getNameCount(){
		if (self::$loadedPackage === false)
			return null;
		self::loadHeader();
		return self::getValue(self::$header, 'name_count');
	}
	
	
	public static function getNameTable(){
		if (!is_null(self::$nameTable))
			return self::$nameTable;
		if (self::$loadedPackage === false)
			return null;
		self::loadHeader();
		
		$tOffset = self::getValue(self::$header, 'name_table');
		$namesLeft = $namesCount = self::getNameCount();
		$iterationControl = $i = 0;
		$packageSize = strlen(self::$loadedPackage);
		$names = array();
		
		while ($namesLeft > 0 && $iterationControl <= $packageSize){
			$namesBody = substr(self::$loadedPackage, $tOffset + $i, 10000);
			$m = array();
			preg_match_all('/[\x21-\x7E]+\x00/', $namesBody, $m);
			$namesLeft -= sizeof($m[0]);
			$names[] = implode(',', $m[0]);
		
			if (strlen($namesBody) == 10000 && preg_match('/[\x21-\x7E]+/', substr($namesBody, 9999, 1)) == 1){
				$j = 10000;
				while (preg_match('/[\x21-\x7E]+/', substr($namesBody, $j-1, 1)) == 1){
					$i--; $j--;
				}
			}
			
			$i += 10000;
			$iterationControl += 1000;
		}
		
		$names = str_ireplace("\x00", '', implode(',', $names));
		$namesTable = explode(',', $names);
		if (sizeof($namesTable) > $namesCount)
			$namesTable = array_slice($namesTable, 0, $namesCount);
		self::$nameTable = $namesTable;
		unset($m, $namesBody, $names, $tOffset, $packageSize, $namesTable);
		return self::$nameTable;
	}
	
	
	public static function getImportCount(){
		if (self::$loadedPackage === false)
			return null;
		self::loadHeader();
		return self::getValue(self::$header, 'import_count');
	}
	
	
	public static function getImportTable(){
		if (!is_null(self::$importTable))
			return self::$importTable;
		if (self::$loadedPackage === false)
			return null;
		self::loadHeader();
			
		$tOffset = self::getValue(self::$header, 'import_table');
		$importSize = self::getImportCount();
		$importData = substr(self::$loadedPackage, $tOffset, $importSize*19);
		$importDataTable = array();
		$lastMainIndex = $l = 0;
		
		for ($i = 0; $i < $importSize; $i++)
		{
			$subImportData = substr($importData, 0, 19);
			$importDataTable[$i]['ClassPkgIndex'] = self::getCompactedIndex(self::getPiece($subImportData, $lastMainIndex, 'INDEX'), $l);
			$lastMainIndex += $l;
			$importDataTable[$i]['ClassNameIndex'] = self::getCompactedIndex(self::getPiece($subImportData, $lastMainIndex, 'INDEX'), $l);
			$lastMainIndex += $l;
			$importDataTable[$i]['PackageObjIndex'] = self::getWord(self::getPiece($subImportData, $lastMainIndex, 'DWORD'), 'DWORD');
			$lastMainIndex += 4;
			$importDataTable[$i]['ObjNameIndex'] = self::getCompactedIndex(self::getPiece($subImportData, $lastMainIndex, 'INDEX'), $l);
			$lastMainIndex += $l;
			$importData = substr($importData, $lastMainIndex);
			$lastMainIndex = 0;
		}
		
		self::$importTable = $importDataTable;
		unset($importData, $subImportData, $importDataTable);
		return self::$importTable;
	}
	
	
	public static function getExportCount(){
		if (self::$loadedPackage === false)
			return null;
		self::loadHeader();
		return self::getValue(self::$header, 'export_count');
	}
	
	
	public static function getExportTable(){
		if (!is_null(self::$exportTable))
			return self::$exportTable;
		if (self::$loadedPackage === false)
			return null;
		self::loadHeader();
		
		$tOffset = self::getValue(self::$header, 'export_table');
		$exportSize = self::getExportCount();
		$exportData = substr(self::$loadedPackage, $tOffset, $exportSize*33);
		$exportDataTable = array();
		$lastMainIndex = $l = 0;
		
		for ($i = 0; $i < $exportSize; $i++)
		{
			$subExportData = substr($exportData, 0, 33);
		
			$exportDataTable[$i]['ClassIndex'] = self::getCompactedIndex(self::getPiece($subExportData, $lastMainIndex, 'INDEX'), $l);
			$lastMainIndex += $l;
			$exportDataTable[$i]['SuperIndex'] = self::getCompactedIndex(self::getPiece($subExportData, $lastMainIndex, 'INDEX'), $l);
			$lastMainIndex += $l;
			$exportDataTable[$i]['PackageIndex'] = self::getWord(self::getPiece($subExportData, $lastMainIndex, 'DWORD'), 'DWORD');
			$lastMainIndex += 4;
			$exportDataTable[$i]['ObjNameIndex'] = self::getCompactedIndex(self::getPiece($subExportData, $lastMainIndex, 'INDEX'), $l);
			$lastMainIndex += $l;
			$exportDataTable[$i]['ObjFlags'] = self::getWord(self::getPiece($subExportData, $lastMainIndex, 'DWORD'), 'DWORD');
			$lastMainIndex += 4;
			$exportDataTable[$i]['SerialSize'] = self::getCompactedIndex(self::getPiece($subExportData, $lastMainIndex, 'INDEX'), $l);
			$lastMainIndex += $l;
			if ($exportDataTable[$i]['SerialSize'] > 0){
				$exportDataTable[$i]['SerialOffset'] = self::getCompactedIndex(self::getPiece($subExportData, $lastMainIndex, 'INDEX'), $l);
				$lastMainIndex += $l;
			}
			$exportData = substr($exportData, $lastMainIndex);
			$lastMainIndex = 0;
		}
		
		self::$exportTable = $exportDataTable;
		unset($exportData, $subExportData, $exportDataTable);
		return self::$exportTable;
	}
	
	
	public static function getDependencies(){
		if (!is_null(self::$dependencies))
			return self::$dependencies;
		if (self::$loadedPackage === false)
			return null;
			
		self::getNameTable();
		self::getImportTable();
		
		$dependencies = array();
		foreach (self::$importTable as $i=>&$importRegistry){
			if (self::$nameTable[$importRegistry['ClassNameIndex']] == "Package" && $importRegistry['PackageObjIndex'] == 0)
				$dependencies[] = self::$nameTable[$importRegistry['ObjNameIndex']];
		}
		
		self::$dependencies = $dependencies;
		unset($dependencies);
		return self::$dependencies;
	}
}