/**************************************************************************************************
 *
 *  NSE. Nexgen Clientside Extensions by {LSN}Meindratheal.
 *
 *  $CLASS        NCEClient
 *  $VERSION      1.01 (28-02-2011 18:18)
 *  $AUTHOR       {LSN}Meindratheal
 *  $DESCRIPTION  Nexgen Clientside Extension client.
 *
 **************************************************************************************************/
class NCEClient extends NexgenClientController;

var ChallengeHUD MyHUD;

var byte RetryTickCount;

/***************************************************************************************************
 *
 *  $DESCRIPTION  Called when the NexgenClient has received its initial replication info is has
 *                been initialized. At this point it's safe to use all functions of the client.
 *
 **************************************************************************************************/
simulated function clientInitialized()
{
	MyHUD = ChallengeHUD(client.player.myHUD);
}

/***************************************************************************************************
 *
 *  $DESCRIPTION  Synchronizes the bShowinfo variable, so that the ServerInfo page will show.
 *
 **************************************************************************************************/
simulated function Tick(float Delta)
{
	if(Role == ROLE_Authority)	return;
	if(NexgenHudWrapper(MyHUD) != None && NexgenHudWrapper(MyHUD).originalHUD != None)
	{
		NexgenHUDWrapper(MyHUD).originalHUD.bShowInfo = NexgenHudWrapper(MyHUD).bShowInfo;
		return;
	}
	else if(NexgenHudWrapperT(MyHUD) != None && NexgenHudWrapperT(MyHUD).originalHUD != None)
	{
		NexgenHUDWrapperT(MyHUD).originalHUD.bShowInfo = NexgenHudWrapperT(MyHUD).bShowInfo;
		return;
	}
	else if(RetryTickCount % 8 == 0 && client != None && client.player != None)
	{
		MyHUD = ChallengeHUD(client.player.myHUD);
	}
	RetryTickCount++;
}

/***************************************************************************************************
 *
 *  $DESCRIPTION  Default properties block.
 *
 **************************************************************************************************/
defaultproperties
{
    ctrlID="NexgenExtensionsClient"
}