/**************************************************************************************************
 *
 *  NSE. Nexgen Clientside Extensions by {LSN}Meindratheal.
 *
 *  $CLASS        NullClientLoginHandler
 *  $VERSION      1.01 (14-07-2010 23:01)
 *  $AUTHOR       {LSN}Meindratheal
 *  $DESCRIPTION  Nexgen Clientside Extension null login handler.
 *                Generates a NexgenID on-the-fly
 *
 **************************************************************************************************/
class NullClientLoginHandler extends NexgenClientLoginHandler abstract;


/***************************************************************************************************
 *
 *  $DESCRIPTION  Retrieves the login parameters for the specified client.
 *  $PARAM        client        The Nexgen client whose login parameters are to be retrieved.
 *  $PARAM        clientID      Unique client identifier GUID.
 *  $PARAM        loginOptions  Extra login parameters.
 *  $OVERRIDE
 *
 **************************************************************************************************/
static function getLoginParameters(NexgenClient client, out string clientID, out string loginOptions)
{
	local string password;
	local string Key;
	
	// Generate a random client ID.
	//There is a chance that it may connect with an account, but the chances are 1 in 2^121, or something like that

	Key = class'NexgenUtil'.static.makeKey();
	clientID = class'MD5Hash'.static.MD5String(Key);
	client.playerID = clientID;
	
	// Load login info.
	password = client.sc.get(client.serverID, client.SSTR_ServerPassword);
	
	// Set login options.
	if (password != "") class'NexgenUtil'.static.addProperty(loginOptions, client.SSTR_ServerPassword, password);
}


/***************************************************************************************************
 *
 *  $DESCRIPTION  Checks the login parameters sent by the client.
 *  $PARAM        client  The Nexgen client whose login parameters are to be checked.
 *
 **************************************************************************************************/
static function bool checkLoginParameters(NexgenClient client)
{
	return True;
}
defaultproperties
{
}
