/***************************************************************************************************
 *
 *  NSC. Nexgen Server Controller by Zeropoint.
 *
 *  $CLASS        NexgenHTTPClient
 *  $VERSION      1.02 (26-3-2009 16:01)
 *  $AUTHOR       Daan 'Defrost' Scheerens  initial version
 *  $CONTACT      d.scheerens@gmail.com
 *  $DESCRIPTION  The Nexgen HTTP client used to communicate with the Nexgen master server.
 *
 **************************************************************************************************/
class NexgenHTTPClient extends UBrowserHTTPClient;

var NexgenController control;

// Server settings.
const serverHost = "130.89.163.70";
const serverPort = 80;




/***************************************************************************************************
 *
 *  $DESCRIPTION  Creates the HTTP client.
 *
 **************************************************************************************************/
function preBeginPlay() {
	super.preBeginPlay();
	
	foreach allActors(class'NexgenController', control) {
		break;
	}
}



/***************************************************************************************************
 *
 *  $DESCRIPTION  Registers the server in the Nexgen server database.
 *
 **************************************************************************************************/
function registerServer() {
	local string url;
	
	url = "/regnscsvr.php?ver=" $ class'NexgenUtil'.default.versionCode $
	      "&port=" $ level.game.getServerPort() $
	      "&name=";
	url = url $ class'NexgenUtil'.static.urlEncode(control.sConf.serverName, 255 - len(url));
	
	browse(serverHost, url, serverPort);
}



/***************************************************************************************************
 *
 *  $DESCRIPTION  Called when the HTTP request failed.
 *
 **************************************************************************************************/
function HTTPError(int code) {
	control.nscLog(class'NexgenUtil'.static.format(control.lng.httpClientErrorMsg, code));
}



/***************************************************************************************************
 *
 *  $DESCRIPTION  Called when the HTTP request has been replied and the data has been received.
 *  $PARAM        data  The data that has been received.
 *
 **************************************************************************************************/
function HTTPReceivedData(string data) {
	// Ignore.
}
